/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.MethodExecutionResult;
import fitnesse.slim.MethodExecutor;
import fitnesse.slim.SystemUnderTest;
import java.lang.reflect.Field;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemUnderTestMethodExecutor
extends MethodExecutor {
    private final Map<String, Object> instances;

    public SystemUnderTestMethodExecutor(Map<String, Object> instances) {
        this.instances = instances;
    }

    @Override
    public MethodExecutionResult execute(String instanceName, String methodName, Object[] args) throws Throwable {
        Object instance = this.instances.get(instanceName);
        if (instance == null) {
            return MethodExecutionResult.noInstance(instanceName);
        }
        Field field = this.findSystemUnderTest(instance.getClass());
        if (field != null) {
            Object systemUnderTest = field.get(instance);
            return this.findAndInvoke(methodName, args, systemUnderTest);
        }
        return MethodExecutionResult.noMethod(methodName, instance.getClass(), args.length);
    }

    private Field findSystemUnderTest(Class<?> k) {
        Field[] fields;
        for (Field field : fields = k.getDeclaredFields()) {
            if (!this.isSystemUnderTest(field)) continue;
            return field;
        }
        return null;
    }

    private boolean isSystemUnderTest(Field field) {
        return "systemUnderTest".equals(field.getName()) || field.getAnnotation(SystemUnderTest.class) != null;
    }
}

