/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableStore {
    private Map<String, Object> variables = new HashMap<String, Object>();
    private Matcher symbolMatcher;

    public void setVariable(String name, Object value) {
        this.variables.put(name, value);
    }

    public Object[] replaceVariables(Object[] args) {
        Object[] result = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            result[i] = this.replaceVariable(args[i]);
        }
        return result;
    }

    private List<Object> replaceArgsInList(List<Object> objects) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object object : objects) {
            result.add(this.replaceVariable(object));
        }
        return result;
    }

    private Object replaceVariable(Object object) {
        if (object instanceof List) {
            return this.replaceArgsInList((List)object);
        }
        return this.replaceVariablesInString((String)object);
    }

    private Object replaceVariablesInString(String arg) {
        Pattern symbolPattern = Pattern.compile("\\$([a-zA-Z]\\w*)");
        int startingPosition = 0;
        while (!"".equals(arg) && null != arg) {
            this.symbolMatcher = symbolPattern.matcher(arg);
            if (!this.symbolMatcher.find(startingPosition)) break;
            String symbolName = this.symbolMatcher.group(1);
            arg = this.replaceSymbolInArg(arg, symbolName);
            startingPosition = this.symbolMatcher.start(1);
        }
        return arg;
    }

    private String replaceSymbolInArg(String arg, String symbolName) {
        if (this.variables.containsKey(symbolName)) {
            String replacement = (String)this.variables.get(symbolName);
            if (replacement == null) {
                replacement = "null";
            }
            arg = arg.substring(0, this.symbolMatcher.start()) + replacement + arg.substring(this.symbolMatcher.end());
        }
        return arg;
    }
}

