/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.converters;

import java.beans.PropertyEditorSupport;
import java.util.HashMap;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapEditor
extends PropertyEditorSupport {
    private NodeList nodes;
    private NodeList tables;

    public String toString(Object o) {
        return "TILT";
    }

    @Override
    public void setAsText(String s) throws IllegalArgumentException {
        this.setValue(this.fromString(s));
    }

    public Object fromString(String possibleTable) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.tableIsValid(possibleTable)) {
            this.extractRowsIntoMap(map, this.tables);
        }
        return map;
    }

    private boolean tableIsValid(String possibleTable) {
        if (this.isValidHtml(possibleTable)) {
            return this.hasOneTable();
        }
        return false;
    }

    private boolean hasOneTable() {
        TagNameFilter tableFilter = new TagNameFilter("table");
        this.tables = this.nodes.extractAllNodesThatMatch((NodeFilter)tableFilter);
        return this.tables.size() == 1;
    }

    private boolean isValidHtml(String possibleTable) {
        this.nodes = this.parseHtml(possibleTable);
        return this.nodes != null;
    }

    private void extractRowsIntoMap(HashMap<String, String> map, NodeList tables) {
        this.extractRows(map, this.getRows(tables));
    }

    private void extractRows(HashMap<String, String> map, NodeList rows) {
        for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
            this.extractRow(map, rows, rowIndex);
        }
    }

    private void extractRow(HashMap<String, String> map, NodeList rows, int rowIndex) {
        Node row = rows.elementAt(rowIndex);
        if (row != null) {
            this.extractColumns(map, row);
        }
    }

    private void extractColumns(HashMap<String, String> map, Node row) {
        NodeList cols;
        TagNameFilter tdFilter = new TagNameFilter("td");
        if (row.getChildren() != null && (cols = row.getChildren().extractAllNodesThatMatch((NodeFilter)tdFilter)).size() == 2) {
            this.addColsToMap(map, cols);
        }
    }

    private void addColsToMap(HashMap<String, String> map, NodeList cols) {
        String key = this.getText(cols.elementAt(0));
        String value = this.getText(cols.elementAt(1));
        map.put(key, value);
    }

    private NodeList getRows(NodeList tables) {
        TagNameFilter trFilter = new TagNameFilter("tr");
        Node table = tables.elementAt(0);
        if (table.getChildren() != null) {
            return table.getChildren().extractAllNodesThatMatch((NodeFilter)trFilter);
        }
        return new NodeList();
    }

    private String getText(Node compositeNode) {
        return ((CompositeTag)compositeNode).getChildrenHTML();
    }

    private NodeList parseHtml(String possibleTable) {
        try {
            Parser parser = new Parser(possibleTable);
            return parser.parse(null);
        }
        catch (ParserException e) {
            return null;
        }
    }
}

