/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slimTables;

import fitnesse.responders.run.slimResponder.SlimTestContext;
import fitnesse.slimTables.ScenarioTable;
import fitnesse.slimTables.SlimTable;
import fitnesse.slimTables.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionTable
extends SlimTable {
    private static final String instancePrefix = "decisionTable";
    private Set<String> dontReportExceptionsInTheseInstructions = new HashSet<String>();

    public DecisionTable(Table table, String id, SlimTestContext context) {
        super(table, id, context);
    }

    @Override
    protected String getTableType() {
        return instancePrefix;
    }

    @Override
    public void appendInstructions() {
        if (this.table.getRowCount() == 2) {
            throw new SlimTable.SyntaxError("DecisionTables should have at least three rows.");
        }
        String scenarioName = this.getScenarioName();
        ScenarioTable scenario = this.getTestContext().getScenario(scenarioName);
        if (scenario != null) {
            new ScenarioCaller().call(scenario);
        } else {
            new FixtureCaller().call(this.getFixtureName());
        }
    }

    private String getScenarioName() {
        StringBuffer nameBuffer = new StringBuffer();
        for (int nameCol = 0; nameCol < this.table.getColumnCountInRow(0); nameCol += 2) {
            if (nameCol == 0) {
                nameBuffer.append(this.getFixtureName(this.table.getCellContents(nameCol, 0)));
            } else {
                nameBuffer.append(this.table.getCellContents(nameCol, 0));
            }
            nameBuffer.append(" ");
        }
        return SlimTable.Disgracer.disgraceClassName(nameBuffer.toString().trim());
    }

    @Override
    public void evaluateReturnValues(Map<String, Object> returnValues) {
    }

    @Override
    public boolean shouldIgnoreException(String resultKey, String resultString) {
        boolean shouldNotReport = this.dontReportExceptionsInTheseInstructions.contains(resultKey);
        boolean isNoSuchMethodException = resultString.indexOf("NO_METHOD_IN_CLASS") != -1;
        return shouldNotReport && isNoSuchMethodException;
    }

    private class FixtureCaller
    extends DecisionTableCaller {
        private FixtureCaller() {
        }

        public void call(String fixtureName) {
            DecisionTable.this.constructFixture(fixtureName);
            DecisionTable.this.dontReportExceptionsInTheseInstructions.add(DecisionTable.this.callFunction(DecisionTable.this.getTableName(), "table", DecisionTable.this.tableAsList()));
            if (DecisionTable.this.table.getRowCount() > 2) {
                this.invokeRows();
            }
        }

        private void invokeRows() {
            this.gatherFunctionsAndVariablesFromColumnHeader();
            for (int row = 2; row < DecisionTable.this.table.getRowCount(); ++row) {
                this.invokeRow(row);
            }
        }

        private void invokeRow(int row) {
            this.checkRow(row);
            this.callUnreportedFunction("reset");
            this.setVariables(row);
            this.callUnreportedFunction("execute");
            this.callFunctions(row);
        }

        private void callUnreportedFunction(String functionName) {
            DecisionTable.this.dontReportExceptionsInTheseInstructions.add(DecisionTable.this.callFunction(DecisionTable.this.getTableName(), functionName, new Object[0]));
        }

        private void callFunctions(int row) {
            for (String functionName : this.funcsLeftToRight) {
                this.callFunctionInRow(functionName, row);
            }
        }

        private void callFunctionInRow(String functionName, int row) {
            int col = (Integer)this.funcs.get(functionName);
            String assignedSymbol = DecisionTable.this.ifSymbolAssignment(row, col);
            if (assignedSymbol != null) {
                DecisionTable.this.addExpectation(new SlimTable.SymbolAssignmentExpectation(DecisionTable.this, assignedSymbol, DecisionTable.this.getInstructionTag(), col, row));
                DecisionTable.this.callAndAssign(assignedSymbol, functionName);
            } else {
                this.setFunctionCallExpectation(col, row);
                DecisionTable.this.callFunction(DecisionTable.this.getTableName(), functionName, new Object[0]);
            }
        }

        private void setFunctionCallExpectation(int col, int row) {
            DecisionTable.this.table.getCellContents(col, row);
            DecisionTable.this.addExpectation(new SlimTable.ReturnedValueExpectation(DecisionTable.this, DecisionTable.this.getInstructionTag(), col, row));
        }

        private void setVariables(int row) {
            for (String var : this.varsLeftToRight) {
                int col = (Integer)this.vars.get(var);
                String valueToSet = DecisionTable.this.table.getUnescapedCellContents(col, row);
                this.setVariableExpectation(col, row);
                List<Object> setInstruction = DecisionTable.this.prepareInstruction();
                DecisionTable.this.addCall(setInstruction, DecisionTable.this.getTableName(), "set " + var);
                setInstruction.add(valueToSet);
                DecisionTable.this.addInstruction(setInstruction);
            }
        }

        private void setVariableExpectation(int col, int row) {
            DecisionTable.this.addExpectation(new SlimTable.VoidReturnExpectation(DecisionTable.this, DecisionTable.this.getInstructionTag(), col, row));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScenarioCaller
    extends DecisionTableCaller {
        private ScenarioCaller() {
        }

        public void call(ScenarioTable scenario) {
            this.gatherFunctionsAndVariablesFromColumnHeader();
            for (int row = 2; row < DecisionTable.this.table.getRowCount(); ++row) {
                this.callScenarioForRow(scenario, row);
            }
        }

        private void callScenarioForRow(ScenarioTable scenario, int row) {
            this.checkRow(row);
            scenario.call(this.getArgumentsForRow(row), DecisionTable.this, row);
        }

        private Map<String, String> getArgumentsForRow(int row) {
            HashMap<String, String> scenarioArguments = new HashMap<String, String>();
            for (String var : this.vars.keySet()) {
                String disgracedVar = SlimTable.Disgracer.disgraceMethodName(var);
                int col = (Integer)this.vars.get(var);
                String valueToSet = DecisionTable.this.table.getUnescapedCellContents(col, row);
                scenarioArguments.put(disgracedVar, valueToSet);
            }
            return scenarioArguments;
        }
    }

    private class DecisionTableCaller {
        protected Map<String, Integer> vars = new HashMap<String, Integer>();
        protected Map<String, Integer> funcs = new HashMap<String, Integer>();
        protected List<String> varsLeftToRight = new ArrayList<String>();
        protected List<String> funcsLeftToRight = new ArrayList<String>();
        protected int columnHeaders;

        private DecisionTableCaller() {
        }

        protected void gatherFunctionsAndVariablesFromColumnHeader() {
            this.columnHeaders = DecisionTable.this.table.getColumnCountInRow(1);
            for (int col = 0; col < this.columnHeaders; ++col) {
                this.putColumnHeaderInFunctionOrVariableList(col);
            }
        }

        private void putColumnHeaderInFunctionOrVariableList(int col) {
            String cell = DecisionTable.this.table.getCellContents(col, 1);
            if (cell.endsWith("?") || cell.endsWith("!")) {
                String funcName = cell.substring(0, cell.length() - 1);
                this.funcsLeftToRight.add(funcName);
                this.funcs.put(funcName, col);
            } else {
                this.varsLeftToRight.add(cell);
                this.vars.put(cell, col);
            }
        }

        protected void checkRow(int row) {
            int columns = DecisionTable.this.table.getColumnCountInRow(row);
            if (columns < this.columnHeaders) {
                throw new SlimTable.SyntaxError(String.format("Table has %d header column(s), but row %d only has %d column(s).", this.columnHeaders, row, columns));
            }
        }
    }
}

