/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slimTables;

import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.slim.SlimError;
import fitnesse.slimTables.Table;
import fitnesse.wikitext.Utils;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.Tag;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.tags.CompositeTag;
import org.htmlparser.tags.Div;
import org.htmlparser.tags.TableColumn;
import org.htmlparser.tags.TableHeader;
import org.htmlparser.tags.TableRow;
import org.htmlparser.tags.TableTag;
import org.htmlparser.util.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlTable
implements Table {
    private static final Random RANDOM_GENERATOR = new SecureRandom();
    private static Pattern coloredCellPattern = Pattern.compile("<span class=\"(\\w*)\">(.*)(</span>)");
    private List<Row> rows = new ArrayList<Row>();
    private TableTag tableNode;

    public HtmlTable(TableTag tableNode) {
        this.tableNode = tableNode;
        NodeList nodeList = tableNode.getChildren();
        for (int i = 0; i < nodeList.size(); ++i) {
            Node node = nodeList.elementAt(i);
            if (!(node instanceof TableRow) && !(node instanceof TableHeader)) continue;
            this.rows.add(new Row((CompositeTag)node));
        }
    }

    public TableTag getTableNode() {
        return this.tableNode;
    }

    @Override
    public void setName(String tableName) {
        this.tableNode.setAttribute("table_name", tableName);
    }

    @Override
    public String getCellContents(int columnIndex, int rowIndex) {
        return this.rows.get(rowIndex).getColumn(columnIndex).getContent();
    }

    @Override
    public String getCellResult(int col, int row) {
        return this.rows.get(row).getColumn(col).getResult();
    }

    @Override
    public String getUnescapedCellContents(int col, int row) {
        return Utils.unescapeHTML(this.getCellContents(col, row));
    }

    @Override
    public void appendToCell(int col, int row, String message) {
        Cell cell = this.rows.get(row).getColumn(col);
        cell.setContent(cell.getEscapedContent() + message);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCountInRow(int rowIndex) {
        return this.rows.get(rowIndex).getColumnCount();
    }

    @Override
    public void setCell(int col, int row, String contents) {
        this.rows.get(row).getColumn(col).setContent(contents);
    }

    public List<List<String>> asList() {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        for (Row row : this.rows) {
            list.add(row.asList());
        }
        return list;
    }

    @Override
    public String toString() {
        return this.asList().toString();
    }

    @Override
    public String toHtml() {
        return this.tableNode.toHtml();
    }

    @Override
    public int addRow(List<String> list) throws Exception {
        Row row = new Row();
        this.rows.add(row);
        this.tableNode.getChildren().add((Node)row.getRowNode());
        for (String s : list) {
            row.appendCell(s == null ? "" : s);
        }
        return this.rows.size() - 1;
    }

    @Override
    public void appendCellToRow(int rowIndex, String contents) throws Exception {
        Row row = this.rows.get(rowIndex);
        row.appendCell(contents);
    }

    @Override
    public void appendCellToRow(int rowIndex, Table table) {
        Row row = this.rows.get(rowIndex);
        row.appendCell(table);
    }

    @Override
    public void setTestStatusOnRow(int rowIndex, boolean testStatus) {
        Row row = this.rows.get(rowIndex);
        row.setTestStatus(testStatus);
    }

    @Override
    public String error(String s) {
        return String.format("<span class=\"error\">%s</span>", s);
    }

    @Override
    public String pass(String s) {
        return String.format("<span class=\"pass\">%s</span>", s);
    }

    @Override
    public String fail(String s) {
        return String.format("<span class=\"fail\">%s</span>", s);
    }

    @Override
    public String ignore(String s) {
        return String.format("<span class=\"ignore\">%s</span>", s);
    }

    private Tag newTag(Class<? extends Tag> klass) {
        Tag tag = null;
        try {
            tag = klass.newInstance();
            Tag endTag = klass.newInstance();
            endTag.setTagName("/" + tag.getTagName());
            endTag.setParent((Node)tag);
            tag.setEndTag(endTag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tag;
    }

    public static String colorize(String content) {
        int firstMatchEnd;
        while ((firstMatchEnd = content.indexOf("</span>")) != -1) {
            Matcher matcher = coloredCellPattern.matcher(content);
            matcher.region(0, firstMatchEnd += "</span>".length());
            if (!matcher.find()) break;
            String color = matcher.group(1);
            String coloredString = matcher.group(2);
            content = content.replace(matcher.group(), String.format("%s(%s)", color, coloredString));
        }
        return content;
    }

    class Cell {
        private TableColumn columnNode;

        public Cell(TableColumn tableColumn) {
            this.columnNode = tableColumn;
        }

        public Cell(String contents) {
            if (contents == null) {
                contents = "";
            }
            TextNode text = new TextNode(contents);
            text.setChildren(new NodeList());
            this.columnNode = (TableColumn)HtmlTable.this.newTag(TableColumn.class);
            this.columnNode.setChildren(new NodeList((Node)text));
        }

        public Cell(Node node) {
            this.columnNode = (TableColumn)HtmlTable.this.newTag(TableColumn.class);
            this.columnNode.setChildren(new NodeList(node));
        }

        public String getResult() {
            String result = this.columnNode.getAttribute("class");
            if (result == null) {
                Node child = this.columnNode.getFirstChild();
                if (child != null) {
                    return child.getText();
                }
            } else if (result.equals("pass") || result.equals("fail") || result.equals("error") || result.equals("ignore")) {
                return result;
            }
            return "Unkown Result";
        }

        public String getContent() {
            return this.getEscapedContent();
        }

        public String getEscapedContent() {
            String unescaped = this.columnNode.getChildrenHTML();
            return "&nbsp;".equals(unescaped) ? "" : unescaped;
        }

        public void setContent(String s) {
            TextNode textNode = new TextNode(s);
            NodeList nodeList = new NodeList((Node)textNode);
            this.columnNode.setChildren(nodeList);
        }

        public TableColumn getColumnNode() {
            return this.columnNode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Row {
        private List<Cell> cells = new ArrayList<Cell>();
        private CompositeTag rowNode;

        public Row(CompositeTag rowNode) {
            this.rowNode = rowNode;
            NodeList nodeList = rowNode.getChildren();
            for (int i = 0; i < nodeList.size(); ++i) {
                Node node = nodeList.elementAt(i);
                if (!(node instanceof TableColumn)) continue;
                this.cells.add(new Cell((TableColumn)node));
            }
        }

        public Row() {
            this.rowNode = (TableRow)HtmlTable.this.newTag(TableRow.class);
            this.rowNode.setChildren(new NodeList());
            TableRow endNode = new TableRow();
            endNode.setTagName("/" + this.rowNode.getTagName());
            this.rowNode.setEndTag((Tag)endNode);
        }

        public int getColumnCount() {
            return this.cells.size();
        }

        public Cell getColumn(int columnIndex) {
            return this.cells.get(columnIndex);
        }

        public void appendCell(String contents) {
            Cell newCell = new Cell(contents);
            this.appendCell(newCell);
        }

        private void appendCell(Cell newCell) {
            this.rowNode.getChildren().add((Node)newCell.getColumnNode());
            this.cells.add(newCell);
        }

        public void appendCell(Table table) {
            try {
                this.doAppendCollapsableSection((HtmlTable)table);
            }
            catch (Exception e) {
                throw new SlimError(e);
            }
        }

        private void doAppendCollapsableSection(HtmlTable htmlTable) throws Exception {
            Node collapsableDiv = this.getCollapsableDiv();
            NodeList children = collapsableDiv.getChildren();
            Node hiddenDiv = this.findHiddenDiv(children);
            hiddenDiv.setChildren(new NodeList((Node)htmlTable.getTableNode()));
            Cell newCell = new Cell(collapsableDiv);
            this.appendCell(newCell);
        }

        private Node findHiddenDiv(NodeList children) {
            Node hiddenDiv = null;
            for (int i = 0; i < children.size(); ++i) {
                Div div;
                Node n = children.elementAt(i);
                if (!(n instanceof Div) || !"hidden".equals((div = (Div)n).getAttribute("class"))) continue;
                hiddenDiv = n;
                break;
            }
            return hiddenDiv;
        }

        private Node getCollapsableDiv() throws Exception {
            String collapsableSectionHtml = this.makeCollapsableSection();
            Parser parser = new Parser(collapsableSectionHtml);
            NodeList htmlTree = parser.parse(null);
            Node collapsableDiv = htmlTree.elementAt(0);
            return collapsableDiv;
        }

        public String makeCollapsableSection() throws Exception {
            String id = RANDOM_GENERATOR.nextLong() + "";
            HtmlTag outerDiv = HtmlUtil.makeDivTag("collapse_rim");
            HtmlTag image = new HtmlTag("img");
            image.addAttribute("src", "/files/images/collapsableClosed.gif");
            image.addAttribute("class", "left");
            image.addAttribute("id", "img" + id);
            HtmlTag anchor = new HtmlTag("a", image);
            anchor.addAttribute("href", "javascript:toggleCollapsable('" + id + "');");
            outerDiv.add(anchor);
            HtmlTag span = new HtmlTag("span", "Scenario");
            span.addAttribute("id", "test_status");
            outerDiv.add(span);
            HtmlTag collapsablediv = HtmlUtil.makeDivTag("hidden");
            collapsablediv.addAttribute("id", id);
            collapsablediv.add("");
            outerDiv.add(collapsablediv);
            return outerDiv.html();
        }

        public CompositeTag getRowNode() {
            return this.rowNode;
        }

        public List<String> asList() {
            ArrayList<String> list = new ArrayList<String>();
            for (Cell cell : this.cells) {
                list.add(HtmlTable.colorize(cell.getContent()));
            }
            return list;
        }

        public void setTestStatus(boolean testStatus) {
            NodeList cells = this.rowNode.getChildren();
            Node lastCell = cells.elementAt(cells.size() - 1);
            Tag statusNode = this.findById(lastCell, "test_status");
            statusNode.setAttribute("class", testStatus ? "pass" : "fail");
            for (int i = 0; i < cells.size(); ++i) {
                Node cell = cells.elementAt(i);
                if (!(cell instanceof Tag)) continue;
                Tag tag = (Tag)cell;
                tag.setAttribute("class", testStatus ? "pass" : "fail");
            }
        }

        private Tag findById(Node node, String id) {
            if (this.hasId(node, id)) {
                return (Tag)node;
            }
            return this.findChildMatchingId(node, id);
        }

        private Tag findChildMatchingId(Node node, String id) {
            NodeList children = node.getChildren();
            if (children != null) {
                for (int i = 0; i < children.size(); ++i) {
                    Node child = children.elementAt(i);
                    Tag found = this.findById(child, id);
                    if (found == null) continue;
                    return found;
                }
            }
            return null;
        }

        private boolean hasId(Node node, String id) {
            Tag t;
            return node instanceof Tag && id.equals((t = (Tag)node).getAttribute("id"));
        }
    }
}

