/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slimTables;

import fitnesse.slimTables.HtmlTable;
import fitnesse.slimTables.Table;
import fitnesse.slimTables.TableScanner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.tags.TableTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlTableScanner
implements TableScanner {
    private List<Table> tables = new ArrayList<Table>();
    private NodeList htmlTree;

    public HtmlTableScanner(String page) throws ParserException {
        if (page == null || page.equals("")) {
            page = "<i>This page intentionally left blank.</i>";
        }
        Parser parser = new Parser(new Lexer(new Page(page)));
        this.htmlTree = parser.parse(null);
        this.scanForTables(this.htmlTree);
    }

    private void scanForTables(NodeList nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.elementAt(i);
            if (node instanceof TableTag) {
                TableTag tableTag = (TableTag)node;
                this.guaranteeThatAllTablesAreUnique(tableTag);
                this.tables.add(new HtmlTable(tableTag));
                continue;
            }
            NodeList children = node.getChildren();
            if (children == null) continue;
            this.scanForTables(children);
        }
    }

    private void guaranteeThatAllTablesAreUnique(TableTag tagTable) {
        tagTable.setAttribute("_TABLENUMBER", "" + Math.abs(new Random().nextLong()));
    }

    @Override
    public int getTableCount() {
        return this.tables.size();
    }

    @Override
    public Table getTable(int i) {
        return this.tables.get(i);
    }

    @Override
    public Iterator<Table> iterator() {
        return this.tables.iterator();
    }

    @Override
    public String toWikiText() {
        StringBuffer b = new StringBuffer();
        for (Table t : this.tables) {
            b.append("\n");
            for (int row = 0; row < t.getRowCount(); ++row) {
                b.append("|");
                if (t.getColumnCountInRow(row) == 0) {
                    b.append("|");
                }
                for (int col = 0; col < t.getColumnCountInRow(row); ++col) {
                    b.append(t.getCellContents(col, row));
                    b.append("|");
                }
                b.append("\n");
            }
        }
        return b.toString();
    }

    @Override
    public String toHtml(Table startTable, Table endBeforeTable) {
        String stopText;
        String startText;
        int nodeIndex;
        String allHtml = this.htmlTree.toHtml();
        int startIndex = 0;
        int endIndex = allHtml.length();
        if (startTable != null && (nodeIndex = allHtml.indexOf(startText = startTable.toHtml())) > 0) {
            startIndex = nodeIndex;
        }
        if (endBeforeTable != null && (nodeIndex = allHtml.indexOf(stopText = endBeforeTable.toHtml())) > 0) {
            endIndex = nodeIndex;
        }
        return this.htmlTree.toHtml().substring(startIndex, endIndex);
    }

    @Override
    public String toHtml() {
        return this.htmlTree.toHtml();
    }
}

