/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slimTables;

import fitnesse.responders.run.slimResponder.SlimTestContext;
import fitnesse.slimTables.SlimTable;
import fitnesse.slimTables.Table;
import java.util.List;
import java.util.Map;
import util.ListUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportTable
extends SlimTable {
    public ImportTable(Table table, String id, SlimTestContext testContext) {
        super(table, id, testContext);
    }

    @Override
    protected String getTableType() {
        return "import";
    }

    @Override
    public void appendInstructions() {
        int rows = this.table.getRowCount();
        if (rows < 2) {
            throw new SlimTable.SyntaxError("Import tables must have at least two rows.");
        }
        for (int row = 1; row < rows; ++row) {
            String importString = this.table.getCellContents(0, row);
            if (importString.length() <= 0) continue;
            List<Object> importInstruction = this.prepareInstruction();
            importInstruction.addAll(ListUtility.list("import", importString));
            this.addInstruction(importInstruction);
        }
    }

    @Override
    public void evaluateReturnValues(Map<String, Object> returnValues) {
    }
}

