/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slimTables;

import fitnesse.responders.run.slimResponder.SlimTestContext;
import fitnesse.slimTables.QueryTable;
import fitnesse.slimTables.Table;

public class OrderedQueryTable
extends QueryTable {
    private int lastMatchedRow = -1;

    public OrderedQueryTable(Table table, String tableId, SlimTestContext slimTestContext) {
        super(table, tableId, slimTestContext);
    }

    protected void scanRowForMatch(int tableRow) throws Exception {
        int matchedRow = this.queryResults.findBestMatch(tableRow);
        if (matchedRow == -1) {
            this.replaceAllvariablesInRow(tableRow);
            this.failMessage(0, tableRow, "missing");
        } else {
            int columns = this.table.getColumnCountInRow(tableRow);
            this.markColumns(tableRow, matchedRow, columns);
            this.lastMatchedRow = matchedRow;
        }
    }

    private void markColumns(int tableRow, int matchedRow, int columns) {
        for (int col = 0; col < columns; ++col) {
            this.markColumn(tableRow, matchedRow, col);
        }
    }

    private void markColumn(int tableRow, int matchedRow, int col) {
        if (col >= this.fieldNames.size()) {
            return;
        }
        String actualValue = this.queryResults.getCell((String)this.fieldNames.get(col), matchedRow);
        String expectedValue = this.table.getCellContents(col, tableRow);
        this.table.setCell(col, tableRow, this.replaceSymbolsWithFullExpansion(expectedValue));
        if (actualValue == null) {
            this.failMessage(col, tableRow, "field not present");
        } else if (actualValue.equals(this.replaceSymbols(expectedValue))) {
            this.markMatch(tableRow, matchedRow, col);
        } else {
            this.expected(col, tableRow, actualValue);
        }
    }

    private void markMatch(int tableRow, int matchedRow, int col) {
        if (col == 0 && matchedRow <= this.lastMatchedRow) {
            this.failMessage(0, tableRow, "out of order: row " + (matchedRow + 1));
        } else {
            this.pass(col, tableRow);
        }
    }
}

