/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slimTables;

import fitnesse.responders.run.slimResponder.SlimTestContext;
import fitnesse.slimTables.SlimTable;
import fitnesse.slimTables.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import util.ListUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryTable
extends SlimTable {
    protected List<String> fieldNames = new ArrayList<String>();
    private String queryId;
    protected QueryResults queryResults;
    private String tableInstruction;

    public QueryTable(Table table, String id, SlimTestContext testContext) {
        super(table, id, testContext);
    }

    @Override
    protected String getTableType() {
        return "queryTable";
    }

    @Override
    public void appendInstructions() {
        if (this.table.getRowCount() < 2) {
            throw new SlimTable.SyntaxError("Query tables must have at least two rows.");
        }
        this.assignColumns();
        this.constructFixture();
        this.tableInstruction = this.callFunction(this.getTableName(), "table", this.tableAsList());
        this.queryId = this.callFunction(this.getTableName(), "query", new Object[0]);
    }

    @Override
    public boolean shouldIgnoreException(String resultKey, String resultString) {
        boolean isTableInstruction = resultKey.equals(this.tableInstruction);
        boolean isNoMethodException = resultString.indexOf("NO_METHOD_IN_CLASS") != -1;
        return isTableInstruction && isNoMethodException;
    }

    private void assignColumns() {
        int cols = this.table.getColumnCountInRow(1);
        for (int col = 0; col < cols; ++col) {
            this.fieldNames.add(this.table.getCellContents(col, 1));
        }
    }

    @Override
    public void evaluateReturnValues(Map<String, Object> returnValues) throws Exception {
        Object queryReturn = returnValues.get(this.queryId);
        if (this.queryId == null || queryReturn == null) {
            this.table.appendToCell(0, 0, this.error("query method did not return a list."));
            return;
        }
        if (queryReturn instanceof String) {
            String message = (String)queryReturn;
            if (this.isExceptionMessage(message)) {
                this.table.appendToCell(0, 0, this.makeExeptionMessage(message));
            } else {
                this.table.appendToCell(0, 0, this.error(String.format("The query method returned: %s", message)));
            }
        } else {
            this.scanRowsForMatches(ListUtility.uncheckedCast(Object.class, queryReturn));
        }
    }

    protected void scanRowsForMatches(List<Object> queryResultList) throws Exception {
        this.queryResults = new QueryResults(queryResultList);
        int rows = this.table.getRowCount();
        for (int tableRow = 2; tableRow < rows; ++tableRow) {
            this.scanRowForMatch(tableRow);
        }
        this.markSurplusRows();
    }

    private void markSurplusRows() throws Exception {
        List<Integer> unmatchedRows = this.queryResults.getUnmatchedRows();
        for (int unmatchedRow : unmatchedRows) {
            List<String> surplusRow = this.queryResults.getList(this.fieldNames, unmatchedRow);
            int newTableRow = this.table.addRow(surplusRow);
            this.failMessage(0, newTableRow, "surplus");
            this.markMissingFields(surplusRow, newTableRow);
        }
    }

    private void markMissingFields(List<String> surplusRow, int newTableRow) {
        for (int col = 0; col < surplusRow.size(); ++col) {
            String surplusField = surplusRow.get(col);
            if (surplusField != null) continue;
            this.fail(col, newTableRow, "field not present");
        }
    }

    protected void scanRowForMatch(int tableRow) throws Exception {
        int matchedRow = this.queryResults.findBestMatch(tableRow);
        if (matchedRow == -1) {
            this.replaceAllvariablesInRow(tableRow);
            this.failMessage(0, tableRow, "missing");
        } else {
            this.markFieldsInMatchedRow(tableRow, matchedRow);
        }
    }

    protected void replaceAllvariablesInRow(int tableRow) {
        int columns = this.table.getColumnCountInRow(tableRow);
        for (int col = 0; col < columns; ++col) {
            String contents = this.table.getCellContents(col, tableRow);
            this.table.setCell(col, tableRow, this.replaceSymbolsWithFullExpansion(contents));
        }
    }

    protected void markFieldsInMatchedRow(int tableRow, int matchedRow) {
        int columns = this.table.getColumnCountInRow(tableRow);
        for (int col = 0; col < columns; ++col) {
            this.markField(tableRow, matchedRow, col);
        }
    }

    protected void markField(int tableRow, int matchedRow, int col) {
        String actualValue = this.queryResults.getCell(this.fieldNames.get(col), matchedRow);
        String expectedValue = this.table.getCellContents(col, tableRow);
        this.table.setCell(col, tableRow, this.replaceSymbolsWithFullExpansion(expectedValue));
        if (actualValue == null) {
            this.failMessage(col, tableRow, "field not present");
        } else if (actualValue.equals(this.replaceSymbols(expectedValue))) {
            this.pass(col, tableRow);
        } else {
            this.expected(col, tableRow, actualValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QueryResults {
        private List<Map<String, String>> rows = new ArrayList<Map<String, String>>();
        private List<Integer> unmatchedRows = new ArrayList<Integer>();

        public QueryResults(List<Object> queryResultTable) {
            int rowNumber = 0;
            for (Object row : queryResultTable) {
                this.rows.add(this.makeRowMap(row));
                this.unmatchedRows.add(rowNumber++);
            }
        }

        private Map<String, String> makeRowMap(Object row) {
            HashMap<String, String> rowMap = new HashMap<String, String>();
            for (List columnPair : (List)row) {
                String fieldName = (String)columnPair.get(0);
                String fieldValue = (String)columnPair.get(1);
                rowMap.put(fieldName, fieldValue);
            }
            return rowMap;
        }

        public int findBestMatch(int tableRow) {
            return new QueryMatcher().findBestMatch(tableRow);
        }

        public List<String> getList(List<String> fieldNames, int row) {
            ArrayList<String> result = new ArrayList<String>();
            for (String name : fieldNames) {
                result.add(this.rows.get(row).get(name));
            }
            return result;
        }

        public String getCell(String name, int row) {
            return this.rows.get(row).get(name);
        }

        public List<Integer> getUnmatchedRows() {
            return this.unmatchedRows;
        }

        private class QueryMatcher {
            private int matchDepth = -1;
            private int deepestRow = -1;
            private List<Integer> matchCandidates;

            private QueryMatcher() {
                this.matchCandidates = new ArrayList<Integer>(QueryResults.this.unmatchedRows);
            }

            public int findBestMatch(int tableRow) {
                for (int fieldIndex = 0; fieldIndex < QueryTable.this.fieldNames.size(); ++fieldIndex) {
                    new FieldMatcher(fieldIndex, tableRow).eliminateRowsThatDontMatchField();
                }
                if (this.deepestRow >= 0) {
                    QueryResults.this.unmatchedRows.remove(QueryResults.this.unmatchedRows.indexOf(this.deepestRow));
                }
                return this.deepestRow;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class FieldMatcher {
                private int fieldIndex;
                private int tableRow;

                FieldMatcher(int fieldIndex, int tableRow) {
                    this.fieldIndex = fieldIndex;
                    this.tableRow = tableRow;
                }

                private void eliminateRowsThatDontMatchField() {
                    String fieldName = QueryTable.this.fieldNames.get(this.fieldIndex);
                    Iterator<Integer> rowIterator = QueryMatcher.this.matchCandidates.iterator();
                    while (rowIterator.hasNext()) {
                        this.eliminateUnmatchingRow(rowIterator, fieldName);
                    }
                }

                private void eliminateUnmatchingRow(Iterator<Integer> rowIterator, String fieldName) {
                    int row = rowIterator.next();
                    String actualValue = (String)((Map)QueryResults.this.rows.get(row)).get(fieldName);
                    String expectedValue = QueryTable.this.table.getCellContents(this.fieldIndex, this.tableRow);
                    if (actualValue != null && actualValue.equals(QueryTable.this.replaceSymbols(expectedValue))) {
                        this.recordMatch(row);
                    } else {
                        rowIterator.remove();
                    }
                }

                private void recordMatch(int row) {
                    if (QueryMatcher.this.matchDepth < this.fieldIndex) {
                        QueryMatcher.this.matchDepth = this.fieldIndex;
                        QueryMatcher.this.deepestRow = row;
                    }
                }
            }
        }
    }
}

