/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slimTables;

import fitnesse.responders.run.TestSummary;
import fitnesse.responders.run.slimResponder.SlimTestContext;
import fitnesse.slim.SlimError;
import fitnesse.slimTables.HtmlTableScanner;
import fitnesse.slimTables.ScriptTable;
import fitnesse.slimTables.SlimTable;
import fitnesse.slimTables.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScenarioTable
extends SlimTable {
    private static final String instancePrefix = "scenarioTable";
    private String name;
    private List<String> inputs = new ArrayList<String>();
    private Set<String> outputs = new HashSet<String>();
    private final int colsInHeader = this.table.getColumnCountInRow(0);
    private boolean parameterized = false;

    public ScenarioTable(Table table, String tableId, SlimTestContext testContext) {
        super(table, tableId, testContext);
    }

    @Override
    protected String getTableType() {
        return instancePrefix;
    }

    @Override
    public void appendInstructions() {
        this.parseTable();
    }

    private void parseTable() {
        this.validateHeader();
        String firstNameCell = this.table.getCellContents(1, 0);
        this.parameterized = ScenarioTable.isNameParameterized(firstNameCell);
        this.name = this.getScenarioName();
        this.getTestContext().addScenario(this.name, this);
        this.getScenarioArguments();
    }

    private void getScenarioArguments() {
        if (this.parameterized) {
            this.getArgumentsForParameterizedName();
        } else {
            this.getArgumentsForAlternatingName();
        }
    }

    private void getArgumentsForAlternatingName() {
        for (int inputCol = 2; inputCol < this.colsInHeader; inputCol += 2) {
            String disgracedArgName;
            String argName = this.table.getCellContents(inputCol, 0);
            if (argName.endsWith("?")) {
                disgracedArgName = SlimTable.Disgracer.disgraceMethodName(argName.substring(0, argName.length()));
                this.outputs.add(disgracedArgName);
                continue;
            }
            disgracedArgName = SlimTable.Disgracer.disgraceMethodName(argName);
            this.inputs.add(disgracedArgName);
        }
    }

    private void getArgumentsForParameterizedName() {
        String[] arguments;
        String argumentString = this.table.getCellContents(2, 0);
        for (String argument : arguments = argumentString.split(",")) {
            this.inputs.add(SlimTable.Disgracer.disgraceMethodName(argument.trim()));
        }
    }

    private String getScenarioName() {
        if (this.parameterized) {
            String parameterizedName = this.table.getCellContents(1, 0);
            return ScenarioTable.unparameterize(parameterizedName);
        }
        return this.getNameFromAlternatingCells();
    }

    public static boolean isNameParameterized(String firstNameCell) {
        return firstNameCell.indexOf("_") != -1;
    }

    public static String unparameterize(String firstNameCell) {
        String name = firstNameCell.replaceAll("_", " ").trim();
        return SlimTable.Disgracer.disgraceClassName(name);
    }

    private String getNameFromAlternatingCells() {
        StringBuffer nameBuffer = new StringBuffer();
        for (int nameCol = 1; nameCol < this.colsInHeader; nameCol += 2) {
            nameBuffer.append(this.table.getCellContents(nameCol, 0)).append(" ");
        }
        return SlimTable.Disgracer.disgraceClassName(nameBuffer.toString().trim());
    }

    private void validateHeader() {
        if (this.colsInHeader <= 1) {
            throw new SlimTable.SyntaxError("Scenario tables must have a name.");
        }
    }

    @Override
    public void evaluateReturnValues(Map<String, Object> returnValues) throws Exception {
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getInputs() {
        return new HashSet<String>(this.inputs);
    }

    public Set<String> getOutputs() {
        return this.outputs;
    }

    public void call(Map<String, String> scenarioArguments, SlimTable parentTable, int row) {
        String script = this.getTable().toHtml();
        script = this.replaceArgsInScriptTable(script, scenarioArguments);
        this.insertAndProcessScript(script, parentTable, row);
    }

    public void call(String[] args, ScriptTable parentTable, int row) {
        HashMap<String, String> scenarioArguments = new HashMap<String, String>();
        for (int i = 0; i < this.inputs.size() && i < args.length; ++i) {
            scenarioArguments.put(this.inputs.get(i), args[i]);
        }
        this.call(scenarioArguments, (SlimTable)parentTable, row);
    }

    private void insertAndProcessScript(String script, SlimTable parentTable, int row) {
        try {
            HtmlTableScanner ts = new HtmlTableScanner(script);
            ScriptTable t = new ScriptTable(ts.getTable(0), this.id, parentTable.getTestContext());
            parentTable.addChildTable(t, row);
            t.appendInstructions(parentTable.instructions);
            parentTable.addExpectation(new ScenarioExpectation(t, row));
        }
        catch (Exception e) {
            throw new SlimError(e);
        }
    }

    private String replaceArgsInScriptTable(String script, Map<String, String> scenarioArguments) {
        for (String arg : scenarioArguments.keySet()) {
            if (this.getInputs().contains(arg)) {
                String argument = scenarioArguments.get(arg);
                script = StringUtil.replaceAll(script, "@" + arg, argument);
                continue;
            }
            throw new SlimTable.SyntaxError(String.format("The argument %s is not an input to the scenario.", arg));
        }
        return script;
    }

    public boolean isParameterized() {
        return this.parameterized;
    }

    public String[] matchParameters(String invokingString) {
        String parameterizedName;
        if (this.parameterized) {
            parameterizedName = this.table.getCellContents(1, 0);
        } else {
            StringBuilder nameBuffer = new StringBuilder();
            for (int nameCol = 1; nameCol < this.colsInHeader; nameCol += 2) {
                nameBuffer.append(this.table.getCellContents(nameCol, 0)).append(" _ ");
            }
            parameterizedName = nameBuffer.toString().trim();
        }
        return this.getArgumentsMatchingParameterizedName(parameterizedName, invokingString);
    }

    private String[] getArgumentsMatchingParameterizedName(String parameterizedName, String invokingString) {
        Matcher matcher = this.makeParameterizedNameMatcher(parameterizedName, invokingString);
        if (matcher.matches()) {
            return this.extractNamesFromMatcher(matcher);
        }
        return null;
    }

    private Matcher makeParameterizedNameMatcher(String parameterizedName, String invokingString) {
        String patternString = parameterizedName.replaceAll("_", "(.*)");
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(invokingString);
        return matcher;
    }

    private String[] extractNamesFromMatcher(Matcher matcher) {
        String[] arguments = new String[matcher.groupCount()];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = matcher.group(i + 1);
        }
        return arguments;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScenarioExpectation
    extends SlimTable.Expectation {
        private ScriptTable scriptTable;

        private ScenarioExpectation(ScriptTable scriptTable, int row) {
            super(ScenarioTable.this, "", -1, row);
            this.scriptTable = scriptTable;
        }

        @Override
        public void evaluateExpectation(Map<String, Object> returnValues) {
            TestSummary counts = this.scriptTable.getTestSummary();
            boolean testStatus = counts.getWrong() + counts.getExceptions() == 0;
            SlimTable parent = this.scriptTable.getParent();
            parent.getTable().setTestStatusOnRow(this.getRow(), testStatus);
            parent.getTestSummary().add(this.scriptTable.getTestSummary());
        }

        @Override
        protected String createEvaluationMessage(String actual, String expected) {
            return null;
        }
    }
}

