/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slimTables;

import fitnesse.responders.run.TestSummary;
import fitnesse.responders.run.slimResponder.SlimTestContext;
import fitnesse.slimTables.HtmlTable;
import fitnesse.slimTables.Table;
import fitnesse.wikitext.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import util.ListUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SlimTable {
    protected Table table;
    private SlimTestContext testContext;
    protected String id;
    private String tableName;
    private int instructionNumber = 0;
    protected List<Object> instructions;
    protected static final Pattern symbolAssignmentPattern = Pattern.compile("\\A\\s*\\$(\\w+)\\s*=\\s*\\Z");
    private TestSummary testSummary = new TestSummary();
    private SlimTable parent = null;
    private List<SlimTable> children = new ArrayList<SlimTable>();

    public SlimTable(Table table, String id, SlimTestContext testContext) {
        this.id = id;
        this.table = table;
        this.testContext = testContext;
        this.tableName = this.getTableType() + "_" + id;
        this.instructions = new ArrayList<Object>();
    }

    SlimTable(SlimTestContext testContext) {
        this.testContext = testContext;
    }

    public SlimTable getParent() {
        return this.parent;
    }

    public void addChildTable(SlimTable slimtable, int row) throws Exception {
        slimtable.id = this.id + "." + this.children.size();
        slimtable.tableName = this.makeInstructionTag(this.instructionNumber) + "/" + slimtable.tableName;
        ++this.instructionNumber;
        slimtable.parent = this;
        this.children.add(slimtable);
        Table parentTable = this.getTable();
        Table childTable = slimtable.getTable();
        childTable.setName(slimtable.tableName);
        parentTable.appendCellToRow(row, childTable);
    }

    public SlimTable getChild(int i) {
        return this.children.get(i);
    }

    protected void addExpectation(Expectation e) {
        this.testContext.addExpectation(e);
    }

    public String replaceSymbols(String s) {
        return new SymbolReplacer(s).replace();
    }

    public String replaceSymbolsWithFullExpansion(String s) {
        return new FullExpansionSymbolReplacer(s).replace();
    }

    protected abstract String getTableType();

    public void appendInstructions(List<Object> instructions) {
        try {
            this.instructions = instructions;
            this.appendInstructions();
        }
        catch (Throwable e) {
            String tableName = this.table.getCellContents(0, 0);
            this.table.setCell(0, 0, this.fail(String.format("%s: Bad table: <br/><pre>%s</pre>", tableName, Utils.getStackTrace(e))));
        }
    }

    public abstract void appendInstructions();

    protected List<Object> prepareInstruction() {
        ArrayList<Object> instruction = new ArrayList<Object>();
        instruction.add(this.makeInstructionTag(this.instructionNumber));
        ++this.instructionNumber;
        return instruction;
    }

    protected String makeInstructionTag(int instructionNumber) {
        return String.format("%s_%d", this.tableName, instructionNumber);
    }

    protected String getInstructionTag() {
        return this.makeInstructionTag(this.instructionNumber);
    }

    public String getTableName() {
        return this.tableName;
    }

    protected void addInstruction(List<Object> instruction) {
        this.instructions.add(instruction);
    }

    public abstract void evaluateReturnValues(Map<String, Object> var1) throws Exception;

    public String getSymbol(String variableName) {
        return this.testContext.getSymbol(variableName);
    }

    public void setSymbol(String variableName, String value) {
        this.testContext.setSymbol(variableName, value);
    }

    public Table getTable() {
        return this.table;
    }

    protected void constructFixture() {
        String fixtureName = this.getFixtureName();
        this.constructFixture(fixtureName);
    }

    protected void constructFixture(String fixtureName) {
        this.constructInstance(this.getTableName(), fixtureName, 0, 0);
    }

    protected String getFixtureName() {
        String tableHeader = this.table.getCellContents(0, 0);
        String fixtureName = this.getFixtureName(tableHeader);
        String disgracedFixtureName = Disgracer.disgraceClassName(fixtureName);
        return disgracedFixtureName;
    }

    protected String getFixtureName(String tableHeader) {
        if (tableHeader.indexOf(":") == -1) {
            return tableHeader;
        }
        return tableHeader.split(":")[1];
    }

    protected void constructInstance(String instanceName, String className, int classNameColumn, int row) {
        ConstructionExpectation expectation = new ConstructionExpectation(this.getInstructionTag(), classNameColumn, row);
        this.addExpectation(expectation);
        List<Object> makeInstruction = this.prepareInstruction();
        makeInstruction.add("make");
        makeInstruction.add(instanceName);
        makeInstruction.add(className);
        this.addArgsToInstruction(makeInstruction, this.gatherConstructorArgumentsStartingAt(classNameColumn + 1, row));
        this.addInstruction(makeInstruction);
    }

    protected Object[] gatherConstructorArgumentsStartingAt(int startingColumn, int row) {
        int columnCount = this.table.getColumnCountInRow(row);
        ArrayList<String> arguments = new ArrayList<String>();
        for (int col = startingColumn; col < columnCount; ++col) {
            arguments.add(this.table.getUnescapedCellContents(col, row));
            this.addExpectation(new VoidReturnExpectation(this.getInstructionTag(), col, row));
        }
        return arguments.toArray(new String[0]);
    }

    protected void addCall(List<Object> instruction, String instanceName, String functionName) {
        String disgracedFunctionName = Disgracer.disgraceMethodName(functionName);
        List<String> callHeader = ListUtility.list("call", instanceName, disgracedFunctionName);
        instruction.addAll(callHeader);
    }

    protected String callFunction(String instanceName, String functionName, Object ... args) {
        List<Object> callInstruction = this.prepareInstruction();
        this.addCall(callInstruction, instanceName, functionName);
        this.addArgsToInstruction(callInstruction, args);
        this.addInstruction(callInstruction);
        return (String)callInstruction.get(0);
    }

    private void addArgsToInstruction(List<Object> instruction, Object ... args) {
        for (Object arg : args) {
            instruction.add(arg);
        }
    }

    protected String callAndAssign(String symbolName, String instanceName, String functionName, String ... args) {
        List<Object> callAndAssignInstruction = this.prepareInstruction();
        String disgracedFunctionName = Disgracer.disgraceMethodName(functionName);
        List<String> callAndAssignHeader = ListUtility.list("callAndAssign", symbolName, instanceName, disgracedFunctionName);
        callAndAssignInstruction.addAll(callAndAssignHeader);
        this.addArgsToInstruction(callAndAssignInstruction, args);
        this.addInstruction(callAndAssignInstruction);
        return (String)callAndAssignInstruction.get(0);
    }

    protected void failMessage(int col, int row, String failureMessage) {
        String contents = this.table.getCellContents(col, row);
        String failingContents = this.failMessage(contents, failureMessage);
        this.table.setCell(col, row, failingContents);
    }

    protected void fail(int col, int row, String value) {
        String failingContents = this.fail(value);
        this.table.setCell(col, row, failingContents);
    }

    protected void ignore(int col, int row, String value) {
        String content = this.ignore(value);
        this.table.setCell(col, row, content);
    }

    protected void pass(int col, int row) {
        String contents = this.table.getCellContents(col, row);
        String passingContents = this.pass(contents);
        this.table.setCell(col, row, passingContents);
    }

    protected void expected(int col, int tableRow, String actual) {
        String contents = this.table.getCellContents(col, tableRow);
        String failureMessage = this.failMessage(actual, String.format("expected [%s]", contents));
        this.table.setCell(col, tableRow, failureMessage);
    }

    protected String fail(String value) {
        this.testSummary.wrong = this.testSummary.getWrong() + 1;
        return this.table.fail(value);
    }

    protected String failMessage(String value, String message) {
        return String.format("[%s] %s", value, this.fail(message));
    }

    protected String pass(String value) {
        this.testSummary.right = this.testSummary.getRight() + 1;
        return this.table.pass(value);
    }

    protected String error(String value) {
        this.testSummary.exceptions = this.testSummary.getExceptions() + 1;
        return this.table.error(value);
    }

    protected String ignore(String value) {
        ++this.testSummary.ignores;
        return this.table.ignore(value);
    }

    protected ReturnedValueExpectation makeReturnedValueExpectation(String instructionTag, int col, int row) {
        return new ReturnedValueExpectation(instructionTag, col, row);
    }

    public static boolean approximatelyEqual(String standard, String candidate) {
        try {
            double candidateValue = Double.parseDouble(candidate);
            double standardValue = Double.parseDouble(standard);
            int point = standard.indexOf(".");
            int precision = 0;
            if (point != -1) {
                precision = standard.length() - point - 1;
            }
            double roundingFactor = 0.5;
            while (precision-- > 0) {
                roundingFactor /= 10.0;
            }
            return Math.abs(candidateValue - standardValue) <= roundingFactor;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public TestSummary getTestSummary() {
        return this.testSummary;
    }

    protected String makeExeptionMessage(String value) {
        if (value.startsWith("!fail:")) {
            return this.fail(value.substring("!fail:".length()));
        }
        return this.error(value.substring("!error:".length()));
    }

    protected boolean isExceptionMessage(String value) {
        return value != null && (value.startsWith("!fail:") || value.startsWith("!error:"));
    }

    public boolean shouldIgnoreException(String resultKey, String resultString) {
        return false;
    }

    protected String ifSymbolAssignment(int row, int col) {
        String expected = this.table.getCellContents(col, row);
        Matcher matcher = symbolAssignmentPattern.matcher(expected);
        return matcher.find() ? matcher.group(1) : null;
    }

    protected void callAndAssign(String symbolName, String functionName) {
        List<Object> callAndAssignInstruction = this.prepareInstruction();
        callAndAssignInstruction.add("callAndAssign");
        callAndAssignInstruction.add(symbolName);
        callAndAssignInstruction.add(this.getTableName());
        callAndAssignInstruction.add(Disgracer.disgraceMethodName(functionName));
        this.addInstruction(callAndAssignInstruction);
    }

    public SlimTestContext getTestContext() {
        return this.testContext;
    }

    protected List<Object> tableAsList() {
        List<Object> tableArgument = ListUtility.list();
        int rows = this.table.getRowCount();
        for (int row = 1; row < rows; ++row) {
            tableArgument.add(this.tableRowAsList(row));
        }
        return tableArgument;
    }

    private List<Object> tableRowAsList(int row) {
        List<Object> rowList = ListUtility.list();
        int cols = this.table.getColumnCountInRow(row);
        for (int col = 0; col < cols; ++col) {
            rowList.add(this.table.getCellContents(col, row));
        }
        return rowList;
    }

    public List<SlimTable> getChildren() {
        return this.children;
    }

    class Comparator {
        private String expression;
        private String actual;
        private String expected;
        private Pattern simpleComparison = Pattern.compile("\\A\\s*_?\\s*(!?(?:(?:[<>]=?)|(?:[~]?=)))\\s*(\\d*\\.?\\d+)\\s*\\Z");
        private Pattern range = Pattern.compile("\\A\\s*(\\d*\\.?\\d+)\\s*<(=?)\\s*_\\s*<(=?)\\s*(\\d*\\.?\\d+)\\s*\\Z");
        private double v;
        private double arg1;
        private double arg2;
        public String operation;
        private String arg1Text;
        private ReturnedValueExpectation returnedValueExpectation;

        private Comparator(ReturnedValueExpectation returnedValueExpectation, String expression, String actual, String expected) {
            this.returnedValueExpectation = returnedValueExpectation;
            this.expression = expression;
            this.actual = actual;
            this.expected = expected;
        }

        private String evaluate() {
            this.operation = this.matchSimpleComparison();
            if (this.operation != null) {
                return this.doSimpleComparison();
            }
            Matcher matcher = this.range.matcher(this.expression);
            if (matcher.matches() && this.canUnpackRange(matcher)) {
                return this.doRange(matcher);
            }
            return null;
        }

        private String doRange(Matcher matcher) {
            boolean closedLeft = matcher.group(2).equals("=");
            boolean closedRight = matcher.group(3).equals("=");
            boolean pass = this.arg1 < this.v && this.v < this.arg2 || closedLeft && this.arg1 == this.v || closedRight && this.arg2 == this.v;
            return this.rangeMessage(pass);
        }

        private String rangeMessage(boolean pass) {
            String[] fragments = this.expected.replaceAll(" ", "").split("_");
            String message = String.format("%s%s%s", fragments[0], this.actual, fragments[1]);
            message = SlimTable.this.replaceSymbolsWithFullExpansion(message);
            return pass ? this.returnedValueExpectation.pass(message) : this.returnedValueExpectation.fail(message);
        }

        private boolean canUnpackRange(Matcher matcher) {
            try {
                this.arg1 = Double.parseDouble(matcher.group(1));
                this.arg2 = Double.parseDouble(matcher.group(4));
                this.v = Double.parseDouble(this.actual);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }

        private String doSimpleComparison() {
            if (this.operation.equals("<") || this.operation.equals("!>=")) {
                return this.simpleComparisonMessage(this.v < this.arg1);
            }
            if (this.operation.equals(">") || this.operation.equals("!<=")) {
                return this.simpleComparisonMessage(this.v > this.arg1);
            }
            if (this.operation.equals(">=") || this.operation.equals("!<")) {
                return this.simpleComparisonMessage(this.v >= this.arg1);
            }
            if (this.operation.equals("<=") || this.operation.equals("!>")) {
                return this.simpleComparisonMessage(this.v <= this.arg1);
            }
            if (this.operation.equals("!=")) {
                return this.simpleComparisonMessage(this.v != this.arg1);
            }
            if (this.operation.equals("=")) {
                return this.simpleComparisonMessage(this.v == this.arg1);
            }
            if (this.operation.equals("~=")) {
                return this.simpleComparisonMessage(SlimTable.approximatelyEqual(this.arg1Text, this.actual));
            }
            if (this.operation.equals("!~=")) {
                return this.simpleComparisonMessage(!SlimTable.approximatelyEqual(this.arg1Text, this.actual));
            }
            return null;
        }

        private String simpleComparisonMessage(boolean pass) {
            String message = String.format("%s%s", this.actual, this.expected.replaceAll(" ", ""));
            message = SlimTable.this.replaceSymbolsWithFullExpansion(message);
            return pass ? this.returnedValueExpectation.pass(message) : this.returnedValueExpectation.fail(message);
        }

        private String matchSimpleComparison() {
            Matcher matcher = this.simpleComparison.matcher(this.expression);
            if (matcher.matches()) {
                try {
                    this.v = Double.parseDouble(this.actual);
                    this.arg1Text = matcher.group(2);
                    this.arg1 = Double.parseDouble(this.arg1Text);
                    return matcher.group(1);
                }
                catch (NumberFormatException e1) {
                    return null;
                }
            }
            return null;
        }
    }

    class RejectedValueExpectation
    extends ReturnedValueExpectation {
        public RejectedValueExpectation(String instructionTag, int col, int row) {
            super(instructionTag, col, row);
        }

        protected String pass(String message) {
            return super.fail(message);
        }

        protected String fail(String message) {
            return super.pass(message);
        }
    }

    class ReturnedValueExpectation
    extends Expectation {
        public ReturnedValueExpectation(String instructionTag, int col, int row) {
            super(instructionTag, col, row);
        }

        protected String createEvaluationMessage(String actual, String expected) {
            String expressionMessage;
            String replacedExpected = Utils.unescapeHTML(SlimTable.this.replaceSymbols(expected));
            String evaluationMessage = actual == null ? this.fail("null") : (actual.equals(replacedExpected) ? this.pass(this.announceBlank(SlimTable.this.replaceSymbolsWithFullExpansion(expected))) : (replacedExpected.length() == 0 ? SlimTable.this.ignore(actual) : ((expressionMessage = new Comparator(this, replacedExpected, actual, expected).evaluate()) != null ? expressionMessage : (actual.indexOf("Exception:") != -1 ? SlimTable.this.error(actual) : this.failMessage(actual, String.format("expected [%s]", SlimTable.this.replaceSymbolsWithFullExpansion(expected)))))));
            return evaluationMessage;
        }

        private String announceBlank(String originalValue) {
            return originalValue.length() == 0 ? "BLANK" : originalValue;
        }

        protected String pass(String message) {
            return SlimTable.this.pass(message);
        }

        protected String fail(String message) {
            return SlimTable.this.fail(message);
        }

        protected String failMessage(String value, String message) {
            return String.format("[%s] %s", value, this.fail(message));
        }
    }

    class SymbolAssignmentExpectation
    extends Expectation {
        private String symbolName;

        SymbolAssignmentExpectation(String symbolName, String instructionTag, int col, int row) {
            super(instructionTag, col, row);
            this.symbolName = symbolName;
        }

        protected String createEvaluationMessage(String actual, String expected) {
            SlimTable.this.setSymbol(this.symbolName, actual);
            return String.format("$%s<-[%s]", this.symbolName, actual);
        }
    }

    class ConstructionExpectation
    extends Expectation {
        public ConstructionExpectation(String instructionTag, int col, int row) {
            super(instructionTag, col, row);
        }

        protected String createEvaluationMessage(String actual, String expected) {
            if ("OK".equalsIgnoreCase(actual)) {
                return SlimTable.this.pass(expected);
            }
            return "!style_error(Unknown construction message:) " + actual;
        }
    }

    class SilentReturnExpectation
    extends Expectation {
        public SilentReturnExpectation(String instructionTag, int col, int row) {
            super(instructionTag, col, row);
        }

        protected String createEvaluationMessage(String actual, String expected) {
            return null;
        }
    }

    class VoidReturnExpectation
    extends Expectation {
        public VoidReturnExpectation(String instructionTag, int col, int row) {
            super(instructionTag, col, row);
        }

        protected String createEvaluationMessage(String actual, String expected) {
            return SlimTable.this.replaceSymbolsWithFullExpansion(expected);
        }
    }

    public static class SyntaxError
    extends Error {
        private static final long serialVersionUID = 1L;

        public SyntaxError(String message) {
            super(message);
        }
    }

    class FullExpansionSymbolReplacer
    extends SymbolReplacer {
        FullExpansionSymbolReplacer(String s) {
            super(s);
        }

        protected String translate(String symbolName) {
            return String.format("$%s->[%s]", symbolName, SlimTable.this.getSymbol(symbolName));
        }
    }

    class SymbolReplacer {
        protected String replacedString;
        private Matcher symbolMatcher;
        private final Pattern symbolPattern = Pattern.compile("\\$([a-zA-Z]\\w*)");
        private int startingPosition;

        SymbolReplacer(String s) {
            this.replacedString = s;
            this.symbolMatcher = this.symbolPattern.matcher(s);
        }

        String replace() {
            this.replaceAllSymbols();
            return this.replacedString;
        }

        private void replaceAllSymbols() {
            this.startingPosition = 0;
            while (this.symbolFound()) {
                this.replaceOneSymbol();
            }
        }

        private void replaceOneSymbol() {
            String symbolName = this.symbolMatcher.group(1);
            String value = this.getSymbolValue(symbolName);
            String prefix = this.replacedString.substring(0, this.symbolMatcher.start());
            String suffix = this.replacedString.substring(this.symbolMatcher.end());
            this.replacedString = prefix + value + suffix;
            int replacementEnd = this.symbolMatcher.start() + value.length();
            this.startingPosition = Math.min(replacementEnd, this.replacedString.length());
        }

        private String getSymbolValue(String symbolName) {
            String value = this.translate(symbolName);
            if (value == null) {
                value = "";
            }
            return value;
        }

        private boolean symbolFound() {
            this.symbolMatcher = this.symbolPattern.matcher(this.replacedString);
            return this.symbolMatcher.find(this.startingPosition);
        }

        protected String translate(String symbolName) {
            return SlimTable.this.getSymbol(symbolName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Expectation {
        private int col;
        private int row;
        private String instructionTag;
        private String actual;
        private String expected;
        private String evaluationMessage;

        public Expectation(String instructionTag, int col, int row) {
            this.row = row;
            this.instructionTag = instructionTag;
            this.col = col;
        }

        public void evaluateExpectation(Map<String, Object> returnValues) {
            String evaluationMessage;
            Object returnValue = returnValues.get(this.instructionTag);
            if (returnValue == null) {
                String originalContent = SlimTable.this.table.getCellContents(this.col, this.row);
                evaluationMessage = originalContent + " " + SlimTable.this.ignore("Test not run");
                returnValues.put(this.instructionTag, "Test not run");
            } else {
                String value = returnValue.toString();
                String originalContent = SlimTable.this.table.getCellContents(this.col, this.row);
                evaluationMessage = this.evaluationMessage(value, originalContent);
            }
            if (evaluationMessage != null) {
                SlimTable.this.table.setCell(this.col, this.row, evaluationMessage);
            }
        }

        String evaluationMessage(String actual, String expected) {
            this.actual = actual;
            this.expected = expected;
            String evaluationMessage = SlimTable.this.isExceptionMessage(actual) ? expected + " " + SlimTable.this.makeExeptionMessage(actual) : this.createEvaluationMessage(actual, expected);
            this.evaluationMessage = HtmlTable.colorize(evaluationMessage);
            return evaluationMessage;
        }

        protected abstract String createEvaluationMessage(String var1, String var2);

        public int getCol() {
            return this.col;
        }

        public int getRow() {
            return this.row;
        }

        public String getInstructionTag() {
            return this.instructionTag;
        }

        public String getActual() {
            return this.actual;
        }

        public String getExpected() {
            return this.expected;
        }

        public String getEvaluationMessage() {
            return this.evaluationMessage == null ? "" : this.evaluationMessage;
        }
    }

    static class Disgracer {
        public boolean capitalizeNextWord;
        public StringBuffer disgracedName;
        private String name;

        public Disgracer(String name) {
            this.name = name;
        }

        public static String disgraceClassName(String name) {
            return new Disgracer(name).disgraceClassNameIfNecessary();
        }

        public static String disgraceMethodName(String name) {
            return new Disgracer(name).disgraceMethodNameIfNecessary();
        }

        private String disgraceMethodNameIfNecessary() {
            if (this.isGraceful()) {
                return this.disgraceMethodName();
            }
            return this.name;
        }

        private String disgraceMethodName() {
            this.capitalizeNextWord = false;
            return this.disgraceName();
        }

        private String disgraceClassNameIfNecessary() {
            if (this.nameHasDotsBeforeEnd()) {
                return this.name;
            }
            if (this.isGraceful()) {
                return this.disgraceClassName();
            }
            return this.name;
        }

        private String disgraceClassName() {
            this.capitalizeNextWord = true;
            return this.disgraceName();
        }

        private boolean nameHasDotsBeforeEnd() {
            int dotIndex = this.name.indexOf(".");
            return dotIndex != -1 && dotIndex != this.name.length() - 1;
        }

        private String disgraceName() {
            this.disgracedName = new StringBuffer();
            for (char c : this.name.toCharArray()) {
                this.appendCharInProperCase(c);
            }
            return this.disgracedName.toString();
        }

        private void appendCharInProperCase(char c) {
            if (this.isGraceful(c)) {
                this.capitalizeNextWord = true;
            } else {
                this.appendProperlyCapitalized(c);
            }
        }

        private void appendProperlyCapitalized(char c) {
            this.disgracedName.append(this.capitalizeNextWord ? Character.toUpperCase(c) : c);
            this.capitalizeNextWord = false;
        }

        private boolean isGraceful() {
            boolean isGraceful = false;
            for (char c : this.name.toCharArray()) {
                if (!this.isGraceful(c)) continue;
                isGraceful = true;
            }
            return isGraceful;
        }

        private boolean isGraceful(char c) {
            return !Character.isLetterOrDigit(c) && c != '_';
        }
    }
}

