/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slimTables;

import fitnesse.responders.run.slimResponder.SlimTestContext;
import fitnesse.slimTables.DecisionTable;
import fitnesse.slimTables.ImportTable;
import fitnesse.slimTables.LibraryTable;
import fitnesse.slimTables.OrderedQueryTable;
import fitnesse.slimTables.QueryTable;
import fitnesse.slimTables.ScenarioTable;
import fitnesse.slimTables.ScriptTable;
import fitnesse.slimTables.SlimErrorTable;
import fitnesse.slimTables.SlimTable;
import fitnesse.slimTables.SubsetQueryTable;
import fitnesse.slimTables.Table;
import fitnesse.slimTables.TableTable;

public class SlimTableFactory {
    private boolean doesNotHaveColon(String tableType) {
        return tableType.indexOf(":") == -1;
    }

    private boolean beginsWith(String tableType, String typeCode) {
        return tableType.toUpperCase().startsWith(typeCode.toUpperCase());
    }

    public SlimTable makeSlimTable(Table table, String tableId, SlimTestContext slimTestContext) {
        String tableType = table.getCellContents(0, 0);
        if (this.beginsWith(tableType, "dt:") || this.beginsWith(tableType, "decision:")) {
            return new DecisionTable(table, tableId, slimTestContext);
        }
        if (this.beginsWith(tableType, "ordered query:")) {
            return new OrderedQueryTable(table, tableId, slimTestContext);
        }
        if (this.beginsWith(tableType, "subset query:")) {
            return new SubsetQueryTable(table, tableId, slimTestContext);
        }
        if (this.beginsWith(tableType, "query:")) {
            return new QueryTable(table, tableId, slimTestContext);
        }
        if (this.beginsWith(tableType, "table")) {
            return new TableTable(table, tableId, slimTestContext);
        }
        if (tableType.equalsIgnoreCase("script")) {
            return new ScriptTable(table, tableId, slimTestContext);
        }
        if (tableType.equalsIgnoreCase("scenario")) {
            return new ScenarioTable(table, tableId, slimTestContext);
        }
        if (tableType.equalsIgnoreCase("comment")) {
            return null;
        }
        if (tableType.equalsIgnoreCase("import")) {
            return new ImportTable(table, tableId, slimTestContext);
        }
        if (tableType.equalsIgnoreCase("library")) {
            return new LibraryTable(table, tableId, slimTestContext);
        }
        if (this.doesNotHaveColon(tableType)) {
            return new DecisionTable(table, tableId, slimTestContext);
        }
        return new SlimErrorTable(table, tableId, slimTestContext);
    }
}

