/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slimTables;

import fitnesse.responders.run.slimResponder.MockSlimTestContext;
import fitnesse.responders.run.slimResponder.SlimTestContext;
import fitnesse.slimTables.HtmlTableScanner;
import fitnesse.slimTables.SlimTable;
import fitnesse.slimTables.Table;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SlimTableTestSupport<T extends SlimTable> {
    private WikiPage root;
    protected List<Object> instructions;
    protected T tableUnderTest;

    private Class<T> getParameterizedClass() {
        Type superclass = this.getClass().getGenericSuperclass();
        if (superclass instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)ParameterizedType.class.cast(superclass);
            return (Class)type.getActualTypeArguments()[0];
        }
        throw new IllegalStateException("Unable to detect the actual type of SlimTable.");
    }

    public T createSlimTable(String tableText) {
        try {
            Constructor<T> constructor = this.getParameterizedClass().getConstructor(Table.class, String.class, SlimTestContext.class);
            WikiPageUtil.setPageContents(this.root, tableText);
            String html = this.root.getData().getHtml();
            HtmlTableScanner ts = new HtmlTableScanner(html);
            Table t = ts.getTable(0);
            MockSlimTestContext testContext = new MockSlimTestContext();
            return (T)((SlimTable)constructor.newInstance(t, "id", testContext));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot("root");
        this.instructions = new ArrayList<Object>();
    }

    protected T makeSlimTableAndBuildInstructions(String pageContents) throws Exception {
        this.tableUnderTest = this.createSlimTable(pageContents);
        ((SlimTable)this.tableUnderTest).appendInstructions(this.instructions);
        return this.tableUnderTest;
    }
}

