/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.socketservice;

import fitnesse.socketservice.SocketServer;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedList;

public class SocketService {
    private ServerSocket serverSocket = null;
    private Thread serviceThread = null;
    private volatile boolean running = false;
    private SocketServer server = null;
    private LinkedList<Thread> threads = new LinkedList();
    private volatile boolean everRan = false;

    public SocketService(int port, SocketServer server) throws Exception {
        this.server = server;
        this.serverSocket = new ServerSocket(port);
        this.serviceThread = new Thread(new Runnable(){

            public void run() {
                SocketService.this.serviceThread();
            }
        });
        this.serviceThread.start();
    }

    public void close() throws Exception {
        this.waitForServiceThreadToStart();
        this.running = false;
        this.serverSocket.close();
        this.serviceThread.join();
        this.waitForServerThreads();
    }

    private void waitForServiceThreadToStart() {
        if (this.everRan) {
            return;
        }
        while (!this.running) {
            Thread.yield();
        }
    }

    private void serviceThread() {
        this.running = true;
        this.everRan = true;
        while (this.running) {
            try {
                Socket s = this.serverSocket.accept();
                this.startServerThread(s);
            }
            catch (OutOfMemoryError e) {
                System.err.println("Can't create new thread.  Out of Memory.  Aborting");
                e.printStackTrace();
                System.exit(99);
            }
            catch (SocketException sox) {
                this.running = false;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServerThread(Socket s) {
        Thread serverThread = new Thread(new ServerRunner(s));
        LinkedList<Thread> linkedList = this.threads;
        synchronized (linkedList) {
            this.threads.add(serverThread);
        }
        serverThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForServerThreads() throws InterruptedException {
        while (this.threads.size() > 0) {
            Thread t;
            LinkedList<Thread> linkedList = this.threads;
            synchronized (linkedList) {
                if (this.threads.size() < 1) {
                    return;
                }
                t = this.threads.getFirst();
            }
            t.join();
        }
    }

    private class ServerRunner
    implements Runnable {
        private Socket socket;

        ServerRunner(Socket s) {
            this.socket = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                SocketService.this.server.serve(this.socket);
                LinkedList linkedList = SocketService.this.threads;
                synchronized (linkedList) {
                    SocketService.this.threads.remove(Thread.currentThread());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

