/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testutil;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;

public class MockSocket
extends Socket {
    InputStream input;
    OutputStream output;
    private String host;
    private boolean closed;

    public MockSocket() throws Exception {
        PipedInputStream serverInput = new PipedInputStream();
        PipedOutputStream clientOutput = new PipedOutputStream(serverInput);
        PipedInputStream clientInput = new PipedInputStream();
        PipedOutputStream serverOutput = new PipedOutputStream(clientInput);
        this.input = serverInput;
        this.output = serverOutput;
    }

    public MockSocket(String input) {
        this.input = new ByteArrayInputStream(input.getBytes());
        this.output = new ByteArrayOutputStream();
    }

    public MockSocket(InputStream input, OutputStream output) {
        this.input = input;
        this.output = output;
    }

    public InputStream getInputStream() {
        return this.input;
    }

    public OutputStream getOutputStream() {
        return this.output;
    }

    public void close() {
        this.closed = true;
        try {
            this.input.close();
            this.output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String getOutput() throws Exception {
        if (this.output instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)this.output).toString("UTF-8");
        }
        return "";
    }

    public void setHost(String host) {
        this.host = host;
    }

    public SocketAddress getRemoteSocketAddress() {
        return new InetSocketAddress(this.host, 123);
    }
}

