/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.updates;

import fitnesse.FitNesseContext;
import fitnesse.Updater;
import fitnesse.updates.Update;
import fitnesse.updates.UpdaterImplementation;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;

public class UpdaterBase
implements Updater {
    public FitNesseContext context;
    public Properties rootProperties;
    public Update[] updates;

    public UpdaterBase(FitNesseContext context) throws Exception {
        this.context = context;
        this.rootProperties = this.loadProperties();
    }

    public Properties getProperties() {
        return this.rootProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadProperties() throws Exception {
        Properties properties = new Properties();
        File propFile = this.getPropertiesFile();
        if (propFile.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(propFile);
                properties.load(is);
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        }
        return properties;
    }

    private File getPropertiesFile() throws Exception {
        String filename = this.context.rootPagePath + "/properties";
        return new File(filename);
    }

    public void saveProperties() throws Exception {
        OutputStream os = null;
        File propFile = null;
        try {
            propFile = this.getPropertiesFile();
            os = new FileOutputStream(propFile);
            this.writeProperties(os);
        }
        catch (Exception e) {
            String fileName = propFile != null ? propFile.getAbsolutePath() : "<unknown>";
            System.err.println("Filed to save properties file: \"" + fileName + "\". (exception: " + e + ")");
            throw e;
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    private void writeProperties(OutputStream OutputStream2) throws IOException {
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(OutputStream2, "8859_1"));
        awriter.write("#FitNesse properties");
        awriter.newLine();
        Object[] keys = this.rootProperties.keySet().toArray(new Object[0]);
        Arrays.sort(keys);
        Enumeration<Object> enumeration = this.rootProperties.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String val = (String)this.rootProperties.get(key);
            awriter.write(key + "=" + val);
            awriter.newLine();
        }
        awriter.flush();
    }

    public void update() throws Exception {
        Update[] updates = this.getUpdates();
        for (int i = 0; i < updates.length; ++i) {
            Update update = updates[i];
            if (!update.shouldBeApplied()) continue;
            this.performUpdate(update);
        }
        this.saveProperties();
    }

    private void performUpdate(Update update) throws Exception {
        try {
            this.print(update.getMessage());
            update.doUpdate();
        }
        catch (Exception e) {
            this.print("\n\t" + e + "\n");
        }
    }

    private Update[] getUpdates() throws Exception {
        return this.updates;
    }

    private void print(String message) {
        if (!UpdaterImplementation.testing) {
            System.out.print(message);
        }
    }
}

