/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.updates;

import fitnesse.FitNesse;
import fitnesse.FitNesseContext;
import fitnesse.updates.FileUpdate;
import fitnesse.updates.ReplacingFileUpdate;
import fitnesse.updates.Update;
import fitnesse.updates.UpdaterBase;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdaterImplementation
extends UpdaterBase {
    public static boolean testing = false;
    private ArrayList<String> updateDoNotCopyOver = new ArrayList();
    private ArrayList<String> updateList = new ArrayList();
    private String fitNesseVersion = FitNesse.VERSION.toString();

    public UpdaterImplementation(FitNesseContext context) throws Exception {
        super(context);
        this.createUpdateAndDoNotCopyOverLists();
        this.updates = this.makeAllUpdates();
    }

    private Update[] makeAllUpdates() throws Exception {
        ArrayList<Update> updates = new ArrayList<Update>();
        this.addAllFilesToBeReplaced(updates);
        this.addAllFilesThatShouldNotBeCopiedOver(updates);
        return updates.toArray(new Update[updates.size()]);
    }

    private void addAllFilesThatShouldNotBeCopiedOver(List<Update> updates) throws Exception {
        for (String nonCopyableFile : this.updateDoNotCopyOver) {
            String path = this.getCorrectPathForTheDestination(nonCopyableFile);
            String source = this.getCorrectPathFromJar(nonCopyableFile);
            updates.add(new FileUpdate(this.context.rootPath, source, path));
        }
    }

    private void addAllFilesToBeReplaced(List<Update> updates) throws Exception {
        for (String updateableFile : this.updateList) {
            String path = this.getCorrectPathForTheDestination(updateableFile);
            String source = this.getCorrectPathFromJar(updateableFile);
            updates.add(new ReplacingFileUpdate(this.context.rootPath, source, path));
        }
    }

    public String getCorrectPathFromJar(String updateableFile) {
        return "Resources/" + updateableFile;
    }

    public String getCorrectPathForTheDestination(String updateableFile) {
        if (updateableFile.startsWith("FitNesseRoot")) {
            updateableFile = updateableFile.replace("FitNesseRoot", this.context.rootDirectoryName);
        }
        return FileUtil.getPathOfFile(updateableFile);
    }

    private void createUpdateAndDoNotCopyOverLists() {
        this.tryToGetUpdateFilesFromJarFile();
        File updateFileList = new File(this.context.rootPagePath, "updateList");
        File updateDoNotCopyOverFileList = new File(this.context.rootPagePath, "updateDoNotCopyOverList");
        this.tryToParseTheFileIntoTheList(updateFileList, this.updateList);
        this.tryToParseTheFileIntoTheList(updateDoNotCopyOverFileList, this.updateDoNotCopyOver);
    }

    private void tryToGetUpdateFilesFromJarFile() {
        try {
            this.getUpdateFilesFromJarFile();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void getUpdateFilesFromJarFile() throws Exception {
        FileUpdate update = new FileUpdate(this.context.rootPagePath, "Resources/updateList", ".");
        update.doUpdate();
        update = new FileUpdate(this.context.rootPagePath, "Resources/updateDoNotCopyOverList", ".");
        update.doUpdate();
    }

    public void tryToParseTheFileIntoTheList(File updateFileList, ArrayList<String> list) {
        if (!updateFileList.exists()) {
            throw new RuntimeException("Could Not Find UpdateList");
        }
        try {
            this.parseTheFileContentToAList(updateFileList, list);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void parseTheFileContentToAList(File updateFileList, ArrayList<String> list) throws Exception {
        String[] filePaths;
        String content = FileUtil.getFileContent(updateFileList);
        for (String path : filePaths = content.split("\n")) {
            list.add(path);
        }
    }

    @Override
    public void update() throws Exception {
        if (this.shouldUpdate()) {
            System.err.println("Unpacking new version of FitNesse resources.  Please be patient.");
            super.update();
            this.getProperties().put("Version", this.fitNesseVersion);
            this.saveProperties();
        }
    }

    private void exit() {
        if (!testing) {
            System.exit(0);
        }
    }

    private boolean shouldUpdate() {
        String versionProperty = this.getProperties().getProperty("Version");
        return versionProperty == null || !versionProperty.equals(this.fitNesseVersion);
    }

    public void setFitNesseVersion(String version) {
        this.fitNesseVersion = version;
    }
}

