/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.CommitingPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.VirtualCouplingExtension;
import fitnesse.wiki.WikiPage;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CachingPage
extends CommitingPage {
    private static final long serialVersionUID = 1L;
    public static int cacheTime = 3000;
    protected Map<String, WikiPage> children = new HashMap<String, WikiPage>();
    private transient SoftReference<PageData> cachedData;
    private transient long cachedDataCreationTime = 0L;

    public CachingPage(String name, WikiPage parent) throws Exception {
        super(name, parent);
        this.addExtention(new VirtualCouplingExtension(this));
    }

    @Override
    public abstract boolean hasChildPage(String var1) throws Exception;

    protected abstract WikiPage createChildPage(String var1) throws Exception;

    protected abstract void loadChildren() throws Exception;

    protected abstract PageData makePageData() throws Exception;

    @Override
    public WikiPage addChildPage(String name) throws Exception {
        WikiPage page = this.createChildPage(name);
        this.children.put(name, page);
        return page;
    }

    @Override
    public List<WikiPage> getNormalChildren() throws Exception {
        this.loadChildren();
        return this.getCachedChildren();
    }

    public List<WikiPage> getCachedChildren() throws Exception {
        return new ArrayList<WikiPage>(this.children.values());
    }

    @Override
    public void removeChildPage(String name) throws Exception {
        if (this.hasCachedSubpage(name)) {
            this.children.remove(name);
        }
    }

    @Override
    public WikiPage getNormalChildPage(String name) throws Exception {
        if (this.hasCachedSubpage(name) || this.hasChildPage(name)) {
            return this.children.get(name);
        }
        return null;
    }

    protected boolean hasCachedSubpage(String name) {
        return this.children.containsKey(name);
    }

    @Override
    public PageData getData() throws Exception {
        if (this.cachedDataExpired()) {
            PageData data = this.makePageData();
            this.setCachedData(data);
        }
        return new PageData(this.getCachedData());
    }

    private boolean cachedDataExpired() throws Exception {
        long now = System.currentTimeMillis();
        return this.getCachedData() == null || now >= this.cachedDataCreationTime + (long)cacheTime;
    }

    public void dumpExpiredCachedData() throws Exception {
        if (this.cachedDataExpired()) {
            this.clearCache();
        }
    }

    @Override
    public VersionInfo commit(PageData data) throws Exception {
        VersionInfo versionInfo = super.commit(data);
        this.setCachedData(this.makePageData());
        return versionInfo;
    }

    private void setCachedData(PageData data) throws Exception {
        if (this.cachedData != null) {
            this.cachedData.clear();
        }
        this.cachedData = new SoftReference<PageData>(data);
        this.cachedDataCreationTime = System.currentTimeMillis();
    }

    public PageData getCachedData() throws Exception {
        if (this.cachedData != null) {
            return this.cachedData.get();
        }
        return null;
    }

    public void clearCache() {
        this.cachedData.clear();
        this.cachedData = null;
    }
}

