/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.ExternalSuitePage;
import fitnesse.wiki.ExternalTestPage;
import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.widgets.WikiWordWidget;
import java.util.ArrayList;
import java.util.List;
import util.DiskFileSystem;
import util.FileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageRepository {
    private FileSystem fileSystem;

    public PageRepository() {
        this.fileSystem = new DiskFileSystem();
    }

    public PageRepository(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public WikiPage makeChildPage(String name, FileSystemPage parent) throws Exception {
        String path = parent.getFileSystemPath() + "/" + name;
        if (this.hasContentChild(path).booleanValue()) {
            return new FileSystemPage(name, parent, this.fileSystem);
        }
        if (this.hasHtmlChild(path).booleanValue()) {
            return new ExternalSuitePage(path, name, parent, this.fileSystem);
        }
        return new FileSystemPage(name, parent, this.fileSystem);
    }

    private Boolean hasContentChild(String path) {
        for (String child : this.fileSystem.list(path)) {
            if (child.equals("content.txt")) {
                return true;
            }
            if (child.length() != 11 || child.charAt(0) != 'c' || child.charAt(1) != 'o' || child.charAt(2) != 'n' || child.charAt(3) != 't' || child.charAt(4) != 'e' || child.charAt(5) != 'n' || child.charAt(6) != 't' || child.charAt(7) != '.' || child.charAt(8) != 't' || child.charAt(9) != 'x' || child.charAt(10) != 't') continue;
            return true;
        }
        return false;
    }

    private Boolean hasHtmlChild(String path) {
        if (path.endsWith(".html")) {
            return true;
        }
        for (String child : this.fileSystem.list(path)) {
            if (!this.hasHtmlChild(path + "/" + child).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public List<WikiPage> findChildren(ExternalSuitePage parent) throws Exception {
        ArrayList<WikiPage> children = new ArrayList<WikiPage>();
        for (String child : this.fileSystem.list(parent.getFileSystemPath())) {
            String childPath = parent.getFileSystemPath() + "/" + child;
            if (child.endsWith(".html")) {
                children.add(new ExternalTestPage(childPath, WikiWordWidget.makeWikiWord(child.replace(".html", "")), parent, this.fileSystem));
                continue;
            }
            if (!this.hasHtmlChild(childPath).booleanValue()) continue;
            children.add(new ExternalSuitePage(childPath, WikiWordWidget.makeWikiWord(child), parent, this.fileSystem));
        }
        return children;
    }
}

