/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageDummy;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.WikiPageProperty;
import fitnesse.wiki.XmlizePageCondition;
import fitnesse.wiki.XmlizerPageHandler;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import util.XmlUtil;

public class PageXmlizer {
    private static SimpleDateFormat dateFormat = WikiPageProperty.getTimeFormat();
    private LinkedList<XmlizePageCondition> pageConditions = new LinkedList();

    public Document xmlize(WikiPage page) throws Exception {
        Document document = XmlUtil.newDocument();
        Element pageElement = this.createXmlFromPage(document, page);
        document.appendChild(pageElement);
        return document;
    }

    public void deXmlize(Document doc, WikiPage context, XmlizerPageHandler handler) throws Exception {
        Element pageElement = doc.getDocumentElement();
        this.addChildFromXml(pageElement, context, handler);
    }

    public void deXmlizeSkippingRootLevel(Document document, WikiPage context, XmlizerPageHandler handler) throws Exception {
        Element pageElement = document.getDocumentElement();
        this.addChildrenFromXml(pageElement, context, handler);
    }

    public Document xmlize(PageData data) throws Exception {
        Document document = XmlUtil.newDocument();
        Element dataElement = document.createElement("data");
        XmlUtil.addCdataNode(document, dataElement, "content", data.getContent());
        Element propertiesElement = data.getProperties().makeRootElement(document);
        dataElement.appendChild(propertiesElement);
        document.appendChild(dataElement);
        return document;
    }

    public PageData deXmlizeData(Document document) throws Exception {
        PageData data = new PageData(new WikiPageDummy());
        Element dataElement = document.getDocumentElement();
        String content = XmlUtil.getLocalTextValue(dataElement, "content");
        data.setContent(content);
        Element propertiesElement = XmlUtil.getLocalElementByTagName(dataElement, "properties");
        WikiPageProperties properties = new WikiPageProperties(propertiesElement);
        data.setProperties(properties);
        return data;
    }

    private void addPageXmlToElement(Document document, Element context, WikiPage page) throws Exception {
        if (this.pageMeetsConditions(page)) {
            context.appendChild(this.createXmlFromPage(document, page));
        }
    }

    private boolean pageMeetsConditions(WikiPage page) throws Exception {
        for (XmlizePageCondition xmlizePageCondition : this.pageConditions) {
            if (xmlizePageCondition.canBeXmlized(page)) continue;
            return false;
        }
        return true;
    }

    private Element createXmlFromPage(Document document, WikiPage page) throws Exception {
        Element pageElement = document.createElement("page");
        XmlUtil.addTextNode(document, pageElement, "name", page.getName());
        this.addLastModifiedTag(page, document, pageElement);
        this.addXmlFromChildren(page, document, pageElement);
        return pageElement;
    }

    private void addLastModifiedTag(WikiPage page, Document document, Element pageElement) throws Exception {
        Date lastModificationTime = page.getData().getProperties().getLastModificationTime();
        String lastModifiedTimeString = dateFormat.format(lastModificationTime);
        XmlUtil.addTextNode(document, pageElement, "lastModified", lastModifiedTimeString);
    }

    private void addXmlFromChildren(WikiPage page, Document document, Element pageElement) throws Exception {
        Element childrenElement = document.createElement("children");
        List<WikiPage> children = page.getChildren();
        Collections.sort(children);
        for (WikiPage child : children) {
            this.addPageXmlToElement(document, childrenElement, child);
        }
        pageElement.appendChild(childrenElement);
    }

    private void addChildFromXml(Element pageElement, WikiPage context, XmlizerPageHandler handler) throws Exception {
        String name = XmlUtil.getTextValue(pageElement, "name");
        String modifiedDateString = XmlUtil.getTextValue(pageElement, "lastModified");
        Date modifiedDate = modifiedDateString == null ? new Date(0L) : dateFormat.parse(modifiedDateString);
        WikiPage childPage = context.getChildPage(name);
        if (childPage == null) {
            childPage = context.addChildPage(name);
        }
        handler.enterChildPage(childPage, modifiedDate);
        this.addChildrenFromXml(pageElement, childPage, handler);
        handler.exitPage();
    }

    private void addChildrenFromXml(Element pageElement, WikiPage contextPage, XmlizerPageHandler handler) throws Exception {
        Element childrenElement = XmlUtil.getLocalElementByTagName(pageElement, "children");
        NodeList childNodes = childrenElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!"page".equals(node.getNodeName())) continue;
            this.addChildFromXml((Element)node, contextPage, handler);
        }
    }

    public void addPageCondition(XmlizePageCondition xmlizePageCondition) {
        this.pageConditions.add(xmlizePageCondition);
    }
}

