/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionInfo
implements Comparable<VersionInfo>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Pattern COMPEX_NAME_PATTERN = Pattern.compile("(?:([a-zA-Z][^\\-]*)-)?(?:\\d+-)?(\\d{14})");
    private static int counter = 0;
    private String name;
    private String author;
    private Date creationTime;

    public static SimpleDateFormat makeVersionTimeFormat() {
        return new SimpleDateFormat("yyyyMMddHHmmss");
    }

    public static int nextId() {
        return counter++;
    }

    public VersionInfo(String name, String author, Date creationTime) {
        this.name = name;
        this.author = author;
        this.creationTime = creationTime;
    }

    public VersionInfo(String complexName) {
        this(complexName, "", new Date());
        Matcher match = COMPEX_NAME_PATTERN.matcher(complexName);
        if (match.find()) {
            this.author = match.group(1);
            if (this.author == null) {
                this.author = "";
            }
            try {
                this.creationTime = VersionInfo.makeVersionTimeFormat().parse(match.group(2));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getAuthor() {
        return this.author;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public String getName() {
        return this.name;
    }

    public static String getVersionNumber(String complexName) {
        Matcher match = COMPEX_NAME_PATTERN.matcher(complexName);
        match.find();
        return match.group(2);
    }

    @Override
    public int compareTo(VersionInfo o) {
        if (o instanceof VersionInfo) {
            VersionInfo otherVersion = o;
            return this.getCreationTime().compareTo(otherVersion.getCreationTime());
        }
        return 0;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof VersionInfo) {
            VersionInfo otherVersion = (VersionInfo)o;
            return this.getName().equals(otherVersion.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

