/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.responders.ErrorResponder;
import fitnesse.wiki.Extension;
import fitnesse.wiki.NullVirtualCouplingPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.ProxyPage;
import fitnesse.wiki.VirtualCouplingPage;
import fitnesse.wiki.WikiPage;

public class VirtualCouplingExtension
implements Extension {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "VirtualCoupling";
    private WikiPage hostPage;
    protected VirtualCouplingPage virtualCoupling;

    public String getName() {
        return NAME;
    }

    public VirtualCouplingExtension(WikiPage page) throws Exception {
        this.hostPage = page;
        this.resetVirtualCoupling();
    }

    public void setVirtualCoupling(VirtualCouplingPage coupling) {
        this.virtualCoupling = coupling;
    }

    public void resetVirtualCoupling() throws Exception {
        this.virtualCoupling = new NullVirtualCouplingPage(this.hostPage);
    }

    public WikiPage getVirtualCoupling() throws Exception {
        this.detectAndLoadVirtualChildren();
        return this.virtualCoupling;
    }

    protected void detectAndLoadVirtualChildren() throws Exception {
        PageData data = this.hostPage.getData();
        if (data.hasAttribute("VirtualWiki")) {
            this.loadVirtualChildren(data.getAttribute("VirtualWiki"));
        }
    }

    public void loadVirtualChildren(String url) throws Exception {
        try {
            ProxyPage proxy = ProxyPage.retrievePage(url);
            this.virtualCoupling = new VirtualCouplingPage(this.hostPage, proxy);
        }
        catch (Exception e) {
            WikiPage page = this.hostPage.getChildPage("VirtualWikiNetworkError");
            if (page == null) {
                page = this.hostPage.addChildPage("VirtualWikiNetworkError");
            }
            PageData data = page.getData();
            data.setContent("{{{" + ErrorResponder.makeExceptionString(e) + "}}}");
            page.commit(data);
        }
    }
}

