/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext;

import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.WidgetVisitor;
import fitnesse.wikitext.widgets.ParentWidget;
import util.GracefulNamer;

public abstract class WikiWidget {
    protected ParentWidget parent = null;
    public static final String LINE_BREAK_PATTERN = "\n";

    protected WikiWidget(ParentWidget parent) {
        this.parent = parent;
        this.addToParent();
    }

    public ParentWidget getParent() {
        return this.parent;
    }

    protected void addToParent() {
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    public abstract String render() throws Exception;

    public void acceptVisitor(WidgetVisitor visitor) throws Exception {
        visitor.visit(this);
    }

    public WikiPage getWikiPage() {
        return this.parent.getWikiPage();
    }

    public String asWikiText() throws Exception {
        return this.getClass().toString() + ".asWikiText()";
    }

    public boolean isRegracing() {
        return false;
    }

    public String regrace(String disgracefulName) {
        String newName = disgracefulName;
        if (this.isRegracing()) {
            newName = GracefulNamer.regrace(disgracefulName);
        }
        return newName;
    }
}

