/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.html.HtmlElement;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.RawHtml;
import fitnesse.responders.WikiImportProperty;
import fitnesse.wiki.PageData;
import fitnesse.wikitext.widgets.BlankParentWidget;
import fitnesse.wikitext.widgets.ParentWidget;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CollapsableWidget
extends ParentWidget {
    private static final String ENDL = "\n";
    public static final String REGEXP = "!\\*+[<>]? .*?\n.*?\n\\*+!\n?";
    private static final Pattern pattern = Pattern.compile("!\\*+([<>])? (.*?)\n(.*?)\n\\*+!", 40);
    private static Random random = new Random();
    private String cssClass = "collapse_rim";
    private ParentWidget titleWidget;
    public boolean expanded = true;
    public boolean invisible = false;
    private boolean showEditCommand = true;
    private static final String collapsableOpenCss = "collapsable";
    private static final String collapsableInvisibleCss = "invisible";
    private static final String collapsableClosedCss = "hidden";
    private static final String collapsableOpenImg = "/files/images/collapsableOpen.gif";
    private static final String collapsableClosedImg = "/files/images/collapsableClosed.gif";
    private static final String collapseAllLink = "<a href=\"javascript:collapseAll();\">Collapse All</a>";
    private static final String expandAllLink = "<a href=\"javascript:expandAll();\">Expand All</a>";

    public CollapsableWidget(ParentWidget parent) {
        super(parent);
    }

    public CollapsableWidget(ParentWidget parent, String text) throws Exception {
        this(parent);
        this.showEditCommand = false;
        Matcher match = pattern.matcher(text);
        match.find();
        String tailChar = match.group(1);
        this.expanded = tailChar == null;
        this.invisible = this.expanded ? false : "<".equals(tailChar);
        String title = match.group(2);
        String body = match.group(3);
        this.init(title, body, this);
    }

    public CollapsableWidget(ParentWidget parent, String title, String body, String cssClass, boolean collapsed) throws Exception {
        this(parent);
        this.init(title, body, this);
        this.cssClass = cssClass;
        this.expanded = !collapsed;
    }

    public CollapsableWidget(ParentWidget parent, ParentWidget includeParent, String title, String body, String cssClass, boolean collapsed) throws Exception {
        this(parent);
        this.init(title, body, includeParent);
        this.cssClass = cssClass;
        this.expanded = !collapsed;
    }

    private void init(String title, String body, ParentWidget parent) throws Exception {
        this.titleWidget = new BlankParentWidget(parent, "!meta " + title + " " + this.makeEditLinks(title));
        this.addChildWidgets(body);
    }

    private String makeEditLinks(String title) {
        if (!this.showEditCommand) {
            return "";
        }
        try {
            PageData pageData = this.getWikiPage().getData();
            if (WikiImportProperty.isImported(pageData)) {
                return this.makeImportedEditLinks(pageData, title);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "[[(edit)][" + this.makeLocalEditLinks(title) + "]]";
    }

    private String makeLocalEditLinks(String title) {
        String[] splitTitle = title.split("\\s+");
        return splitTitle[splitTitle.length - 1] + "?edit&amp;redirectToReferer=true&amp;redirectAction=";
    }

    private String makeImportedEditLinks(PageData pageData, String title) {
        return "(edit: [[locally][" + this.makeLocalEditLinks(title) + "]]" + " | [[remotely][" + this.makeRemoteLink(pageData, title) + "]])";
    }

    private String makeRemoteLink(PageData pageData, String title) {
        String remoteInputParameters = WikiImportProperty.makeRemoteEditQueryParameters();
        try {
            WikiImportProperty importProperty = WikiImportProperty.createFrom(pageData.getProperties());
            return importProperty.getSourceUrl() + "?" + remoteInputParameters;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String render() throws Exception {
        RawHtml titleElement = new RawHtml("&nbsp;" + this.titleWidget.childHtml());
        RawHtml bodyElement = new RawHtml(this.childHtml());
        HtmlTag html = this.makeCollapsableSection(titleElement, bodyElement);
        return ((HtmlElement)html).html();
    }

    public HtmlTag makeCollapsableSection(HtmlElement title, HtmlElement content) {
        String id = random.nextLong() + "";
        if (this.invisible) {
            HtmlTag outerDiv = HtmlUtil.makeDivTag(collapsableInvisibleCss);
            outerDiv.add(content);
            return outerDiv;
        }
        HtmlTag outerDiv = HtmlUtil.makeDivTag(this.cssClass);
        HtmlTag image = new HtmlTag("img");
        image.addAttribute("src", this.imageSrc());
        image.addAttribute("class", "left");
        image.addAttribute("id", "img" + id);
        HtmlTag anchor = new HtmlTag("a", image);
        anchor.addAttribute("href", "javascript:toggleCollapsable('" + id + "');");
        HtmlTag links = new HtmlTag("div");
        links.addAttribute("style", "float: right;");
        links.addAttribute("class", "meta");
        links.add("<a href=\"javascript:expandAll();\">Expand All</a> | <a href=\"javascript:collapseAll();\">Collapse All</a>");
        outerDiv.add(links);
        outerDiv.add(anchor);
        outerDiv.add(title);
        HtmlTag collapsablediv = this.makeCollapsableDiv();
        collapsablediv.addAttribute("id", id);
        collapsablediv.add(content);
        outerDiv.add(collapsablediv);
        return outerDiv;
    }

    private HtmlTag makeCollapsableDiv() {
        if (!this.expanded) {
            return HtmlUtil.makeDivTag(collapsableClosedCss);
        }
        return HtmlUtil.makeDivTag(collapsableOpenCss);
    }

    private String imageSrc() {
        if (this.expanded) {
            return collapsableOpenImg;
        }
        return collapsableClosedImg;
    }

    public String asWikiText() throws Exception {
        return "";
    }
}

