/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.html.HtmlUtil;
import fitnesse.wikitext.widgets.ParentWidget;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import util.Expression;

public class EvaluatorWidget
extends ParentWidget {
    public static final String REGEXP = "\\$\\{=[ \\t]*(?:%[-#+ 0,(]*(?:[0-9]*\\.?[0-9]*)?[a-zA-Z]+[ \\t]*:)?[^:=]*=\\}";
    public static final Pattern pattern = Pattern.compile("\\$\\{=([^=]*)=\\}", 40);
    public static final Pattern formatParser = Pattern.compile("^[ \\t]*((%[-#+ 0,(]*[0-9.]*([a-zA-Z])[^: \\t]*)[ \\t]*:)?[ \\t]*(.*)$");
    private String name = null;
    private String formatSpec = null;
    private char conversion = (char)63;
    private String renderedText;
    private boolean rendered;

    public EvaluatorWidget(ParentWidget parent, String text) {
        super(parent);
        this.name = text;
        Matcher match = pattern.matcher(text);
        if (match.find()) {
            this.name = match.group(1);
        }
    }

    public String render() throws Exception {
        if (!this.rendered) {
            this.doRender();
        }
        return this.renderedText;
    }

    private void doRender() throws Exception {
        this.parseOutFormat(this.expandVariables(this.name));
        if (this.renderedText.length() > 0) {
            try {
                this.evaluateAndFormat();
            }
            catch (Exception e) {
                this.renderedText = this.makeInvalidVariableExpression(this.name);
            }
        }
        this.rendered = true;
    }

    private void parseOutFormat(String expr) {
        Matcher match = formatParser.matcher(expr);
        if (match.find()) {
            this.formatSpec = match.group(2) == null ? null : match.group(2).trim();
            this.conversion = (char)(match.group(3) == null ? 63 : (int)match.group(3).trim().charAt(0));
            this.renderedText = match.group(4) == null ? "" : match.group(4).trim();
        } else {
            this.formatSpec = null;
            this.renderedText = expr.trim();
        }
    }

    private void evaluateAndFormat() throws Exception {
        Double result = new Expression(this.renderedText).evaluate();
        Long iResult = new Long(Math.round(result));
        if (this.formatSpec == null) {
            this.renderedText = result.equals(iResult.doubleValue()) ? iResult.toString() : result.toString();
        } else if ("aAdhHoOxX".indexOf(this.conversion) >= 0) {
            this.renderedText = String.format(this.formatSpec, iResult);
        } else if ("bB".indexOf(this.conversion) >= 0) {
            this.renderedText = result == 0.0 ? "false" : "true";
        } else if ("sScC".indexOf(this.conversion) >= 0) {
            boolean isInt = result.equals(iResult.doubleValue());
            String sString = isInt ? String.format(this.formatSpec, iResult.toString()) : String.format(this.formatSpec, result.toString());
            this.renderedText = sString.replaceAll(" ", HtmlUtil.NBSP.html());
        } else if ("tT".indexOf(this.conversion) >= 0) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(iResult);
            this.renderedText = String.format(this.formatSpec, cal.getTime());
        } else {
            this.renderedText = "eEfgG".indexOf(this.conversion) >= 0 ? String.format(this.formatSpec, result) : this.makeInvalidVariableExpression("invalid format: " + this.formatSpec);
        }
    }

    private String makeInvalidVariableExpression(String name) throws Exception {
        return HtmlUtil.metaText("invalid expression: " + name);
    }

    public String asWikiText() throws Exception {
        return "${=" + this.name + "=}";
    }
}

