/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.wikitext.WikiWidget;
import fitnesse.wikitext.widgets.LinkWidget;
import fitnesse.wikitext.widgets.ParentWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImageWidget
extends WikiWidget {
    public static final String REGEXP = "(?:!img(?:-[lr])? \\S+)|(?:https?://[^\\s]+[^\\s.)]+.(?:gif|jpg|GIF|JPG))";
    private static final Pattern pattern = Pattern.compile("(!img(-[lr])? )?(\\S*)");
    private String picturePath;
    private String alignment;
    private boolean usesBangImg;

    public ImageWidget(ParentWidget parent, String text) {
        super(parent);
        Matcher match = pattern.matcher(text);
        if (match.find()) {
            this.picturePath = LinkWidget.makeUrlUsable(match.group(3));
            boolean bl = this.usesBangImg = match.group(1) != null;
            if (this.usesBangImg) {
                this.alignment = match.group(2);
            }
        } else {
            System.err.println("ImagesWidget parse error: " + text);
        }
    }

    public String render() throws Exception {
        StringBuffer html = new StringBuffer("<img src=\"");
        html.append(this.picturePath).append("\"");
        if (this.alignment != null) {
            html.append(" class=\"");
            if ("-l".equals(this.alignment)) {
                html.append("left");
            } else {
                html.append("right");
            }
            html.append("\"");
        }
        html.append("/>");
        return html.toString();
    }

    public String asWikiText() throws Exception {
        String pathString = this.picturePath;
        if (pathString.startsWith("/files")) {
            pathString = "http:/" + pathString;
        }
        if (this.usesBangImg) {
            String alignmentString = this.alignment == null ? "" : this.alignment;
            return "!img" + alignmentString + " " + pathString;
        }
        return pathString;
    }
}

