/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.components.PageReferencer;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.ProxyPage;
import fitnesse.wiki.VirtualEnabledPageCrawler;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wikitext.widgets.CollapsableWidget;
import fitnesse.wikitext.widgets.ParentWidget;
import fitnesse.wikitext.widgets.WidgetRoot;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludeWidget
extends ParentWidget
implements PageReferencer {
    public static final String REGEXP = "^!include(?: +-setup| +-teardown| +-seamless| +-c)? (?:[<>^.])?(?:\\b[A-Z](?:[a-z0-9]+[A-Z][a-z0-9]*)+[.]?)+\\b\n?";
    static final Pattern pattern = Pattern.compile("^!include *(-setup|-teardown|-seamless|-c)? (.*)");
    public static final String COLLAPSE_SETUP = "COLLAPSE_SETUP";
    public static final String COLLAPSE_TEARDOWN = "COLLAPSE_TEARDOWN";
    protected String pageName;
    protected WikiPage includingPage;
    protected WikiPage includedPage;
    protected WikiPage parentPage;
    private static Map<String, String> optionPrefixMap = IncludeWidget.buildOptionPrefixMap();
    private static Map<String, String> optionCssMap = IncludeWidget.buildOptionsCssMap();
    private String includeOption;

    public IncludeWidget(ParentWidget parent, String text) throws Exception {
        super(parent);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            this.initializeWidget(parent, matcher);
            this.addChildWidgetsThatRepresentTheInclusion();
        }
    }

    private void addChildWidgetsThatRepresentTheInclusion() throws Exception {
        if (this.isParentOf(this.includedPage, this.includingPage)) {
            this.addChildWidgets(String.format("!meta Error! Cannot include parent page (%s).\n", this.pageName));
        } else {
            this.buildWidget();
        }
    }

    private void initializeWidget(ParentWidget parent, Matcher matcher) throws Exception {
        this.includeOption = this.getOption(matcher);
        this.pageName = this.getPageName(matcher);
        this.includingPage = parent.getWikiPage();
        this.parentPage = this.includingPage.getParent();
        this.includedPage = this.getIncludedPage();
    }

    private boolean isParentOf(WikiPage possibleParent, WikiPage page) throws Exception {
        while (page.getParent() != page) {
            if (possibleParent == page) {
                return true;
            }
            page = page.getParent();
        }
        return false;
    }

    public String getPageName() {
        return this.pageName;
    }

    protected String getIncludedPageContent() throws Exception {
        PageCrawler crawler = this.parentPage.getPageCrawler();
        crawler.setDeadEndStrategy(new VirtualEnabledPageCrawler());
        WikiPagePath pagePath = PathParser.parse(this.pageName);
        this.includedPage = crawler.getSiblingPage(this.includingPage, pagePath);
        if (this.includedPage != null) {
            this.includedPage.setParentForVariables(this.getWikiPage().getParentForVariables());
            return this.includedPage.getData().getContent();
        }
        if (this.includingPage instanceof ProxyPage) {
            ProxyPage proxy = (ProxyPage)this.includingPage;
            String host = proxy.getHost();
            int port = proxy.getHostPort();
            try {
                ProxyPage remoteIncludedPage = new ProxyPage("RemoteIncludedPage", null, host, port, pagePath);
                return remoteIncludedPage.getData().getContent();
            }
            catch (Exception e) {
                return "!meta '''Remote page " + host + ":" + port + "/" + this.pageName + " does not exist.'''";
            }
        }
        return "!meta '''Page include failed because the page " + this.pageName + " does not exist.'''";
    }

    protected WikiPage getIncludedPage() throws Exception {
        PageCrawler crawler = this.parentPage.getPageCrawler();
        crawler.setDeadEndStrategy(new VirtualEnabledPageCrawler());
        return crawler.getPage(this.parentPage, PathParser.parse(this.pageName));
    }

    protected WikiPage getParentPage() throws Exception {
        return this.parent.getWikiPage().getParent();
    }

    private String getOption(Matcher match) {
        return match.group(1);
    }

    private String getPageName(Matcher match) {
        return match.group(2);
    }

    private void buildWidget() throws Exception {
        ParentWidget incRoot;
        String includedText = this.getIncludedPageContent(this.includeOption);
        String widgetText = this.processLiterals(includedText);
        ParentWidget parentWidget = incRoot = this.includedPage == null ? this : new WidgetRoot(this.includedPage, this);
        if (this.isSeamLess(this.includeOption) || this.getRoot().isGatheringInfo()) {
            incRoot.addChildWidgets(widgetText + "\n");
        } else {
            new CollapsableWidget(incRoot, this, this.getPrefix(this.includeOption) + this.pageName, widgetText, this.getCssClass(this.includeOption), this.isCollapsed(this.includeOption));
        }
    }

    private String getIncludedPageContent(String option) throws Exception {
        if (this.isSetup(option) || this.isTeardown(option)) {
            return this.replaceSpecialVariables(this.getIncludedPageContent());
        }
        return this.getIncludedPageContent();
    }

    private String replaceSpecialVariables(String includedPageContent) throws Exception {
        return includedPageContent.replaceAll("\\$\\{PAGE_NAME\\}", this.includingPage.getName());
    }

    private boolean isSeamLess(String option) {
        return "-seamless".equals(option);
    }

    private String getCssClass(String option) {
        return optionCssMap.get(option);
    }

    private String getPrefix(String option) {
        return optionPrefixMap.get(option);
    }

    private boolean isCollapsed(String option) throws Exception {
        if (this.isSetup(option) && this.isSetupCollapsed()) {
            return true;
        }
        if (this.isTeardown(option) && this.isTeardownCollapsed()) {
            return true;
        }
        return "-c".equals(option);
    }

    private static Map<String, String> buildOptionsCssMap() {
        HashMap<String, String> optionCssMap = new HashMap<String, String>();
        optionCssMap.put("-setup", "setup");
        optionCssMap.put("-teardown", "teardown");
        optionCssMap.put("-c", "included");
        optionCssMap.put(null, "included");
        return optionCssMap;
    }

    private static Map<String, String> buildOptionPrefixMap() {
        HashMap<String, String> optionPrefixMap = new HashMap<String, String>();
        optionPrefixMap.put("-setup", "Set Up: ");
        optionPrefixMap.put("-teardown", "Tear Down: ");
        optionPrefixMap.put("-c", "Included page: ");
        optionPrefixMap.put(null, "Included page: ");
        return optionPrefixMap;
    }

    private boolean isTeardownCollapsed() throws Exception {
        String teardownCollapseVariable = this.parent.getVariable(COLLAPSE_TEARDOWN);
        return teardownCollapseVariable == null || "true".equals(teardownCollapseVariable);
    }

    private boolean isTeardown(String option) {
        return "-teardown".equals(option);
    }

    private boolean isSetupCollapsed() throws Exception {
        String setupCollapseVariable = this.parent.getVariable(COLLAPSE_SETUP);
        return setupCollapseVariable == null || "true".equals(setupCollapseVariable);
    }

    private boolean isSetup(String option) {
        return "-setup".equals(option);
    }

    @Override
    public String render() throws Exception {
        return this.childHtml();
    }

    @Override
    public WikiPage getReferencedPage() throws Exception {
        return this.getParentPage().getPageCrawler().getPage(this.getParentPage(), PathParser.parse(this.pageName));
    }

    @Override
    public String asWikiText() throws Exception {
        return "";
    }

    @Override
    public String processLiterals(String value) throws Exception {
        return super.processLiterals(value);
    }
}

