/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.html.HtmlUtil;
import fitnesse.wiki.PageData;
import fitnesse.wikitext.WikiWidget;
import fitnesse.wikitext.widgets.ParentWidget;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LastModifiedWidget
extends WikiWidget {
    public static final String REGEXP = "^!lastmodified";

    private static SimpleDateFormat makeTimeFormat() {
        return new SimpleDateFormat("hh:mm:ss a");
    }

    private static SimpleDateFormat makeDateFormat() {
        return new SimpleDateFormat("MMM dd, yyyy");
    }

    public LastModifiedWidget(ParentWidget parent, String text) throws Exception {
        super(parent);
    }

    public String render() throws Exception {
        PageData data = this.getWikiPage().getData();
        String formattedDate = LastModifiedWidget.formatDate(data.getProperties().getLastModificationTime());
        String user = data.getAttribute("LastModifyingUser");
        if (user == null || "".equals(user)) {
            return HtmlUtil.metaText("Last modified anonymously on " + formattedDate);
        }
        return HtmlUtil.metaText("Last modified by " + user + " on " + formattedDate);
    }

    public static String formatDate(Date date) {
        String formattedDate = LastModifiedWidget.makeDateFormat().format(date) + " at " + LastModifiedWidget.makeTimeFormat().format(date);
        return formattedDate;
    }
}

