/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.wikitext.WikiWidget;
import fitnesse.wikitext.widgets.ParentWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LiteralWidget
extends WikiWidget {
    public static final String REGEXP = "!lit\\?\\d+\\?";
    public static final Pattern pattern = Pattern.compile("!lit\\?(\\d+)\\?", 40);
    private int literalNumber;

    public LiteralWidget(ParentWidget parent, String text) {
        super(parent);
        Matcher match = pattern.matcher(text);
        if (match.find()) {
            this.literalNumber = Integer.parseInt(match.group(1));
        }
    }

    public String render() throws Exception {
        return this.parent.getLiteral(this.literalNumber);
    }

    public String asWikiText() throws Exception {
        return "!-" + this.parent.getLiteral(this.literalNumber) + "-!";
    }
}

