/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.wikitext.WidgetBuilder;
import fitnesse.wikitext.widgets.ParentWidget;
import fitnesse.wikitext.widgets.TableRowWidget;
import fitnesse.wikitext.widgets.TableWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlainTextTableWidget
extends ParentWidget
implements TableWidget {
    public static final String REGEXP = "^!\\[(?:\\p{Punct}?(?: [^\n]*)?)?\n.+?\n\\]!\n";
    private static final Pattern pattern = Pattern.compile("^!\\[(?:(\\p{Punct}?)(?: ([^\n]*))?)?\n(.+?)\n\\]!", 32);
    private String delimiter;
    private String hiddenFirstRow;
    private String body;
    private int columnCount;

    public PlainTextTableWidget(ParentWidget parent, String text) throws Exception {
        super(parent);
        Matcher match = pattern.matcher(text);
        if (match.find()) {
            this.delimiter = match.group(1);
            this.hiddenFirstRow = match.group(2);
            this.body = match.group(3);
            if (this.hiddenFirstRow != null && this.hiddenFirstRow.length() > 0) {
                this.addHiddenRow(this.hiddenFirstRow);
            }
            for (String row : this.body.split("\n")) {
                this.addRow(row);
            }
        }
    }

    private TableRowWidget addRow(String row) throws Exception {
        return new TableRowWidget(this, this.parseToCells(row));
    }

    private String[] parseToCells(String row) {
        if (this.delimiter.length() == 0) {
            return new String[]{row};
        }
        return row.split(this.delimiter);
    }

    private void addHiddenRow(String rowString) throws Exception {
        TableRowWidget row = this.addRow(rowString);
        row.setCommentRow(true);
    }

    public String render() throws Exception {
        StringBuffer html = new StringBuffer("<table class=\"plain_text_table\">");
        html.append(this.childHtml()).append("</table>");
        return html.toString();
    }

    public String asWikiText() throws Exception {
        return "![" + this.childWikiText() + "]!";
    }

    public WidgetBuilder getBuilder() {
        return WidgetBuilder.literalVariableEvaluatorWidgetBuilder;
    }

    public String getDelimiter() {
        return this.delimiter == null ? "" : this.delimiter;
    }

    public String getHiddenFirstRow() {
        return this.hiddenFirstRow == null ? "" : this.hiddenFirstRow;
    }

    public String getBody() {
        return this.body == null ? "" : this.body;
    }

    public int getColumns() {
        return this.columnCount;
    }

    public void maximizeColumns(int columns) {
        this.columnCount = Math.max(this.columnCount, columns);
    }
}

