/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.wikitext.Utils;
import fitnesse.wikitext.WikiWidget;
import fitnesse.wikitext.widgets.ParentWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PreProcessorLiteralWidget
extends WikiWidget {
    public static final String REGEXP = "![<-].*?[>-]!";
    public static final Pattern pattern = Pattern.compile("![<-](.*?)[>-]!", 40);
    private String literalToRender = null;
    private int literalNumber;
    private boolean escapedLiteral = false;
    private String literalText;

    public PreProcessorLiteralWidget(ParentWidget parent, String text) {
        super(parent);
        Matcher match = pattern.matcher(text);
        if (match.find()) {
            if (match.group(0).charAt(1) == '<') {
                this.escapedLiteral = true;
            }
            this.literalText = match.group(1);
            this.literalToRender = this.escapedLiteral ? Utils.escapeHTML(this.literalText) : this.literalText;
            this.literalNumber = this.parent.defineLiteral(this.literalToRender);
        }
    }

    public String render() throws Exception {
        return "!lit?" + this.literalNumber + "?";
    }

    public String asWikiText() throws Exception {
        if (this.escapedLiteral) {
            return "!<" + this.literalText + ">!";
        }
        return "!-" + this.literalToRender + "-!";
    }
}

