/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.wikitext.WidgetBuilder;
import fitnesse.wikitext.widgets.ParentWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PreformattedWidget
extends ParentWidget {
    public static final String REGEXP = "\\{\\{\\{.+?\\}\\}\\}";
    private static final Pattern pattern = Pattern.compile("\\{{3}(.+?)\\}{3}", 32);

    public PreformattedWidget(ParentWidget parent, String text) throws Exception {
        super(parent);
        Matcher match = pattern.matcher(text);
        if (match.find()) {
            this.addChildWidgets(match.group(1));
        }
    }

    public String render() throws Exception {
        StringBuffer html = new StringBuffer("<pre>");
        html.append(this.childHtml()).append("</pre>");
        return html.toString();
    }

    public String asWikiText() throws Exception {
        return "{{{" + this.childWikiText() + "}}}";
    }

    public WidgetBuilder getBuilder() {
        return WidgetBuilder.literalVariableEvaluatorWidgetBuilder;
    }
}

