/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.wikitext.WikiWidget;
import fitnesse.wikitext.widgets.ParentWidget;
import fitnesse.wikitext.widgets.TableCellWidget;
import fitnesse.wikitext.widgets.TableRowWidget;
import fitnesse.wikitext.widgets.TableWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StandardTableWidget
extends ParentWidget
implements TableWidget {
    public static final String REGEXP = "^#?!?(?:\\|[^\n]*?\\|\n)+";
    private static final Pattern pattern = Pattern.compile("(#?)(!?)(\\|[^\n]*?)\\|\n");
    public boolean isLiteralTable;
    public boolean isCommentTable;
    private int columns = 0;

    public int getColumns() {
        return this.columns;
    }

    public String asWikiText() throws Exception {
        StringBuffer wikiText = new StringBuffer();
        if (this.isCommentTable) {
            wikiText.append("#");
        }
        if (this.isLiteralTable) {
            wikiText.append("!");
        }
        this.appendTableWikiText(wikiText);
        return wikiText.toString();
    }

    private void appendTableWikiText(StringBuffer wikiText) throws Exception {
        for (WikiWidget rowWidget : this.getChildren()) {
            TableRowWidget row = (TableRowWidget)rowWidget;
            wikiText.append("|");
            this.appendRowWikiText(wikiText, row);
            wikiText.append("\n");
        }
    }

    private void appendRowWikiText(StringBuffer wikiText, TableRowWidget row) throws Exception {
        for (WikiWidget cellWidget : row.getChildren()) {
            TableCellWidget cell = (TableCellWidget)cellWidget;
            this.appendCellWikiText(wikiText, cell);
            wikiText.append("|");
        }
    }

    private void appendCellWikiText(StringBuffer wikiText, TableCellWidget cell) throws Exception {
        for (WikiWidget contentWidget : cell.getChildren()) {
            wikiText.append(contentWidget.asWikiText());
        }
    }

    public StandardTableWidget(ParentWidget parent, String text) throws Exception {
        super(parent);
        Matcher match = pattern.matcher(text);
        if (match.find()) {
            this.isCommentTable = "#".equals(match.group(1));
            this.isLiteralTable = "!".equals(match.group(2));
            this.addRows(text, this.isCommentTable);
            this.getMaxNumberOfColumns();
        }
    }

    private void getMaxNumberOfColumns() {
        for (WikiWidget widget : this.children) {
            TableRowWidget rowWidget = (TableRowWidget)widget;
            this.columns = Math.max(this.columns, rowWidget.getColumns());
        }
    }

    public String render() throws Exception {
        StringBuffer html = new StringBuffer("<table border=\"1\" cellspacing=\"0\">\n");
        html.append(this.childHtml()).append("</table>\n");
        return html.toString();
    }

    private void addRows(String text, boolean markAsCommentRow) throws Exception {
        Matcher match = pattern.matcher(text);
        if (match.find()) {
            this.addRow(match.group(3), markAsCommentRow);
            this.addRows(text.substring(match.end()), false);
        }
    }

    private void addRow(String wikiTextRow, boolean markAsCommentRow) throws Exception {
        TableRowWidget rowWidget = new TableRowWidget(this, wikiTextRow, this.isLiteralTable);
        if (markAsCommentRow) {
            rowWidget.markAsCommentRow();
        }
    }

    public void setLiteralTable(boolean isLiteralTable) {
        this.isLiteralTable = isLiteralTable;
    }
}

