/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.html.HtmlElement;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.RawHtml;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.ProxyPage;
import fitnesse.wiki.VirtualCouplingExtension;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.WikiPageProperty;
import fitnesse.wikitext.WikiWidget;
import fitnesse.wikitext.widgets.ParentWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TOCWidget
extends WikiWidget {
    public static final String REGEXP = "(?:^!contents([ \t]+-R[0-9]*)?([ \t]+-[fhgp])*?[ \\t]*$)";
    public static final String REGRACE_TOC = "REGRACE_TOC";
    public static final String MORE_SUFFIX_TOC = "MORE_SUFFIX_TOC";
    public static final String FILTER_TOC = "FILTER_TOC";
    public static final String PROPERTY_TOC = "PROPERTY_TOC";
    public static final String PROPERTY_CHARACTERS = "PROPERTY_CHARACTERS";
    public static final String HELP_TOC = "HELP_TOC";
    public static final String HELP_PREFIX_TOC = "HELP_PREFIX_TOC";
    public static final String MORE_SUFFIX_DEFAULT = " ...";
    public static final String PROP_CHAR_DEFAULT = "*+@>-";
    public static final String HELP_PREFIX_DEFAULT = ": ";
    public String moreSuffix = " ...";
    public String propertyCharacters = "*+@>-";
    public String helpTextPrefix = ": ";
    private boolean recursive;
    private boolean isGraceful;
    private boolean isVarGraceful;
    private boolean isPropertied;
    private boolean isVarPropertied;
    private boolean isFiltered;
    private boolean isVarFiltered;
    private boolean isHelpShown;
    private boolean isVarHelpShown;
    private int depthLimit;

    public TOCWidget(ParentWidget parent, String text) {
        super(parent);
        this.setRecursive(text);
        this.setGraceful(text);
        this.setPropertied(text);
        this.setFiltered(text);
        this.setHelpShown(text);
    }

    private void setRecursive(String text) {
        boolean bl = this.recursive = text.indexOf("-R") > -1;
        if (this.recursive) {
            Pattern pat = Pattern.compile("-R([0-9])");
            Matcher mat = pat.matcher(text);
            this.depthLimit = mat.find() ? Integer.valueOf(mat.group(1)) : 0;
        }
    }

    private void setGraceful(String text) {
        this.isGraceful = text.indexOf("-g") > -1;
    }

    private void setPropertied(String text) {
        this.isPropertied = text.indexOf("-p") > -1;
    }

    private void setFiltered(String text) {
        this.isFiltered = text.indexOf("-f") > -1;
    }

    private void setHelpShown(String text) {
        this.isHelpShown = text.indexOf("-h") > -1;
    }

    @Override
    public boolean isRegracing() {
        return this.isVarGraceful || this.isGraceful;
    }

    public boolean isPropertyAppended() {
        return this.isVarPropertied || this.isPropertied;
    }

    public boolean isFiltersAppended() {
        return this.isVarFiltered || this.isFiltered;
    }

    public boolean isHelpAppended() {
        return this.isVarHelpShown || this.isHelpShown;
    }

    @Override
    public String render() throws Exception {
        WikiPage page = this.getWikiPage();
        this.initVarFlags(page);
        this.initMoreSuffix(page);
        this.initPropertyCharacters(page);
        this.initHelpTextPrefix(page);
        return this.buildContentsDiv(page, 1).html();
    }

    private void initVarFlags(WikiPage page) throws Exception {
        this.isVarGraceful = "true".equals(this.parent.getVariable(REGRACE_TOC));
        this.isVarPropertied = "true".equals(this.parent.getVariable(PROPERTY_TOC));
        this.isVarFiltered = "true".equals(this.parent.getVariable(FILTER_TOC));
        this.isVarHelpShown = "true".equals(this.parent.getVariable(HELP_TOC));
    }

    private void initMoreSuffix(WikiPage page) throws Exception {
        String moreSuffixEnv = this.parent.getVariable(MORE_SUFFIX_TOC);
        this.moreSuffix = moreSuffixEnv != null ? moreSuffixEnv : MORE_SUFFIX_DEFAULT;
    }

    private void initPropertyCharacters(WikiPage page) {
        StringBuffer propChars = new StringBuffer();
        try {
            String propsFromEnv = this.parent.getVariable(PROPERTY_CHARACTERS);
            if (propsFromEnv != null) {
                propChars.append(propsFromEnv);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int newLength = propChars.length();
        if (newLength < PROP_CHAR_DEFAULT.length()) {
            propChars.append(PROP_CHAR_DEFAULT.substring(newLength));
        }
        this.propertyCharacters = propChars.toString();
    }

    private void initHelpTextPrefix(WikiPage page) throws Exception {
        String helpPrefixEnv = this.parent.getVariable(HELP_PREFIX_TOC);
        this.helpTextPrefix = helpPrefixEnv != null ? helpPrefixEnv : HELP_PREFIX_DEFAULT;
    }

    private HtmlTag buildContentsDiv(WikiPage wikiPage, int currentDepth) throws Exception {
        HtmlTag div = this.makeDivTag(currentDepth);
        div.add(this.buildList(wikiPage, currentDepth));
        return div;
    }

    private HtmlTag buildList(WikiPage wikiPage, int currentDepth) throws Exception {
        HtmlTag contentsDiv = null;
        if (currentDepth == 1) {
            contentsDiv = HtmlUtil.makeDivTag("contents");
            contentsDiv.add(HtmlUtil.makeBold("Contents:"));
        } else {
            contentsDiv = HtmlUtil.makeDivTag("nested-contents");
        }
        HtmlTag list = new HtmlTag("ul");
        Iterator<WikiPage> iterator = this.buildListOfChildPages(wikiPage).iterator();
        while (iterator.hasNext()) {
            list.add(this.buildListItem(iterator.next(), currentDepth));
        }
        contentsDiv.add(list);
        return contentsDiv;
    }

    private boolean isDepthExceeded(int currentDepth) {
        return this.depthLimit > 0 && currentDepth > this.depthLimit;
    }

    private HtmlTag buildListItem(WikiPage wikiPage, int currentDepth) throws Exception {
        HtmlTag listItem = new HtmlTag("li");
        HtmlTag link = HtmlUtil.makeLink(this.getHref(wikiPage), this.getLinkText(wikiPage));
        boolean willRecurse = this.isRecursive() && this.buildListOfChildPages(wikiPage).size() > 0;
        boolean depthExceeded = this.isDepthExceeded(currentDepth + 1);
        if (willRecurse && depthExceeded) {
            link.add(this.moreSuffix);
        }
        this.addHelpText(link, wikiPage);
        listItem.add(link);
        if (willRecurse && !depthExceeded) {
            listItem.add(this.buildContentsDiv(wikiPage, currentDepth + 1));
        }
        return listItem;
    }

    private String getHref(WikiPage wikiPage) throws Exception {
        String href = null;
        WikiPagePath wikiPagePath = wikiPage.getPageCrawler().getFullPath(wikiPage);
        href = PathParser.render(wikiPagePath);
        return href;
    }

    private void addHelpText(HtmlTag link, WikiPage wikiPage) throws Exception {
        String helpText = wikiPage.getHelpText();
        if (helpText != null) {
            if (this.isHelpAppended()) {
                link.tail = HtmlUtil.makeSpanTag("pageHelp", this.helpTextPrefix + helpText).htmlInline();
            } else {
                link.addAttribute("title", helpText);
            }
        }
    }

    private HtmlElement getLinkText(WikiPage wikiPage) throws Exception {
        String name = this.regrace(wikiPage.getName());
        String props = this.getProperties(wikiPage);
        String filters = this.getFilters(wikiPage);
        if (wikiPage instanceof ProxyPage) {
            return new HtmlTag("i", name + props + filters);
        }
        return new RawHtml(name + props + filters);
    }

    private String getProperties(WikiPage wikiPage) throws Exception {
        StringBuffer propText = new StringBuffer();
        if (this.isPropertyAppended()) {
            PageData data = wikiPage.getData();
            WikiPageProperties props = data.getProperties();
            if (props.has("Suite")) {
                propText.append(this.propertyCharacters.charAt(0));
            }
            if (props.has("Test")) {
                propText.append(this.propertyCharacters.charAt(1));
            }
            if (props.has("WikiImport")) {
                propText.append(this.propertyCharacters.charAt(2));
            }
            if (this.isSymbolic(wikiPage)) {
                propText.append(this.propertyCharacters.charAt(3));
            }
            if (props.has("Prune")) {
                propText.append(this.propertyCharacters.charAt(4));
            }
        }
        return propText.length() > 0 ? " " + propText.toString() : "";
    }

    private boolean isSymbolic(WikiPage page) throws Exception {
        boolean isSym = false;
        WikiPageProperties props = page.getParent().getData().getProperties();
        if (props.has("SymbolicLinks")) {
            WikiPageProperty syms = props.getProperty("SymbolicLinks");
            isSym = syms == null ? false : syms.has(page.getName());
        }
        return isSym;
    }

    private String getFilters(WikiPage wikiPage) throws Exception {
        String filters = "";
        if (this.isFiltersAppended()) {
            String filterText;
            PageData data = wikiPage.getData();
            WikiPageProperties props = data.getProperties();
            filterText = props.has("Suites") ? (filterText = props.get("Suites")) : "";
            filters = filterText != null ? filterText.trim() : "";
        }
        return filters.length() > 0 ? " (" + filters + ")" : "";
    }

    private List<WikiPage> buildListOfChildPages(WikiPage wikiPage) throws Exception {
        ArrayList<WikiPage> childPageList = new ArrayList<WikiPage>(wikiPage.getChildren());
        if (wikiPage.hasExtension("VirtualCoupling")) {
            VirtualCouplingExtension extension = (VirtualCouplingExtension)wikiPage.getExtension("VirtualCoupling");
            WikiPage virtualCoupling = extension.getVirtualCoupling();
            childPageList.addAll(virtualCoupling.getChildren());
        }
        this.sortPageList(childPageList);
        return childPageList;
    }

    private void sortPageList(List<WikiPage> childPageList) {
        Collections.sort(childPageList);
    }

    private HtmlTag makeDivTag(int currentDepth) {
        return HtmlUtil.makeDivTag("toc" + currentDepth);
    }

    public boolean isRecursive() {
        return this.recursive;
    }
}

