/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.html.HtmlTag;
import fitnesse.wikitext.WidgetBuilder;
import fitnesse.wikitext.widgets.ParentWidget;
import fitnesse.wikitext.widgets.TableRowWidget;

public class TableCellWidget
extends ParentWidget {
    private TableRowWidget parentRow = null;
    private boolean isLiteral;

    public TableCellWidget(TableRowWidget parentRow, String text, boolean isLiteral) throws Exception {
        super(parentRow);
        this.parentRow = parentRow;
        this.isLiteral = isLiteral;
        this.addChildWidgets(this.groomText(text));
    }

    private String groomText(String text) {
        text = text.replaceAll("\\\\\\r", "\r").replaceAll("\\\\\\n", "\n");
        return text.trim();
    }

    public String render() throws Exception {
        return this.makeCellTag();
    }

    private String makeCellTag() throws Exception {
        HtmlTag cellTag = new HtmlTag("td");
        if (this.computeColSpan().length() > 0) {
            cellTag.addAttribute("colspan", this.computeColSpan());
        }
        if (this.childHtml().equals("")) {
            cellTag.add("&nbsp;");
        } else {
            cellTag.add(this.childHtml());
        }
        return cellTag.html();
    }

    private String computeColSpan() {
        int currentColumn = this.parentRow.children.indexOf(this) + 1;
        int maxTableColumn = this.parentRow.getParentTable().getColumns();
        int maxColumnThisRow = this.parentRow.numberOfChildren();
        String colspan = "";
        if (currentColumn == maxColumnThisRow && currentColumn != maxTableColumn) {
            colspan = String.valueOf(maxTableColumn - currentColumn + 1);
        }
        return colspan;
    }

    public WidgetBuilder getBuilder() {
        if (this.isLiteral) {
            return WidgetBuilder.literalVariableEvaluatorWidgetBuilder;
        }
        return this.parent.getBuilder();
    }
}

