/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.wikitext.widgets.ParentWidget;
import fitnesse.wikitext.widgets.PlainTextTableWidget;
import fitnesse.wikitext.widgets.StandardTableWidget;
import fitnesse.wikitext.widgets.TableCellWidget;
import fitnesse.wikitext.widgets.TableWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TableRowWidget
extends ParentWidget {
    private static final Pattern pattern = Pattern.compile("\\|([^\\|\n\r]*)");
    private TableWidget parentTable;
    private boolean isLiteral;
    private boolean isCommentRow = false;

    public TableRowWidget(StandardTableWidget parentTable, String text, boolean isLiteral) throws Exception {
        super(parentTable);
        this.parentTable = parentTable;
        this.isLiteral = isLiteral;
        this.addCells(text);
    }

    public TableRowWidget(PlainTextTableWidget tableWidget, String[] cells) throws Exception {
        super(tableWidget);
        this.parentTable = tableWidget;
        tableWidget.maximizeColumns(cells.length);
        for (String cell : cells) {
            new TableCellWidget(this, cell, true);
        }
    }

    public int getColumns() {
        return this.numberOfChildren();
    }

    public TableWidget getParentTable() {
        return this.parentTable;
    }

    public String render() throws Exception {
        StringBuffer html = new StringBuffer(this.getRowStartTag());
        html.append(this.childHtml()).append("</tr>\n");
        return html.toString();
    }

    private String getRowStartTag() {
        if (this.isCommentRow) {
            return "<tr class=\"hidden\">";
        }
        return "<tr>";
    }

    public void addCells(String text) throws Exception {
        Matcher match = pattern.matcher(text);
        if (match.find()) {
            new TableCellWidget(this, match.group(1), this.isLiteral);
            this.addCells(text.substring(match.end()));
        }
    }

    public void markAsCommentRow() {
        this.isCommentRow = true;
    }

    public void setCommentRow(boolean b) {
        this.isCommentRow = b;
    }
}

