/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.FitNesseContext;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PagePointer;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.WidgetBuilder;
import fitnesse.wikitext.widgets.ParentWidget;
import fitnesse.wikitext.widgets.VariableWidget;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetRoot
extends ParentWidget {
    private Map<String, String> variables = new HashMap<String, String>();
    private WidgetBuilder builder;
    private WikiPage page;
    private boolean doEscaping = true;
    private List<String> literals = new LinkedList<String>();
    private boolean isGatheringInfo = false;

    public WidgetRoot(WikiPage aliasPage, ParentWidget imposterWidget) throws Exception {
        super(imposterWidget, true);
        WidgetRoot aliasRoot = imposterWidget.getRoot();
        this.builder = imposterWidget.getBuilder();
        this.variables = aliasRoot.variables;
        this.doEscaping = aliasRoot.doEscaping;
        this.literals = aliasRoot.literals;
        this.isGatheringInfo = aliasRoot.isGatheringInfo;
        this.page = aliasPage;
    }

    @Override
    public WidgetRoot getRoot() {
        return this;
    }

    public boolean isGatheringInfo() {
        return this.isGatheringInfo;
    }

    public WidgetRoot(WikiPage page) throws Exception {
        this("", page, WidgetBuilder.htmlWidgetBuilder);
    }

    public WidgetRoot(String value, WikiPage page) throws Exception {
        this(value, page, WidgetBuilder.htmlWidgetBuilder);
    }

    public WidgetRoot(String value, WikiPage page, WidgetBuilder builder) throws Exception {
        this(value, page, builder, false);
    }

    public WidgetRoot(String value, WikiPage page, WidgetBuilder builder, boolean isGathering) throws Exception {
        super(null);
        this.page = page;
        this.builder = builder;
        this.isGatheringInfo = isGathering;
        if (value != null) {
            this.buildWidgets(value);
        }
    }

    public WidgetRoot(PagePointer pagePointer) throws Exception {
        this("", pagePointer, WidgetBuilder.htmlWidgetBuilder);
    }

    public WidgetRoot(String value, PagePointer pagePointer) throws Exception {
        this(value, pagePointer, WidgetBuilder.htmlWidgetBuilder);
    }

    public WidgetRoot(String value, PagePointer pagePointer, WidgetBuilder builder) throws Exception {
        super(null);
        this.page = pagePointer.getPage();
        this.builder = builder;
        if (value != null) {
            this.buildWidgets(value);
        }
    }

    @Override
    public WidgetBuilder getBuilder() {
        return this.builder;
    }

    protected void buildWidgets(String value) throws Exception {
        String strippedText = this.stripTrailingWhiteSpaceInLines(value);
        String nonLiteralContent = this.processLiterals(strippedText);
        this.addChildWidgets(nonLiteralContent);
    }

    @Override
    public String render() throws Exception {
        return this.childHtml();
    }

    @Override
    public String getVariable(String key) throws Exception {
        String value = this.variables.get(key);
        if (key.equals("PAGE_NAME")) {
            value = this.page.getName();
        } else if (key.equals("PAGE_PATH")) {
            value = this.getWikiPage().getPageCrawler().getFullPath(this.page).parentPath().toString();
        } else if (key.equals("FITNESSE_PORT")) {
            value = Integer.toString(FitNesseContext.globalContext.port);
        } else if (key.equals("FITNESSE_ROOTPATH")) {
            value = FitNesseContext.globalContext.rootPath;
        }
        WikiPage page = this.getWikiPage();
        while (value == null && !page.getPageCrawler().isRoot(page)) {
            page = page.getParentForVariables();
            PageData pageData = page.getData();
            pageData.setLiterals(this.getLiterals());
            value = pageData.getVariable(key);
        }
        if (value == null) {
            value = System.getenv(key);
        }
        if (value == null) {
            value = System.getProperty(key);
        }
        if (value != null) {
            while (this.includesVariable(value)) {
                value = this.replaceVariable(value);
            }
            this.variables.put(key, value);
        }
        return value;
    }

    public boolean includesVariable(String string) {
        Matcher matcher = VariableWidget.pattern.matcher(string);
        return matcher.find();
    }

    public String replaceVariable(String string) throws Exception {
        Matcher matcher = VariableWidget.pattern.matcher(string);
        if (matcher.find()) {
            String name = matcher.group(1);
            return string.substring(0, matcher.start()) + this.getVariable(name) + string.substring(matcher.end());
        }
        return string;
    }

    @Override
    public void addVariable(String key, String value) {
        this.variables.put(key, value);
    }

    @Override
    public int defineLiteral(String literal) {
        int literalNumber = this.literals.size();
        this.literals.add(literal);
        return literalNumber;
    }

    @Override
    public String getLiteral(int literalNumber) {
        if (literalNumber >= this.literals.size()) {
            return "literal(" + literalNumber + ") not found.";
        }
        return this.literals.get(literalNumber);
    }

    @Override
    public WikiPage getWikiPage() {
        return this.page;
    }

    public void setEscaping(boolean value) {
        this.doEscaping = value;
    }

    @Override
    public boolean doEscaping() {
        return this.doEscaping;
    }

    public List<String> getLiterals() {
        return this.literals;
    }

    public void setLiterals(List<String> literals) {
        this.literals = literals;
    }

    @Override
    public String asWikiText() throws Exception {
        return this.childWikiText();
    }
}

