/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.components.PageReferencer;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wikitext.Utils;
import fitnesse.wikitext.WidgetVisitor;
import fitnesse.wikitext.widgets.ParentWidget;
import fitnesse.wikitext.widgets.TextWidget;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiWordWidget
extends TextWidget
implements PageReferencer {
    public static final String SINGLE_WIKIWORD_REGEXP = "\\b[A-Z](?:[a-z0-9]+[A-Z][a-z0-9]*)+";
    public static final String REGEXP = "(?:[<>^.])?(?:\\b[A-Z](?:[a-z0-9]+[A-Z][a-z0-9]*)+[.]?)+\\b";
    public static final String REGRACE_LINK = "REGRACE_LINK";
    public WikiPage parentPage;

    public static String makeWikiWord(String input) {
        if (WikiWordWidget.isWikiWord(input)) {
            return input;
        }
        String base = input;
        while (base.length() < 3) {
            base = base + "a";
        }
        return base.substring(0, 1).toUpperCase() + base.substring(1, base.length() - 1).toLowerCase() + base.substring(base.length() - 1).toUpperCase();
    }

    public WikiWordWidget(ParentWidget parent, String text) throws Exception {
        super(parent, text);
        WikiPage wikiPage = this.getWikiPage();
        this.parentPage = wikiPage.getParent();
    }

    @Override
    public String render() throws Exception {
        WikiPagePath pathOfWikiWord = PathParser.parse(this.getWikiWord());
        WikiPagePath fullPathOfWikiWord = this.parentPage.getPageCrawler().getFullPathOfChild(this.parentPage, pathOfWikiWord);
        String qualifiedName = PathParser.render(fullPathOfWikiWord);
        WikiPage targetPage = this.parentPage.getPageCrawler().getPage(this.parentPage, PathParser.parse(this.getWikiWord()));
        if (targetPage != null) {
            return this.makeLinkToExistingWikiPage(qualifiedName, targetPage);
        }
        return this.makeLinkToNonExistentWikiPage(qualifiedName);
    }

    private String makeLinkToNonExistentWikiPage(String qualifiedName) {
        StringBuffer html = new StringBuffer();
        html.append(Utils.escapeHTML(this.getText()));
        html.append("<a title=\"create page\" href=\"").append(qualifiedName);
        html.append("?edit&nonExistent=true");
        html.append("\">[?]</a>");
        return html.toString();
    }

    @Override
    public boolean isRegracing() {
        Boolean isDoingIt = false;
        try {
            isDoingIt = "true".equals(this.parent.getVariable(REGRACE_LINK));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isDoingIt;
    }

    private String makeLinkToExistingWikiPage(String qualifiedName, WikiPage wikiPage) throws Exception {
        HtmlTag link = HtmlUtil.makeLink(qualifiedName, Utils.escapeHTML(this.regrace(this.getText())));
        this.addHelpText(link, wikiPage);
        return link.htmlInline();
    }

    private void addHelpText(HtmlTag link, WikiPage wikiPage) throws Exception {
        String helpText = wikiPage.getHelpText();
        if (helpText != null) {
            link.addAttribute("title", helpText);
        }
    }

    public void renamePageIfReferenced(WikiPage pageToRename, String newName) throws Exception {
        String fullPathToReferent = this.getQualifiedWikiWord();
        WikiPagePath pathToPageBeingRenamed = pageToRename.getPageCrawler().getFullPath(pageToRename);
        pathToPageBeingRenamed.makeAbsolute();
        String absolutePathToPageBeingRenamed = PathParser.render(pathToPageBeingRenamed);
        if (WikiWordWidget.refersTo(fullPathToReferent, absolutePathToPageBeingRenamed)) {
            int oldNameLength = absolutePathToPageBeingRenamed.length();
            String renamedPath = "." + this.rename(absolutePathToPageBeingRenamed.substring(1), newName);
            String pathAfterRenamedPage = fullPathToReferent.substring(oldNameLength);
            String fullRenamedPathToReferent = renamedPath + pathAfterRenamedPage;
            String renamedReference = this.makeRenamedRelativeReference(PathParser.parse(fullRenamedPathToReferent));
            this.setText(renamedReference);
        }
    }

    public void renameMovedPageIfReferenced(WikiPage pageToBeMoved, String newParentName) throws Exception {
        WikiPagePath pathOfPageToBeMoved = pageToBeMoved.getPageCrawler().getFullPath(pageToBeMoved);
        pathOfPageToBeMoved.makeAbsolute();
        String QualifiedNameOfPageToBeMoved = PathParser.render(pathOfPageToBeMoved);
        String reference = this.getQualifiedWikiWord();
        if (WikiWordWidget.refersTo(reference, QualifiedNameOfPageToBeMoved)) {
            String referenceTail = reference.substring(QualifiedNameOfPageToBeMoved.length());
            String childPortionOfReference = pageToBeMoved.getName();
            if (referenceTail.length() > 0) {
                childPortionOfReference = childPortionOfReference + referenceTail;
            }
            String newQualifiedName = "".equals(newParentName) ? "." + childPortionOfReference : "." + newParentName + "." + childPortionOfReference;
            this.setText(newQualifiedName);
        }
    }

    public String makeRenamedRelativeReference(WikiPagePath renamedPathToReferent) throws Exception {
        String rawReference = this.getText();
        WikiPagePath parentPath = this.parentPage.getPageCrawler().getFullPath(this.parentPage);
        parentPath.makeAbsolute();
        if (rawReference.startsWith(".")) {
            return PathParser.render(renamedPathToReferent);
        }
        if (rawReference.startsWith("<")) {
            return WikiWordWidget.buildBackwardSearchReference(parentPath, renamedPathToReferent);
        }
        boolean parentPathNotRenamed = renamedPathToReferent.startsWith(parentPath);
        if (parentPathNotRenamed) {
            WikiPagePath relativePath = renamedPathToReferent.subtractFromFront(parentPath);
            if (rawReference.startsWith("^") || rawReference.startsWith(">")) {
                return ">" + PathParser.render(relativePath.getRest());
            }
            return PathParser.render(relativePath);
        }
        return rawReference;
    }

    static String buildBackwardSearchReference(WikiPagePath parentPath, WikiPagePath renamedPathToReferent) {
        int branchPoint = WikiWordWidget.findBranchPoint(parentPath.getNames(), renamedPathToReferent.getNames());
        List<String> referentPath = renamedPathToReferent.getNames();
        List<String> referentPathAfterBranchPoint = referentPath.subList(branchPoint, referentPath.size());
        String newRawReference = "<" + StringUtil.join(referentPathAfterBranchPoint, ".");
        return newRawReference;
    }

    private static int findBranchPoint(List<String> list1, List<String> list2) {
        int i;
        for (i = 0; i < list1.size() && list1.get(i).equals(list2.get(i)); ++i) {
        }
        return Math.max(0, i - 1);
    }

    static boolean refersTo(String qualifiedReference, String qualifiedTarget) {
        if (qualifiedReference.equals(qualifiedTarget)) {
            return true;
        }
        return qualifiedReference.startsWith(qualifiedTarget + ".");
    }

    private String getQualifiedWikiWord() throws Exception {
        String pathName = this.expandPrefix(this.getText());
        WikiPagePath expandedPath = PathParser.parse(pathName);
        if (expandedPath == null) {
            return this.getText();
        }
        WikiPagePath fullPath = this.parentPage.getPageCrawler().getFullPathOfChild(this.parentPage, expandedPath);
        return "." + PathParser.render(fullPath);
    }

    private String rename(String oldQualifiedName, String newPageName) {
        String newQualifiedName = oldQualifiedName;
        int lastDotIndex = oldQualifiedName.lastIndexOf(".");
        newQualifiedName = lastDotIndex < 1 ? newPageName : oldQualifiedName.substring(0, lastDotIndex + 1) + newPageName;
        return newQualifiedName;
    }

    String getWikiWord() throws Exception {
        return this.expandPrefix(this.getText());
    }

    public static boolean isWikiWord(String word) {
        return Pattern.matches(REGEXP, word);
    }

    protected String expandPrefix(String theWord) throws Exception {
        WikiPage wikiPage = this.getWikiPage();
        return WikiWordWidget.expandPrefix(wikiPage, theWord);
    }

    public static String expandPrefix(WikiPage wikiPage, String theWord) throws Exception {
        PageCrawler crawler = wikiPage.getPageCrawler();
        if (theWord.charAt(0) == '^' || theWord.charAt(0) == '>') {
            String prefix = wikiPage.getName();
            return String.format("%s.%s", prefix, theWord.substring(1));
        }
        if (theWord.charAt(0) == '<') {
            String undecoratedPath = theWord.substring(1);
            String[] pathElements = undecoratedPath.split("\\.");
            String target = pathElements[0];
            WikiPage current = wikiPage.getParent();
            while (!crawler.isRoot(current)) {
                if (current.getName().equals(target)) {
                    pathElements[0] = PathParser.render(crawler.getFullPath(current));
                    return "." + StringUtil.join(Arrays.asList(pathElements), ".");
                }
                current = current.getParent();
            }
            return "." + undecoratedPath;
        }
        return theWord;
    }

    @Override
    public WikiPage getReferencedPage() throws Exception {
        String theWord = this.getWikiWord();
        return this.parentPage.getPageCrawler().getPage(this.parentPage, PathParser.parse(theWord));
    }

    @Override
    public void acceptVisitor(WidgetVisitor visitor) throws Exception {
        visitor.visit(this);
    }

    public static boolean isSingleWikiWord(String s) {
        return Pattern.matches(SINGLE_WIKIWORD_REGEXP, s);
    }
}

