/*
 * Decompiled with CFR 0.152.
 */
package fitnesseMain.ant;

import fitnesse.FitNesse;
import fitnesse.FitNesseContext;
import fitnesseMain.FitNesseMain;
import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class TestRunnerTask
extends Task {
    private String wikiDirectoryRootPath;
    private int fitnessePort = 8082;
    private String suitePage;
    private String resultsDir = ".";
    private String resultsXMLPage;
    private boolean verbose = true;
    private boolean failOnError = true;
    private String testRunnerClass = "fitnesse.runner.TestRunner";
    private Path classpath;
    private String resultProperty;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        this.startFitNesse();
        try {
            this.executeTests();
        }
        catch (Exception e) {
            if (this.failOnError) {
                throw new BuildException("Got an unexpected error trying to run the fitnesse tests : " + e.getMessage(), (Throwable)e);
            }
            e.printStackTrace();
        }
        finally {
            this.stopFitNesse();
        }
    }

    private void executeTests() {
        int exitCode = this.executeRunnerClassAsForked();
        if (exitCode != 0) {
            this.log("Finished executing FitNesse tests: " + exitCode + " failures/exceptions");
            if (this.failOnError) {
                throw new BuildException(exitCode + " FitNesse test failures/exceptions");
            }
            this.getProject().setNewProperty(this.resultProperty, String.valueOf(exitCode));
        } else {
            this.log("Fitnesse Tests executed successfully");
        }
    }

    private void stopFitNesse() {
        FitNesseContext context = new FitNesseContext();
        context.port = this.fitnessePort;
        try {
            new FitNesse(context).stop();
        }
        catch (Exception e) {
            throw new BuildException("Failed to stop FitNesse. Error Msg: " + e.getMessage(), (Throwable)e);
        }
    }

    private void startFitNesse() {
        try {
            FitNesseMain.main(new String[]{"-p", String.valueOf(this.fitnessePort), "-d", this.wikiDirectoryRootPath, "-e", "0", "-o"});
        }
        catch (Exception e) {
            throw new BuildException("Failed to start FitNesse. Error Msg: " + e.getMessage(), (Throwable)e);
        }
        this.log("Sucessfully Started Fitnesse on port " + this.fitnessePort);
    }

    private int executeRunnerClassAsForked() throws BuildException {
        int retVal;
        CommandlineJava cmd = this.initializeJavaCommand();
        Execute execute = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1));
        execute.setCommandline(cmd.getCommandline());
        execute.setNewenvironment(false);
        execute.setAntRun(this.getProject());
        this.log(cmd.describeCommand(), 3);
        try {
            retVal = execute.execute();
        }
        catch (IOException e) {
            throw new BuildException("Process fork failed.", (Throwable)e, this.getLocation());
        }
        return retVal;
    }

    private CommandlineJava initializeJavaCommand() {
        CommandlineJava cmd = new CommandlineJava();
        cmd.setClassname(this.testRunnerClass);
        cmd.createVmArgument().setValue("-Xmx200M");
        if (this.verbose) {
            cmd.createArgument().setValue("-v");
        }
        if (this.resultsXMLPage != null) {
            String resultsHTMLPagePath = new File(this.resultsDir, this.resultsXMLPage).getAbsolutePath();
            cmd.createArgument().setValue("-xml");
            cmd.createArgument().setValue(resultsHTMLPagePath);
        }
        cmd.createArgument().setValue("localhost");
        cmd.createArgument().setValue(String.valueOf(this.fitnessePort));
        cmd.createArgument().setValue(this.suitePage);
        cmd.createClasspath(this.getProject()).createPath().append(this.classpath);
        return cmd;
    }

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setFitnessePort(int fitnessePort) {
        this.fitnessePort = fitnessePort;
    }

    public void setResultProperty(String resultProperty) {
        this.resultProperty = resultProperty;
    }

    public void setResultsDir(String resultsDir) {
        this.resultsDir = resultsDir;
    }

    public void setResultsXMLPage(String resultsXMLPage) {
        this.resultsXMLPage = resultsXMLPage;
    }

    public void setTestRunnerClass(String runnerClass) {
        this.testRunnerClass = runnerClass;
    }

    public void setSuitePage(String suitePage) {
        this.suitePage = suitePage;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setWikiDirectoryRootPath(String wikiDirectoryRootPath) {
        this.wikiDirectoryRootPath = wikiDirectoryRootPath;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }
}

