/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FilenameFilter;

public class Wildcard
implements FilenameFilter {
    private String pattern;
    private String prefix;
    private String sufix;
    private int length;

    public Wildcard(String pattern) {
        int starIndex = pattern.indexOf("*");
        if (starIndex > -1) {
            this.prefix = pattern.substring(0, starIndex);
            this.sufix = pattern.substring(starIndex + 1);
            this.length = this.prefix.length() + this.sufix.length();
        } else {
            this.pattern = pattern;
        }
    }

    public boolean accept(File dir, String name) {
        if (this.pattern != null) {
            return this.pattern.equals(name);
        }
        boolean goodLength = name.length() >= this.length;
        boolean goodPrefix = name.startsWith(this.prefix);
        boolean goodSufix = name.endsWith(this.sufix);
        return goodLength && goodPrefix && goodSufix;
    }
}

