/*
 * Copyright (C) 2006, British Broadcasting Corporation
 * All Rights Reserved.
 *
 * Author: Philip de Nier
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the British Broadcasting Corporation nor the names
 *       of its contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


/* Note: defines are undefined at the end of the file, unless KEEP_DATA_MODEL_DEFS defined */


#if !defined (MXF_BASIC_TYPE_DEF)
#define MXF_BASIC_TYPE_DEF(typeId, name, size)
#endif
#if !defined (MXF_ARRAY_TYPE_DEF)
#define MXF_ARRAY_TYPE_DEF(typeId, name, elementTypeId, fixedSize)
#endif
#if !defined (MXF_COMPOUND_TYPE_DEF)
#define MXF_COMPOUND_TYPE_DEF(typeId, name)
#endif
#if !defined (MXF_COMPOUND_TYPE_MEMBER)
#define MXF_COMPOUND_TYPE_MEMBER(memberName, memberTypeId)
#endif
#if !defined (MXF_INTERPRETED_TYPE_DEF)
#define MXF_INTERPRETED_TYPE_DEF(typeId, name, interpretedTypeId, fixedSize)
#endif

#if !defined (MXF_LABEL)
#define MXF_LABEL(d0, d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15)
#endif
#if !defined (MXF_SET_DEFINITION)
#define MXF_SET_DEFINITION(parentName, name, label)
#endif
#if !defined (MXF_ITEM_DEFINITION)
#define MXF_ITEM_DEFINITION(setName, name, label, localTag, typeId, isRequired)
#endif



    MXF_ITEM_DEFINITION(Preface, APP_VTRErrorCount,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x40, 0x01, 0x01, 0x00),
        0x0000,
        MXF_UINT32_TYPE,
        0
    );


    MXF_ITEM_DEFINITION(Preface, APP_PSEFailureCount,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x40, 0x01, 0x02, 0x00),
        0x0000,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(Preface, APP_DigiBetaDropoutCount,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x40, 0x01, 0x03, 0x00),
        0x0000,
        MXF_UINT32_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(Preface, APP_TimecodeBreakCount,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x40, 0x01, 0x04, 0x00),
        0x0000,
        MXF_UINT32_TYPE,
        0
    );


MXF_SET_DEFINITION(DMFramework, APP_InfaxFramework,
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00)
);

    MXF_ITEM_DEFINITION(APP_InfaxFramework, APP_Format,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(APP_InfaxFramework, APP_ProgrammeTitle,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(APP_InfaxFramework, APP_EpisodeTitle,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(APP_InfaxFramework, APP_TransmissionDate,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x01, 0x04, 0x00),
        0x0000,
        MXF_TIMESTAMP_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(APP_InfaxFramework, APP_MagazinePrefix,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(APP_InfaxFramework, APP_ProgrammeNumber,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x01, 0x06, 0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(APP_InfaxFramework, APP_ProductionCode,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x01, 0x0f, 0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(APP_InfaxFramework, APP_SpoolStatus,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(APP_InfaxFramework, APP_StockDate,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x01, 0x08, 0x00),
        0x0000,
        MXF_TIMESTAMP_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(APP_InfaxFramework, APP_SpoolDescriptor,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x01, 0x09, 0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(APP_InfaxFramework, APP_Memo,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x01, 0x0a, 0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(APP_InfaxFramework, APP_Duration,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x01, 0x0b, 0x00),
        0x0000,
        MXF_INT64_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(APP_InfaxFramework, APP_SpoolNumber,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x01, 0x0c, 0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(APP_InfaxFramework, APP_AccessionNumber,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(APP_InfaxFramework, APP_CatalogueDetail,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x01, 0x0e, 0x00),
        0x0000,
        MXF_UTF16STRING_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(APP_InfaxFramework, APP_ItemNumber,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00),
        0x0000,
        MXF_UINT32_TYPE,
        0
    );

MXF_SET_DEFINITION(DMFramework, APP_PSEAnalysisFramework,
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00)
);

    MXF_ITEM_DEFINITION(APP_PSEAnalysisFramework, APP_RedFlash,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x02, 0x01, 0x00),
        0x0000,
        MXF_INT16_TYPE,
        0
    );


    MXF_ITEM_DEFINITION(APP_PSEAnalysisFramework, APP_SpatialPattern,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x02, 0x02, 0x00),
        0x0000,
        MXF_INT16_TYPE,
        0
    );


    MXF_ITEM_DEFINITION(APP_PSEAnalysisFramework, APP_LuminanceFlash,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x02, 0x03, 0x00),
        0x0000,
        MXF_INT16_TYPE,
        0
    );

    MXF_ITEM_DEFINITION(APP_PSEAnalysisFramework, APP_ExtendedFailure,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x02, 0x04, 0x00),
        0x0000,
        MXF_BOOLEAN_TYPE,
        0
    );


MXF_SET_DEFINITION(DMFramework, APP_VTRReplayErrorFramework,
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00)
);

    MXF_ITEM_DEFINITION(APP_VTRReplayErrorFramework, APP_VTRErrorCode,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00),
        0x0000,
        MXF_UINT8_TYPE,
        0
    );



MXF_SET_DEFINITION(DMFramework, APP_DigiBetaDropoutFramework,
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x04, 0x00, 0x00)
);

    MXF_ITEM_DEFINITION(APP_DigiBetaDropoutFramework, APP_Strength,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x00),
        0x0000,
        MXF_INT32_TYPE,
        0
    );



MXF_SET_DEFINITION(DMFramework, APP_TimecodeBreakFramework,
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00)
);

    MXF_ITEM_DEFINITION(APP_TimecodeBreakFramework, APP_TimecodeType,
        MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x0d, 0x04, 0x01, 0x01, 0x01, 0x05, 0x01, 0x00),
        0x0000,
        MXF_UINT16_TYPE,
        0
    );




#if !defined(KEEP_DATA_MODEL_DEFS)
#undef MXF_BASIC_TYPE_DEF
#undef MXF_ARRAY_TYPE_DEF
#undef MXF_COMPOUND_TYPE_DEF
#undef MXF_COMPOUND_TYPE_MEMBER
#undef MXF_INTERPRETED_TYPE_DEF
#undef MXF_LABEL
#undef MXF_SET_DEFINITION
#undef MXF_ITEM_DEFINITION
#endif

