/*
 * Avid dictionary data
 *
 * Copyright (C) 2008, British Broadcasting Corporation
 * All Rights Reserved.
 *
 * Author: Philip de Nier
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the British Broadcasting Corporation nor the names
 *       of its contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


/*
    Dictionary defines generated using libMXF/tools/extract_avid_extensions/extract_avid_extensions
*/


/* Note: defines are undefined at the end of the file */

#if !defined (LABEL)
#define LABEL(d0, d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15)
#endif

#if !defined (TAGGEDVALUE_DEF)
#define TAGGEDVALUE_DEF(id, name, description)
#endif

#if !defined (DATA_DEF)
#define DATA_DEF(id, name, description)
#endif

#if !defined (CONTAINER_DEF)
#define CONTAINER_DEF(id, name, description)
#endif




TAGGEDVALUE_DEF(
    LABEL(0x8f, 0x5d, 0x13, 0x5d, 0xd8, 0xcd, 0xc9, 0x26, 0xd8, 0x0e, 0xcc, 0x37, 0x0d, 0x5c, 0x4d, 0x29),
    L"_PJ",
    L"Project Name"
);

DATA_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00),
    L"Timecode",
    L"12MTimeCodeTrackInactiveUserBits"
);

DATA_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00),
    L"Timecode",
    L"12MTimeCodeTrackActiveUserBits"
);

DATA_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00),
    L"Timecode",
    L"309M TimeCode data"
);

DATA_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x02, 0x01, 0x10, 0x00, 0x00, 0x00),
    L"Descriptive Metadata",
    L"Descriptive Metadata"
);

DATA_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00),
    L"Picture",
    L"Picture Essence"
);

DATA_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00),
    L"Sound",
    L"Sound Essence"
);

DATA_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00),
    L"DataEssenceTrack",
    L"Data Essence"
);

DATA_DEF(
    LABEL(0x80, 0xad, 0x00, 0x60, 0x08, 0x14, 0x3e, 0x6f, 0x05, 0xcb, 0xa7, 0x31, 0x1d, 0xaa, 0x11, 0xd3),
    L"Matte",
    L"Matte data"
);

DATA_DEF(
    LABEL(0x80, 0xad, 0x00, 0x60, 0x08, 0x14, 0x3e, 0x6f, 0x05, 0xcb, 0xa7, 0x32, 0x1d, 0xaa, 0x11, 0xd3),
    L"PictureWithMatte",
    L"PictureWithMatte data"
);

DATA_DEF(
    LABEL(0x80, 0x7f, 0x00, 0x60, 0x08, 0x14, 0x3e, 0x6f, 0x7f, 0x27, 0x5e, 0x81, 0x77, 0xe5, 0x11, 0xd2),
    L"Timecode",
    L"Timecode data (legacy)"
);

DATA_DEF(
    LABEL(0x8a, 0x5b, 0x00, 0x50, 0x04, 0x0e, 0xf7, 0xd2, 0x85, 0x14, 0x19, 0xd0, 0x2e, 0x4f, 0x11, 0xd3),
    L"Unknown",
    L"Unknown data"
);

DATA_DEF(
    LABEL(0x80, 0x7d, 0x00, 0x60, 0x08, 0x14, 0x3e, 0x6f, 0x6f, 0x3c, 0x8c, 0xe1, 0x6c, 0xef, 0x11, 0xd2),
    L"Picture",
    L"Picture data (legacy)"
);

DATA_DEF(
    LABEL(0x80, 0x7d, 0x00, 0x60, 0x08, 0x14, 0x3e, 0x6f, 0x78, 0xe1, 0xeb, 0xe1, 0x6c, 0xef, 0x11, 0xd2),
    L"Sound",
    L"Sound data (legacy)"
);

DATA_DEF(
    LABEL(0x89, 0xee, 0x00, 0x60, 0x97, 0x11, 0x62, 0x12, 0xd2, 0xbb, 0x2a, 0xf0, 0xd2, 0x34, 0x11, 0xd2),
    L"Edgecode",
    L"Edgecode data"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x01, 0x01, 0x01),
    L"ContainerD10_50Mbps_625x50i_defined_template",
    L"D-10; 50Mbps 625/50i (defined template)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x01, 0x02, 0x01),
    L"ContainerD10_50Mbps_525x60i_defined_template",
    L"D-10; 50Mbps 525/60i (defined template)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x01, 0x03, 0x01),
    L"ContainerD10_40Mbps_625x50i_defined_template",
    L"D-10; 40Mbps 625/50i (defined template)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x01, 0x04, 0x01),
    L"ContainerD10_40Mbps_525x60i_defined_template",
    L"D-10; 40Mbps 525/60i (defined template)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x01, 0x05, 0x01),
    L"ContainerD10_30Mbps_625x50i_defined_template",
    L"D-10; 30Mbps 625/50i (defined template)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x01, 0x06, 0x01),
    L"ContainerD10_30Mbps_525x60i_defined_template",
    L"D-10; 30Mbps 525/60i (defined template)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x01, 0x01, 0x02),
    L"ContainerD10_50Mbps_625x50i_extended_template",
    L"D-10; 50Mbps 625/50i (extended template)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x01, 0x02, 0x02),
    L"ContainerD10_50Mbps_525x60i_extended_template",
    L"D-10; 50Mbps 525/60i (extended template)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x01, 0x03, 0x02),
    L"ContainerD10_40Mbps_625x50i_extended_template",
    L"D-10; 40Mbps 625/50i (extended template)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x01, 0x04, 0x02),
    L"ContainerD10_40Mbps_525x60i_extended_template",
    L"D-10; 40Mbps 525/60i (extended template)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x01, 0x05, 0x02),
    L"ContainerD10_30Mbps_625x50i_extended_template",
    L"D-10; 30Mbps 625/50i (extended template)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x01, 0x06, 0x02),
    L"ContainerD10_30Mbps_525x60i_extended_template",
    L"D-10; 30Mbps 525/60i (extended template)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x01, 0x01, 0x7f),
    L"ContainerD10_50Mbps_625x50i_picture_only",
    L"D-10; 50Mbps 625/50i (picture only)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x01, 0x02, 0x7f),
    L"ContainerD10_50Mbps_525x60i_picture_only",
    L"D-10; 50Mbps 525/60i (picture only)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x01, 0x03, 0x7f),
    L"ContainerD10_40Mbps_625x50i_picture_only",
    L"D-10; 40Mbps 625/50i (picture only)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x01, 0x04, 0x7f),
    L"ContainerD10_40Mbps_525x60i_picture_only",
    L"D-10; 40Mbps 525/60i (picture only)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x01, 0x05, 0x7f),
    L"ContainerD10_30Mbps_625x50i_picture_only",
    L"D-10; 30Mbps 625/50i (picture only)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x01, 0x06, 0x7f),
    L"ContainerD10_30Mbps_525x60i_picture_only",
    L"D-10; 30Mbps 525/60i (picture only)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x01, 0x01),
    L"ContainerDV_IEC_25Mbps_525x60i_frame_wrapped",
    L"DV; IEC 25Mbps 525/60i (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x02, 0x01),
    L"ContainerDV_IEC_25Mbps_625x50i_frame_wrapped",
    L"DV; IEC 25Mbps 625/50i (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x03, 0x01),
    L"ContainerDV_IEC_25Mbps_525x60i_DVCAM_frame_wrapped",
    L"DV; IEC 25Mbps 525/60i DVCAM (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x04, 0x01),
    L"ContainerDV_IEC_25Mbps_625x50i_DVCAM_frame_wrapped",
    L"DV; IEC 25Mbps 625/50i DVCAM (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x3f, 0x01),
    L"ContainerDV_Undefined_IEC_DV_frame_wrapped",
    L"DV; Undefined IEC DV (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x40, 0x01),
    L"ContainerDV_25Mbps_525x60i_frame_wrapped",
    L"DV; 25Mbps 525/60i (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x41, 0x01),
    L"ContainerDV_25Mbps_625x50i_frame_wrapped",
    L"DV; 25Mbps 625/50i (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x50, 0x01),
    L"ContainerDV_50Mbps_525x60i_frame_wrapped",
    L"DV; 50Mbps 525/60i (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x51, 0x01),
    L"ContainerDV_50Mbps_625x50i_frame_wrapped",
    L"DV; 50Mbps 625/50i (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x60, 0x01),
    L"ContainerDV_100Mbps_1080x60i_frame_wrapped",
    L"DV; 100Mbps 1080/60i (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x61, 0x01),
    L"ContainerDV_100Mbps_1080x50i_frame_wrapped",
    L"DV; 100Mbps 1080/50i (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x62, 0x01),
    L"ContainerDV_100Mbps_720x60p_frame_wrapped",
    L"DV; 100Mbps 720/60p (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x63, 0x01),
    L"ContainerDV_100Mbps_720x50p_frame_wrapped",
    L"DV; 100Mbps 720/50p (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x7f, 0x01),
    L"ContainerDV_undefined_frame_wrapped",
    L"DV; undefined (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x01, 0x02),
    L"ContainerDV_IEC_25Mbps_525x60i_clip_wrapped",
    L"DV; IEC 25Mbps 525/60i (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x02, 0x02),
    L"ContainerDV_IEC_25Mbps_625x50i_clip_wrapped",
    L"DV; IEC 25Mbps 625/50i (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x03, 0x02),
    L"ContainerDV_IEC_25Mbps_525x60i_DVCAM_clip_wrapped",
    L"DV; IEC 25Mbps 525/60i DVCAM (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x04, 0x02),
    L"ContainerDV_IEC_25Mbps_625x50i_DVCAM_clip_wrapped",
    L"DV; IEC 25Mbps 625/50i DVCAM (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x3f, 0x02),
    L"ContainerDV_Undefined_IEC_DV_clip_wrapped",
    L"DV; Undefined IEC DV (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x40, 0x02),
    L"ContainerDV_25Mbps_525x60i_clip_wrapped",
    L"DV; 25Mbps 525/60i (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x02, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x40, 0x02),
    L"ContainerDV_25Mbps_525x60i_clip_wrapped_bogus",
    L"DV; 25Mbps 525/60i (clip wrapped) (bogus)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x41, 0x02),
    L"ContainerDV_25Mbps_625x50i_clip_wrapped",
    L"DV; 25Mbps 625/50i (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x50, 0x02),
    L"ContainerDV_50Mbps_525x60i_clip_wrapped",
    L"DV; 50Mbps 525/60i (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x51, 0x02),
    L"ContainerDV_50Mbps_625x50i_clip_wrapped",
    L"DV; 50Mbps 625/50i (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x60, 0x02),
    L"ContainerDV_100Mbps_1080x60i_clip_wrapped",
    L"DV; 100Mbps 1080/60i (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x61, 0x02),
    L"ContainerDV_100Mbps_1080x50i_clip_wrapped",
    L"DV; 100Mbps 1080/50i (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x62, 0x02),
    L"ContainerDV_100Mbps_720x60p_clip_wrapped",
    L"DV; 100Mbps 720/60p (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x63, 0x02),
    L"ContainerDV_100Mbps_720x50p_clip_wrapped",
    L"DV; 100Mbps 720/50p (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x7f, 0x02),
    L"ContainerDV_undefined_clip_wrapped",
    L"DV; undefined (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x02, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x02, 0x7f, 0x02),
    L"ContainerDV_undefined_clip_wrapped_bogus",
    L"DV; undefined (clip wrapped) (bogus)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x02, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x04, 0x40, 0x00),
    L"ContainerMPEG_Elementary_Stream_Audio_stream_id_0x40_clip_wrapped",
    L"MPEG Elementary Stream; Audio stream id 0x40 (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x04, 0x60, 0x01),
    L"ContainerMPEG_Elementary_Stream_stream_id_0x60_frame_wrapped",
    L"MPEG Elementary Stream; stream id 0x60 (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x04, 0x61, 0x07),
    L"ContainerUnknown_Sony002",
    L"Unknown; Sony002"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x05, 0x01, 0x01),
    L"ContainerUncompressed_Picture_525_60i_422_13p5MHz_frame_wrapped",
    L"Uncompressed Picture; 525 60i 422 13.5MHz (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x05, 0x01, 0x02),
    L"ContainerUncompressed_Picture_525_60i_422_13p5MHz_clip_wrapped",
    L"Uncompressed Picture; 525 60i 422 13.5MHz (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x05, 0x01, 0x03),
    L"ContainerUncompressed_Picture_525_60i_422_13p5MHz_line_wrapped",
    L"Uncompressed Picture; 525 60i 422 13.5MHz (line wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x05, 0x01, 0x05),
    L"ContainerUncompressed_Picture_625_50i_422_13p5MHz_frame_wrapped",
    L"Uncompressed Picture; 625 50i 422 13.5MHz (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x05, 0x01, 0x06),
    L"ContainerUncompressed_Picture_625_50i_422_13p5MHz_clip_wrapped",
    L"Uncompressed Picture; 625 50i 422 13.5MHz (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x05, 0x01, 0x07),
    L"ContainerUncompressed_Picture_625_50i_422_13p5MHz_line_wrapped",
    L"Uncompressed Picture; 625 50i 422 13.5MHz (line wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x05, 0x01, 0x19),
    L"ContainerUncompressed_Picture_525_60p_422_27MHz_frame_wrapped",
    L"Uncompressed Picture; 525 60p 422 27MHz (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x05, 0x01, 0x1a),
    L"ContainerUncompressed_Picture_525_60p_422_27MHz_clip_wrapped",
    L"Uncompressed Picture; 525 60p 422 27MHz (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x05, 0x01, 0x1b),
    L"ContainerUncompressed_Picture_525_60p_422_27MHz_line_wrapped",
    L"Uncompressed Picture; 525 60p 422 27MHz (line wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x05, 0x01, 0x1d),
    L"ContainerUncompressed_Picture_625_50p_422_27MHz_frame_wrapped",
    L"Uncompressed Picture; 625 50p 422 27MHz (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x05, 0x01, 0x1e),
    L"ContainerUncompressed_Picture_625_50p_422_27MHz_clip_wrapped",
    L"Uncompressed Picture; 625 50p 422 27MHz (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x05, 0x01, 0x1f),
    L"ContainerUncompressed_Picture_625_50p_422_27MHz_line_wrapped",
    L"Uncompressed Picture; 625 50p 422 27MHz (line wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x06, 0x01, 0x00),
    L"ContainerAES3xBWF_BWF_frame_wrapped",
    L"AES3/BWF; BWF (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x06, 0x02, 0x00),
    L"ContainerAES3xBWF_BWF_clip_wrapped",
    L"AES3/BWF; BWF (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x06, 0x03, 0x00),
    L"ContainerAES3xBWF_AES3_frame_wrapped",
    L"AES3/BWF; AES3 (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x02, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x06, 0x04, 0x00),
    L"ContainerUnknown_Panasonic001",
    L"Unknown; Panasonic001"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x06, 0x04, 0x00),
    L"ContainerAES3xBWF_AES3_clip_wrapped",
    L"AES3/BWF; AES3 (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x0a, 0x01, 0x00),
    L"ContainerALaw_Sound_Element_ALaw_Audio_frame_wrapped",
    L"A-Law Sound Element; A-Law Audio (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x0a, 0x02, 0x00),
    L"ContainerALaw_Sound_Element_ALaw_Audio_clip_wrapped",
    L"A-Law Sound Element; A-Law Audio (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x0a, 0x03, 0x00),
    L"ContainerALaw_Sound_Element_ALaw_Audio_custom_wrapped",
    L"A-Law Sound Element; A-Law Audio (custom wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x10, 0x60, 0x02),
    L"ContainerAVC_clip_wrapped_v1_Panasonic",
    L"AVC (clip wrapped), Registry Version 1, Panasonic"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0a, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x10, 0x60, 0x02),
    L"ContainerAVC_clip_wrapped",
    L"AVC (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0a, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x11, 0x01, 0x00),
    L"ContainerVC3_frame_wrapped",
    L"VC-3 (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0a, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x11, 0x02, 0x00),
    L"ContainerVC3_clip_wrapped",
    L"VC-3 (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0a, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x12, 0x01, 0x00),
    L"ContainerVC1_frame_wrapped",
    L"VC-1 (frame wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x0a, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x12, 0x02, 0x00),
    L"ContainerVC1_clip_wrapped",
    L"VC-1 (clip wrapped)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x04, 0x0d, 0x01, 0x03, 0x01, 0x01, 0x7f, 0x01, 0x00),
    L"ContainerUnknown_Sony001",
    L"Unknown; Sony001"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x03, 0x0d, 0x01, 0x03, 0x01, 0x02, 0x7f, 0x01, 0x00),
    L"ContainerGeneric_Wrapping_Generic_multiple_wrappings",
    L"Generic Wrapping; Generic (multiple wrappings)"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0e, 0x04, 0x03, 0x01, 0x02, 0x06, 0x01, 0x01),
    L"ContainerAvidHD_X_6_1_1080p",
    L"AvidHD; X_6_1_1080p"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0e, 0x04, 0x03, 0x01, 0x02, 0x06, 0x02, 0x01),
    L"ContainerAvidHD_X_6_1_1080i",
    L"AvidHD; X_6_1_1080i"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0e, 0x04, 0x03, 0x01, 0x02, 0x06, 0x03, 0x01),
    L"ContainerAvidHD_X_5_1_720p",
    L"AvidHD; X_5_1_720p"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0e, 0x04, 0x03, 0x01, 0x02, 0x06, 0x01, 0x02),
    L"ContainerAvidHD_8_7_1_1080p",
    L"AvidHD; 8_7_1_1080p"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0e, 0x04, 0x03, 0x01, 0x02, 0x06, 0x02, 0x02),
    L"ContainerAvidHD_8_7_1_1080i",
    L"AvidHD; 8_7_1_1080i"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0e, 0x04, 0x03, 0x01, 0x02, 0x06, 0x03, 0x02),
    L"ContainerAvidHD_8_4_1_720p",
    L"AvidHD; 8_4_1_720p"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0e, 0x04, 0x03, 0x01, 0x02, 0x06, 0x01, 0x03),
    L"ContainerAvidHD_8_4_1_1080p",
    L"AvidHD; 8_4_1_1080p"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0e, 0x04, 0x03, 0x01, 0x02, 0x06, 0x02, 0x03),
    L"ContainerAvidHD_8_4_1_1080i",
    L"AvidHD; 8_4_1_1080i"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0e, 0x04, 0x03, 0x01, 0x02, 0x06, 0x03, 0x03),
    L"ContainerAvidHD_8_6_1_720p",
    L"AvidHD; 8_6_1_720p"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0e, 0x04, 0x03, 0x01, 0x02, 0x06, 0x01, 0x04),
    L"ContainerAvidHD_8_22_1_1080p",
    L"AvidHD; 8_22_1_1080p"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0xff, 0x42, 0x46, 0x41, 0x41, 0x00, 0x0d, 0x4d, 0x4f),
    L"AAF MSS",
    L"AAF MSS Container"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0xff, 0x43, 0x46, 0x41, 0x41, 0x00, 0x0d, 0x4d, 0x4f),
    L"AAF CBR",
    L"AAF CBR Container"
);

CONTAINER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0xff, 0x4b, 0x46, 0x41, 0x41, 0x00, 0x0d, 0x4d, 0x4f),
    L"MXF",
    L"MXF Container"
);

CONTAINER_DEF(
    LABEL(0x80, 0xfb, 0x00, 0x60, 0x08, 0x14, 0x3e, 0x6f, 0x4b, 0x1c, 0x1a, 0x46, 0x03, 0xf2, 0x11, 0xd4),
    L"OMF",
    L"OMF Container"
);

CONTAINER_DEF(
    LABEL(0xbd, 0xe3, 0x8d, 0x7c, 0xd9, 0x25, 0x8e, 0x18, 0xc5, 0x9e, 0xf5, 0x6f, 0x5c, 0xb4, 0x4c, 0xb8),
    L"AAF XML",
    L"AAF XML Container"
);

CONTAINER_DEF(
    LABEL(0x80, 0x9b, 0x00, 0x60, 0x08, 0x14, 0x3e, 0x6f, 0x43, 0x13, 0xb5, 0x71, 0xd8, 0xba, 0x11, 0xd2),
    L"AAF",
    L"AAF Container"
);

CONTAINER_DEF(
    LABEL(0x80, 0x9b, 0x00, 0x60, 0x08, 0x14, 0x3e, 0x6f, 0x43, 0x13, 0xb5, 0x72, 0xd8, 0xba, 0x11, 0xd2),
    L"External",
    L"External Container"
);



#undef LABEL
#undef TAGGEDVALUE_DEFINITION
#undef DATA_DEF
#undef CONTAINER_DEF

