/*
 * Avid meta-dictionary data
 *
 * Copyright (C) 2008, British Broadcasting Corporation
 * All Rights Reserved.
 *
 * Author: Philip de Nier
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the British Broadcasting Corporation nor the names
 *       of its contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


/*
    Meta-dictionary defines generated using libMXF/tools/extract_avid_extensions/extract_avid_extensions

    NOTES:
    - PROPERTY_DEFs must come just after the CLASS_DEF
    - ..._ELEMENT and ...MEMBER must come just after the ..._DEF
    - the typeId in the PROPERTY_DEF must use LABEL_2 and not LABEL

*/


/* Note: defines are undefined at the end of the file */

#if !defined (LABEL)
#define LABEL(d0, d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15)
#endif

#if !defined (LABEL_2)
#define LABEL_2(d0, d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15)
#endif

#if !defined (WEAKREF)
#define WEAKREF(d0, d1, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15)
#endif

#if !defined (CLASS_DEF)
#define CLASS_DEF(id, name, description, parentId, isConcrete)
#endif

#if !defined (PROPERTY_DEF)
#define PROPERTY_DEF(id, name, description, typeId, isOptional, localId, isUniqueId)
#endif

#if !defined (CHARACTER_DEF)
#define CHARACTER_DEF(id, name, description)
#endif

#if !defined (ENUM_DEF)
#define ENUM_DEF(id, name, description, typeId)
#endif
#if !defined (ENUM_ELEMENT)
#define ENUM_ELEMENT(name, value)
#endif

#if !defined (EXTENUM_DEF)
#define EXTENUM_DEF(id, name, description)
#endif
#if !defined (EXTENUM_ELEMENT)
#define EXTENUM_ELEMENT(name, value)
#endif

#if !defined (FIXEDARRAY_DEF)
#define FIXEDARRAY_DEF(id, name, description, typeId, count)
#endif

#if !defined (INDIRECT_DEF)
#define INDIRECT_DEF(id, name, description)
#endif

#if !defined (INTEGER_DEF)
#define INTEGER_DEF(id, name, description, size, isSigned)
#endif

#if !defined (OPAQUE_DEF)
#define OPAQUE_DEF(id, name, description)
#endif

#if !defined (RENAME_DEF)
#define RENAME_DEF(id, name, description, typeId)
#endif

#if !defined (RECORD_DEF)
#define RECORD_DEF(id, name, description)
#endif
#if !defined (RECORD_MEMBER)
#define RECORD_MEMBER(name, type)
#endif

#if !defined (SET_DEF)
#define SET_DEF(id, name, description, typeId)
#endif

#if !defined (STREAM_DEF)
#define STREAM_DEF(id, name, description)
#endif

#if !defined (STRING_DEF)
#define STRING_DEF(id, name, description, typeId)
#endif

#if !defined (STRONGOBJREF_DEF)
#define STRONGOBJREF_DEF(id, name, description, refTypeId)
#endif

#if !defined (WEAKOBJREF_DEF)
#define WEAKOBJREF_DEF(id, name, description, refTypeId)
#endif
#if !defined (WEAKOBJREF_TARGET_ELEMENT)
#define WEAKOBJREF_TARGET_ELEMENT(id)
#endif

#if !defined (VARARRAY_DEF)
#define VARARRAY_DEF(id, name, description, typeId)
#endif





CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00),
    L"InterchangeObject",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00),
    0
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x07, 0x01, 0x08, 0x00, 0x00, 0x00),
        L"Generation",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0102,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x01, 0x01, 0x00, 0x00),
        L"ObjClass",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x0101,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00),
    L"Component",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00),
    0
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        L"DataDefinition",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x0201,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x07, 0x02, 0x02, 0x01, 0x01, 0x03, 0x00, 0x00),
        L"Length",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x20, 0x02, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0202,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x07, 0x03, 0x02, 0x01, 0x02, 0x16, 0x00, 0x00, 0x00),
        L"UserComments",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x06, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0204,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x03, 0x01, 0x02, 0x10, 0x04, 0x00, 0x00, 0x00),
        L"KLVData",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x06, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0203,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x07, 0x03, 0x01, 0x02, 0x10, 0x08, 0x00, 0x00, 0x00),
        L"Attributes",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x06, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0205,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00),
    L"Segment",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00),
    0
);

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x00),
    L"Event",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00),
    0
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x07, 0x02, 0x01, 0x03, 0x03, 0x03, 0x00, 0x00),
        L"Position",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00),
        0,
        0x0601,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x30, 0x04, 0x04, 0x01, 0x00, 0x00, 0x00),
        L"Comment",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0602,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x08, 0x00),
    L"CommentMarker",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x02, 0x0a, 0x00, 0x00),
        L"Annotation",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0901,
        0
    );

    PROPERTY_DEF(
        LABEL(0xaf, 0x34, 0xbc, 0x47, 0xfe, 0xc1, 0xea, 0xa8, 0xc7, 0x2c, 0xc8, 0x17, 0xaa, 0xc5, 0x49, 0x9b),
        L"CommentMarkerAttributeList",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x06, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa0, 0x69, 0x00, 0x60, 0x94, 0xeb, 0x75, 0xcb, 0xe9, 0x6e, 0x6d, 0x44, 0xc3, 0x83, 0x11, 0xd3),
        L"CommentMarkerColor",
        NULL,
        LABEL_2(0xa0, 0x69, 0x00, 0x60, 0x94, 0xeb, 0x75, 0xcb, 0xe9, 0x6e, 0x6d, 0x43, 0xc3, 0x83, 0x11, 0xd3),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xb0, 0xe4, 0x27, 0x2c, 0x93, 0x23, 0x78, 0xa6, 0x6d, 0x64, 0xdd, 0x66, 0xe5, 0xc7, 0x48, 0x8f),
        L"CommentMarkerAnnotationList",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa0, 0x8a, 0x00, 0x60, 0x94, 0xeb, 0x75, 0xcb, 0xc4, 0xc4, 0x5d, 0x9a, 0x09, 0x67, 0x11, 0xd4),
        L"CommentMarkerUSer",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa0, 0x8a, 0x00, 0x60, 0x94, 0xeb, 0x75, 0xcb, 0xc4, 0xc4, 0x5d, 0x9b, 0x09, 0x67, 0x11, 0xd4),
        L"CommentMarkerDate",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa0, 0x8a, 0x00, 0x60, 0x94, 0xeb, 0x75, 0xcb, 0xc4, 0xc4, 0x5d, 0x9c, 0x09, 0x67, 0x11, 0xd4),
        L"CommentMarkerTime",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa0, 0x8a, 0x00, 0x60, 0x94, 0xeb, 0x75, 0xcb, 0xc4, 0xc4, 0x5d, 0x9d, 0x09, 0x67, 0x11, 0xd4),
        L"CommentMarkerIcon",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa0, 0x8a, 0x00, 0x60, 0x94, 0xeb, 0x75, 0xcb, 0xc4, 0xc4, 0x5d, 0x9e, 0x09, 0x67, 0x11, 0xd4),
        L"CommentMarkerStatus",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0f, 0x00),
    L"Sequence",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x06, 0x09, 0x00, 0x00),
        L"Components",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x1001,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00),
    L"SourceReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00),
    0
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00),
        L"SourceID",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x1101,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00),
        L"SourceMobSlotID",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x1102,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x07, 0x06, 0x01, 0x01, 0x03, 0x07, 0x00, 0x00, 0x00),
        L"ChannelIDs",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x1103,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x08, 0x06, 0x01, 0x01, 0x03, 0x08, 0x00, 0x00, 0x00),
        L"MonoSourceSlotIDs",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x1104,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x00),
    L"SourceClip",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x07, 0x02, 0x02, 0x01, 0x01, 0x05, 0x02, 0x00),
        L"FadeInLength",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x20, 0x02, 0x00, 0x00, 0x00, 0x00),
        1,
        0x1202,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x07, 0x02, 0x02, 0x01, 0x01, 0x05, 0x03, 0x00),
        L"FadeOutLength",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x20, 0x02, 0x00, 0x00, 0x00, 0x00),
        1,
        0x1204,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x05, 0x30, 0x05, 0x01, 0x00, 0x00, 0x00, 0x00),
        L"FadeInType",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00),
        1,
        0x1203,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x05, 0x30, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00),
        L"FadeOutType",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00),
        1,
        0x1205,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x07, 0x02, 0x01, 0x03, 0x01, 0x04, 0x00, 0x00),
        L"StartTime",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00),
        1,
        0x1201,
        0
    );

    PROPERTY_DEF(
        LABEL(0x8e, 0x0b, 0x4b, 0x14, 0x9b, 0x66, 0x1a, 0x12, 0x66, 0x01, 0x62, 0xe5, 0xbb, 0xef, 0x46, 0x18),
        L"SubclipFullLength",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x14, 0x00),
    L"Timecode",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x04, 0x04, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00),
        L"Drop",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x1503,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x04, 0x01, 0x01, 0x02, 0x06, 0x00, 0x00),
        L"FPS",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x1502,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x07, 0x02, 0x01, 0x03, 0x01, 0x05, 0x00, 0x00),
        L"Start",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00),
        0,
        0x1501,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x18, 0x00),
    L"ContentStorage",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x05, 0x01, 0x00, 0x00),
        L"Mobs",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x1901,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x05, 0x02, 0x00, 0x00),
        L"EssenceData",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x1902,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1a, 0x00),
    L"DefinitionObject",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00),
    0
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x03, 0x02, 0x03, 0x01, 0x02, 0x01, 0x00, 0x00),
        L"Description",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x1b03,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x01, 0x07, 0x01, 0x02, 0x03, 0x01, 0x00, 0x00),
        L"Name",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x1b02,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x15, 0x03, 0x00, 0x00, 0x00, 0x00),
        L"Identification",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x1b01,
        1
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1b, 0x00),
    L"DataDefinition",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1a, 0x00),
    1
);

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1c, 0x00),
    L"OperationDefinition",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1a, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x05, 0x30, 0x05, 0x03, 0x00, 0x00, 0x00, 0x00),
        L"IsTimeWarp",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x1e02,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x04, 0x01, 0x00, 0x00),
        L"DegradeTo",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x1e03,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x03, 0x02, 0x00, 0x00),
        L"ParametersDefined",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x1e09,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x05, 0x30, 0x05, 0x04, 0x00, 0x00, 0x00, 0x00),
        L"NumberInputs",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x1e07,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x05, 0x30, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00),
        L"Bypass",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x1e08,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x30, 0x05, 0x09, 0x00, 0x00, 0x00, 0x00),
        L"DataDefinition",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x1e01,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x30, 0x05, 0x0a, 0x00, 0x00, 0x00, 0x00),
        L"OperationCategory",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00),
        1,
        0x1e06,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1d, 0x00),
    L"ParameterDefinition",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1a, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x01, 0x06, 0x00, 0x00),
        L"Type",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x1f01,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x30, 0x05, 0x0b, 0x01, 0x00, 0x00, 0x00),
        L"DisplayUnits",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x1f03,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1e, 0x00),
    L"PluginDefinition",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1a, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x01, 0x0a, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00),
        L"ManufacturerID",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x2208,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x01, 0x0a, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00),
        L"Manufacturer",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x2206,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x03, 0x03, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00),
        L"VersionNumber",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x2204,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x03, 0x03, 0x03, 0x01, 0x02, 0x01, 0x00, 0x00),
        L"VersionString",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x2205,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x09, 0x01, 0x00, 0x00, 0x00, 0x00),
        L"PluginCategory",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00),
        0,
        0x2203,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x09, 0x02, 0x00, 0x00, 0x00, 0x00),
        L"Platform",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x2209,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x09, 0x03, 0x00, 0x00, 0x00, 0x00),
        L"MinPlatformVersion",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x220a,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x02, 0x0b, 0x00, 0x00),
        L"ManufacturerInfo",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x2207,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x09, 0x04, 0x00, 0x00, 0x00, 0x00),
        L"MaxPlatformVersion",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x220b,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x09, 0x05, 0x00, 0x00, 0x00, 0x00),
        L"Engine",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x220c,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x09, 0x06, 0x00, 0x00, 0x00, 0x00),
        L"MinEngineVersion",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x220d,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x09, 0x07, 0x00, 0x00, 0x00, 0x00),
        L"MaxEngineVersion",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x220e,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x09, 0x08, 0x00, 0x00, 0x00, 0x00),
        L"PluginAPI",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x220f,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x09, 0x09, 0x00, 0x00, 0x00, 0x00),
        L"MinPluginAPI",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x2210,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x09, 0x0a, 0x00, 0x00, 0x00, 0x00),
        L"MaxPluginAPI",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x2211,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x09, 0x0b, 0x00, 0x00, 0x00, 0x00),
        L"SoftwareOnly",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x2212,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x09, 0x0c, 0x00, 0x00, 0x00, 0x00),
        L"Accelerator",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x2213,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x09, 0x0d, 0x00, 0x00, 0x00, 0x00),
        L"Locators",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x2214,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x09, 0x0e, 0x00, 0x00, 0x00, 0x00),
        L"Authentication",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x2215,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x09, 0x0f, 0x00, 0x00, 0x00, 0x00),
        L"DefinitionObject",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x2216,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00),
    L"CodecDefinition",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1a, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x03, 0x01, 0x00, 0x00),
        L"DataDefinitions",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x2302,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x01, 0x07, 0x00, 0x00),
        L"FileDescriptorClass",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x2301,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00),
    L"ContainerDefinition",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1a, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x03, 0x01, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00),
        L"EssenceIsIdentified",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x2401,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x21, 0x00),
    L"InterpolationDefinition",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1a, 0x00),
    1
);

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x00),
    L"Dictionary",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x05, 0x03, 0x00, 0x00),
        L"OperationDefinitions",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x2603,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x05, 0x04, 0x00, 0x00),
        L"ParameterDefinitions",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x2604,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x05, 0x05, 0x00, 0x00),
        L"DataDefinitions",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x2605,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x05, 0x06, 0x00, 0x00),
        L"PluginDefinitions",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x2606,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x05, 0x07, 0x00, 0x00),
        L"CodecDefinitions",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x2607,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x05, 0x08, 0x00, 0x00),
        L"ContainerDefinitions",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x2608,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x05, 0x09, 0x00, 0x00),
        L"InterpolationDefinitions",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x2609,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x07, 0x06, 0x01, 0x01, 0x04, 0x05, 0x0a, 0x00, 0x00),
        L"KLVDataDefinitions",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x260a,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x07, 0x06, 0x01, 0x01, 0x04, 0x05, 0x0b, 0x00, 0x00),
        L"TaggedValueDefinitions",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x260b,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x23, 0x00),
    L"EssenceData",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x07, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        L"Data",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x2702,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00),
        L"SampleIndex",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x2b01,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x06, 0x01, 0x00, 0x00, 0x00),
        L"MobID",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x2701,
        1
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x24, 0x00),
    L"EssenceDescriptor",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00),
    0
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x06, 0x03, 0x00, 0x00),
        L"Locator",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x2f01,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x25, 0x00),
    L"FileDescriptor",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x24, 0x00),
    0
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x04, 0x06, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00),
        L"SampleRate",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3001,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x04, 0x06, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00),
        L"Length",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x20, 0x02, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3002,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, 0x06, 0x01, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00),
        L"LinkedTrackID",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3006,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x01, 0x02, 0x00, 0x00),
        L"ContainerFormat",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3004,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x01, 0x03, 0x00, 0x00),
        L"CodecDefinition",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3005,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x00),
    L"DigitalImageDescriptor",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x25, 0x00),
    0
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00),
        L"ImageAspectRatio",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x320e,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x18, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00),
        L"ImageAlignmentFactor",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3211,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x01, 0x02, 0x01, 0x01, 0x01, 0x02, 0x00),
        L"TransferCharacteristic",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3210,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x01, 0x02, 0x01, 0x01, 0x03, 0x01, 0x00),
        L"CodingEquations",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00),
        1,
        0x321a,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x09, 0x04, 0x01, 0x02, 0x01, 0x01, 0x06, 0x01, 0x00),
        L"ColorPrimaries",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3219,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00),
        L"FrameLayout",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00),
        0,
        0x320c,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x01, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00),
        L"FieldDominance",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x21, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3212,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x05, 0x01, 0x07, 0x00, 0x00, 0x00),
        L"SampledHeight",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3204,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x05, 0x01, 0x08, 0x00, 0x00, 0x00),
        L"SampledWidth",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3205,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x05, 0x01, 0x09, 0x00, 0x00, 0x00),
        L"SampledXOffset",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3206,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x05, 0x01, 0x0a, 0x00, 0x00, 0x00),
        L"SampledYOffset",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3207,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x05, 0x01, 0x0b, 0x00, 0x00, 0x00),
        L"DisplayHeight",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3208,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x05, 0x01, 0x0c, 0x00, 0x00, 0x00),
        L"DisplayWidth",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3209,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x05, 0x01, 0x0d, 0x00, 0x00, 0x00),
        L"DisplayXOffset",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x320a,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x05, 0x01, 0x0e, 0x00, 0x00, 0x00),
        L"DisplayYOffset",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x320b,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x01, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00),
        L"Compression",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3201,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x18, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00),
        L"FieldStartOffset",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3213,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00),
        L"AlphaTransparency",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00),
        1,
        0x320f,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x01, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00),
        L"VideoLineMap",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x320d,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, 0x04, 0x01, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00),
        L"DisplayF2Offset",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3217,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, 0x04, 0x01, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00),
        L"StoredF2Offset",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3216,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, 0x04, 0x01, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00),
        L"ActiveFormatDescriptor",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3218,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x05, 0x02, 0x01, 0x00, 0x00, 0x00),
        L"StoredHeight",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3202,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x05, 0x02, 0x02, 0x00, 0x00, 0x00),
        L"StoredWidth",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3203,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x18, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00),
        L"FieldEndOffset",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3214,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, 0x04, 0x05, 0x01, 0x13, 0x00, 0x00, 0x00, 0x00),
        L"SignalStandard",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x27, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3215,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa0, 0x24, 0x00, 0x60, 0x94, 0xeb, 0x75, 0xcb, 0xce, 0x2a, 0xca, 0x4d, 0x51, 0xab, 0x11, 0xd3),
        L"ResolutionID",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa0, 0x24, 0x00, 0x60, 0x94, 0xeb, 0x75, 0xcb, 0xce, 0x2a, 0xca, 0x4e, 0x51, 0xab, 0x11, 0xd3),
        L"FirstFrameOffset",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa0, 0x24, 0x00, 0x60, 0x94, 0xeb, 0x75, 0xcb, 0xce, 0x2a, 0xca, 0x4f, 0x51, 0xab, 0x11, 0xd3),
        L"ImageSize",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa0, 0x24, 0x00, 0x60, 0x94, 0xeb, 0x75, 0xcb, 0xce, 0x2a, 0xca, 0x50, 0x51, 0xab, 0x11, 0xd3),
        L"FrameSampleSize",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa0, 0x8f, 0x00, 0x60, 0x94, 0xeb, 0x75, 0xcb, 0xb5, 0x7e, 0x92, 0x5d, 0x17, 0x0d, 0x11, 0xd4),
        L"FrameIndexByteOrder",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa5, 0x2c, 0x44, 0x58, 0xbf, 0xfa, 0x1f, 0xc6, 0xc8, 0xa0, 0xbd, 0x74, 0xa2, 0x47, 0x42, 0x97),
        L"FrameStartOffset",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa8, 0x0e, 0x21, 0x4d, 0xc0, 0xf1, 0x46, 0x84, 0xbf, 0xde, 0x81, 0xe4, 0xbc, 0xc8, 0x4a, 0xbd),
        L"DataOffset",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x28, 0x00),
    L"CDCIDescriptor",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, 0x03, 0x01, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00),
        L"ReversedByteOrder",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x330b,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x05, 0x01, 0x05, 0x00, 0x00, 0x00),
        L"HorizontalSubsampling",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3302,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x05, 0x01, 0x06, 0x00, 0x00, 0x00),
        L"ColorSiting",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3303,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x01, 0x05, 0x01, 0x10, 0x00, 0x00, 0x00),
        L"VerticalSubsampling",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3308,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x05, 0x03, 0x03, 0x00, 0x00, 0x00),
        L"BlackReferenceLevel",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3304,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x04, 0x01, 0x05, 0x03, 0x04, 0x00, 0x00, 0x00),
        L"WhiteReferenceLevel",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3305,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x01, 0x05, 0x03, 0x05, 0x00, 0x00, 0x00),
        L"ColorRange",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3306,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x01, 0x05, 0x03, 0x07, 0x00, 0x00, 0x00),
        L"AlphaSamplingWidth",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3309,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x01, 0x05, 0x03, 0x0a, 0x00, 0x00, 0x00),
        L"ComponentWidth",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3301,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x18, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00),
        L"PaddingBits",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3307,
        0
    );

    PROPERTY_DEF(
        LABEL(0x8b, 0xb3, 0xad, 0x5a, 0x84, 0x2b, 0x05, 0x85, 0xf6, 0xe5, 0x9f, 0x10, 0x24, 0x8e, 0x49, 0x4c),
        L"MPEGStreamType",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xbf, 0x73, 0x4a, 0xe5, 0x2b, 0x16, 0xb9, 0xea, 0xf8, 0xfd, 0x06, 0x1d, 0xea, 0x7e, 0x46, 0xba),
        L"ProfileAndLevel",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xb9, 0x4a, 0x62, 0xf9, 0x73, 0xfe, 0x60, 0x63, 0xf3, 0xe9, 0xdc, 0x41, 0xbb, 0xec, 0x46, 0xbd),
        L"TrailingDiscard",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0x8c, 0x90, 0xcf, 0x63, 0xaa, 0x79, 0x3c, 0x34, 0x29, 0x8e, 0xb2, 0x60, 0x30, 0xb6, 0x4e, 0x30),
        L"OffsetToFrameIndexes64",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa9, 0xba, 0xc6, 0xe9, 0x8e, 0x92, 0x01, 0x8d, 0x36, 0xa2, 0x80, 0x62, 0x48, 0x05, 0x4b, 0x21),
        L"MaxGOP",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0x8b, 0x4e, 0xba, 0xf0, 0xca, 0x09, 0x40, 0xb5, 0x54, 0x40, 0x5d, 0x72, 0xbf, 0xbd, 0x4b, 0x0e),
        L"MinGOP",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xb1, 0xf0, 0x77, 0x50, 0xaa, 0xd8, 0x87, 0x5d, 0x78, 0x39, 0xba, 0x85, 0x99, 0x9b, 0x4d, 0x60),
        L"MPEGVersion",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa5, 0x77, 0xa5, 0x00, 0x58, 0x1c, 0x9f, 0x05, 0x0f, 0xbf, 0x8f, 0x90, 0x4d, 0x98, 0x4e, 0x06),
        L"LeadingDiscard",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa0, 0x29, 0x00, 0x60, 0x94, 0xeb, 0x75, 0xcb, 0x9d, 0x15, 0xfc, 0xa3, 0x54, 0xc5, 0x11, 0xd3),
        L"OffsetToFrameIndexes",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa5, 0x73, 0xfa, 0x76, 0x5a, 0xa6, 0x46, 0x8a, 0x06, 0xe9, 0x29, 0xb3, 0x7d, 0x15, 0x4f, 0xd7),
        L"RandomAccess",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0x82, 0x14, 0x9f, 0x0b, 0x14, 0xba, 0x0c, 0xe0, 0x47, 0x3f, 0x46, 0xbf, 0x56, 0x2e, 0x49, 0xb6),
        L"BitRate",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa0, 0x29, 0x00, 0x60, 0x94, 0xeb, 0x75, 0xcb, 0x50, 0x6f, 0x8d, 0xe5, 0x54, 0xa1, 0x11, 0xd3),
        L"ImageStartAlignment",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0x93, 0xc0, 0xb4, 0x4a, 0x15, 0x6e, 0xd5, 0x2a, 0x94, 0x5d, 0xf2, 0xfa, 0xf4, 0x65, 0x47, 0x71),
        L"GOPStructure",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2e, 0x00),
    L"TapeDescriptor",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x24, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00),
        L"TapeFormat",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3a03,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x10, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00),
        L"Length",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3a04,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x10, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00),
        L"FormFactor",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3a01,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x10, 0x01, 0x01, 0x02, 0x01, 0x00, 0x00),
        L"Model",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3a06,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x10, 0x01, 0x01, 0x04, 0x01, 0x00, 0x00),
        L"ManufacturerID",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3a05,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x10, 0x01, 0x01, 0x05, 0x01, 0x00, 0x00),
        L"TapeStock",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3a08,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x10, 0x01, 0x01, 0x06, 0x01, 0x00, 0x00),
        L"TapeBatchNumber",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3a07,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x01, 0x04, 0x01, 0x01, 0x00, 0x00, 0x00),
        L"VideoSignal",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3a02,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa0, 0x8f, 0x00, 0x60, 0x94, 0xeb, 0x75, 0xcb, 0x95, 0x48, 0xb0, 0x3a, 0x15, 0xfb, 0x11, 0xd4),
        L"ColorFrame",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2f, 0x00),
    L"Header",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x03, 0x01, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00),
        L"ByteOrder",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3b01,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x03, 0x01, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00),
        L"ObjectModelVersion",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3b07,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x03, 0x01, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00),
        L"Version",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3b05,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, 0x01, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00),
        L"OperationalPattern",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3b09,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x02, 0x01, 0x00, 0x00),
        L"Content",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3b03,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x02, 0x02, 0x00, 0x00),
        L"Dictionary",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3b04,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x06, 0x04, 0x00, 0x00),
        L"IdentificationList",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3b06,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x07, 0x02, 0x01, 0x10, 0x02, 0x04, 0x00, 0x00),
        L"LastModified",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3b02,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, 0x01, 0x02, 0x02, 0x10, 0x02, 0x01, 0x00, 0x00),
        L"EssenceContainers",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3b0a,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, 0x01, 0x02, 0x02, 0x10, 0x02, 0x02, 0x00, 0x00),
        L"DescriptiveSchemes",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3b0b,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa5, 0xfb, 0x7b, 0x25, 0xf6, 0x15, 0x94, 0xb9, 0x62, 0xfc, 0x37, 0x17, 0x49, 0x2d, 0x42, 0xbf),
        L"ProjectName",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0x8b, 0x2f, 0x68, 0x0d, 0xff, 0x61, 0x13, 0x81, 0xab, 0xf1, 0xb7, 0x71, 0x8e, 0xfd, 0x48, 0x02),
        L"EssenceFileMobID",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0x8c, 0x70, 0xa7, 0x18, 0x46, 0x7a, 0xe4, 0x86, 0xf3, 0x65, 0x46, 0xb1, 0x38, 0x7c, 0x4e, 0xe9),
        L"ProjectEditRate",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0x85, 0x96, 0x99, 0xb5, 0x79, 0xe1, 0x77, 0xa6, 0xb7, 0xd5, 0x1a, 0xd5, 0x65, 0x0b, 0x4d, 0x3a),
        L"AudioRateAdjustmentFactor",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xae, 0x58, 0x78, 0xe0, 0x41, 0x45, 0x41, 0x79, 0xff, 0xdd, 0x41, 0xe1, 0xae, 0x2c, 0x49, 0xc6),
        L"MasterMobID",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30, 0x00),
    L"Identification",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x07, 0x01, 0x01, 0x00, 0x00, 0x00),
        L"GenerationAUID",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3c09,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x07, 0x01, 0x04, 0x00, 0x00, 0x00),
        L"ProductVersion",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3c03,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x07, 0x01, 0x07, 0x00, 0x00, 0x00),
        L"ProductID",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3c05,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x07, 0x01, 0x0a, 0x00, 0x00, 0x00),
        L"ToolkitVersion",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3c07,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x07, 0x01, 0x02, 0x01, 0x00, 0x00),
        L"CompanyName",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3c01,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x07, 0x01, 0x03, 0x01, 0x00, 0x00),
        L"ProductName",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3c02,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x07, 0x01, 0x05, 0x01, 0x00, 0x00),
        L"ProductVersionString",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3c04,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x20, 0x07, 0x01, 0x06, 0x01, 0x00, 0x00),
        L"Platform",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3c08,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x07, 0x02, 0x01, 0x10, 0x02, 0x03, 0x00, 0x00),
        L"Date",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3c06,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x31, 0x00),
    L"Locator",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00),
    0
);

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x32, 0x00),
    L"NetworkLocator",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x31, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00),
        L"URLString",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x4001,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x34, 0x00),
    L"Mob",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00),
    0
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x03, 0x02, 0x01, 0x02, 0x0c, 0x00, 0x00, 0x00),
        L"UserComments",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x06, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x4406,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00),
        L"Name",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x4402,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x06, 0x05, 0x00, 0x00),
        L"Slots",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x4403,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x07, 0x05, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00),
        L"UsageCode",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00),
        1,
        0x4408,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x07, 0x02, 0x01, 0x10, 0x01, 0x03, 0x00, 0x00),
        L"CreationTime",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x4405,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x07, 0x02, 0x01, 0x10, 0x02, 0x05, 0x00, 0x00),
        L"LastModified",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x4404,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x03, 0x01, 0x02, 0x10, 0x03, 0x00, 0x00, 0x00),
        L"KLVData",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x06, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x4407,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x07, 0x03, 0x01, 0x02, 0x10, 0x07, 0x00, 0x00, 0x00),
        L"Attributes",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x06, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x4409,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x15, 0x10, 0x00, 0x00, 0x00, 0x00),
        L"MobID",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x4401,
        1
    );

    PROPERTY_DEF(
        LABEL(0x95, 0x1d, 0x3a, 0x20, 0x38, 0x39, 0x67, 0x22, 0xaa, 0x24, 0xb6, 0x57, 0xfc, 0xbb, 0x49, 0x21),
        L"SubclipBegin",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa0, 0xf6, 0xce, 0xec, 0x04, 0x7c, 0x80, 0xaa, 0x12, 0x62, 0xbf, 0x7b, 0xfc, 0xe2, 0x4d, 0xfe),
        L"SubclipFullLength",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa0, 0x1c, 0x00, 0x04, 0xac, 0x96, 0x9f, 0x50, 0x60, 0x95, 0x81, 0x83, 0x47, 0xb1, 0x11, 0xd4),
        L"MobAttributeList",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x06, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa0, 0x22, 0x00, 0x60, 0x94, 0xeb, 0x75, 0xcb, 0x96, 0xc4, 0x69, 0x92, 0x4f, 0x62, 0x11, 0xd3),
        L"AppCode",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa8, 0xf3, 0xf2, 0xeb, 0xa5, 0x42, 0x44, 0xde, 0xd4, 0x24, 0x3b, 0xd4, 0x01, 0x42, 0x45, 0x95),
        L"ConvertFrameRate",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x36, 0x00),
    L"MasterMob",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x34, 0x00),
    1
);

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x37, 0x00),
    L"SourceMob",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x34, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x02, 0x03, 0x00, 0x00),
        L"EssenceDescription",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x4701,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x38, 0x00),
    L"MobSlot",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00),
    0
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x01, 0x07, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00),
        L"SlotID",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x4801,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x01, 0x07, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00),
        L"SlotName",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x4802,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x01, 0x04, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00),
        L"PhysicalTrackNumber",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x4804,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x02, 0x04, 0x00, 0x00),
        L"Segment",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x4803,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3b, 0x00),
    L"TimelineMobSlot",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x38, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x07, 0x02, 0x01, 0x03, 0x01, 0x03, 0x00, 0x00),
        L"Origin",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00),
        0,
        0x4b02,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x07, 0x07, 0x02, 0x01, 0x03, 0x02, 0x03, 0x00, 0x00),
        L"MarkOut",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00),
        1,
        0x4b04,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x07, 0x07, 0x02, 0x01, 0x03, 0x01, 0x0c, 0x00, 0x00),
        L"MarkIn",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00),
        1,
        0x4b03,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x07, 0x07, 0x02, 0x01, 0x03, 0x01, 0x0d, 0x00, 0x00),
        L"UserPos",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00),
        1,
        0x4b05,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x05, 0x30, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00),
        L"EditRate",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x4b01,
        0
    );

    PROPERTY_DEF(
        LABEL(0xb2, 0xc4, 0x5a, 0x3e, 0xb7, 0x55, 0xb7, 0xca, 0x10, 0x7f, 0x83, 0x31, 0x19, 0x14, 0x42, 0x34),
        L"TimelineMobAttributeList",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x06, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3c, 0x00),
    L"Parameter",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00),
    0
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x01, 0x04, 0x00, 0x00),
        L"Definition",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x4c01,
        0
    );

    PROPERTY_DEF(
        LABEL(0xb8, 0xe8, 0x3a, 0x0f, 0xbc, 0x55, 0x03, 0x53, 0x96, 0x7d, 0xbc, 0xc7, 0x4b, 0xa6, 0x4b, 0x57),
        L"IsSilent",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3f, 0x00),
    L"TaggedValue",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x03, 0x02, 0x01, 0x02, 0x09, 0x01, 0x00, 0x00),
        L"Name",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x5001,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x03, 0x02, 0x01, 0x02, 0x0a, 0x01, 0x00, 0x00),
        L"Value",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x10, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x5003,
        0
    );

    PROPERTY_DEF(
        LABEL(0xa0, 0x1c, 0x00, 0x04, 0xac, 0x96, 0x9f, 0x50, 0x60, 0x95, 0x81, 0x85, 0x47, 0xb1, 0x11, 0xd4),
        L"TaggedValueAttributeList",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x06, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x40, 0x00),
    L"KLVData",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x03, 0x01, 0x02, 0x10, 0x02, 0x00, 0x00, 0x00),
        L"Value",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x10, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x5101,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x42, 0x00),
    L"SoundDescriptor",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x25, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x04, 0x02, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00),
        L"ElectroSpatial",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x22, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3d05,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01, 0x04, 0x02, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00),
        L"AudioRefLevel",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3d04,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, 0x04, 0x02, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00),
        L"Channels",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3d07,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, 0x04, 0x02, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00),
        L"Locked",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3d02,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, 0x04, 0x02, 0x03, 0x01, 0x01, 0x01, 0x00, 0x00),
        L"AudioSamplingRate",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3d03,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, 0x04, 0x02, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00),
        L"DialNorm",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3d0c,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x04, 0x02, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00),
        L"Compression",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3d06,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04, 0x04, 0x02, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00),
        L"QuantizationBits",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3d01,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x48, 0x00),
    L"PCMDescriptor",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x42, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x07, 0x04, 0x02, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00),
        L"ChannelAssignment",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3d32,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x08, 0x04, 0x02, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00),
        L"PeakEnvelopeVersion",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3d29,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x08, 0x04, 0x02, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00),
        L"PeakEnvelopeFormat",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3d2a,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x08, 0x04, 0x02, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00),
        L"PointsPerPeakValue",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3d2b,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x08, 0x04, 0x02, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00),
        L"PeakEnvelopeBlockSize",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3d2c,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x08, 0x04, 0x02, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00),
        L"PeakChannels",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3d2d,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x08, 0x04, 0x02, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00),
        L"PeakFrames",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3d2e,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x08, 0x04, 0x02, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00),
        L"PeakOfPeaksPosition",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3d2f,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x08, 0x04, 0x02, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00),
        L"PeakEnvelopeTimestamp",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3d30,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x08, 0x04, 0x02, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00),
        L"PeakEnvelopeData",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3d31,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, 0x04, 0x02, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00),
        L"BlockAlign",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3d0a,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, 0x04, 0x02, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00),
        L"SequenceOffset",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x3d0b,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05, 0x04, 0x02, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00),
        L"AverageBPS",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x3d09,
        0
    );

    PROPERTY_DEF(
        LABEL(0x97, 0x59, 0xc7, 0x27, 0x77, 0x1f, 0xcc, 0x4a, 0xbb, 0x3f, 0xab, 0xdd, 0xfc, 0xc0, 0x43, 0xa8),
        L"DataOffset",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0000,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4c, 0x00),
    L"TaggedValueDefinition",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1a, 0x00),
    1
);

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4d, 0x00),
    L"KLVDataDefinition",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1a, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x07, 0x06, 0x01, 0x01, 0x04, 0x01, 0x09, 0x00, 0x00),
        L"KLVDataType",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x4d12,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x01, 0x00, 0x00),
    L"ClassDefinition",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x24, 0x00, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x07, 0x01, 0x00, 0x00, 0x00),
        L"ParentClass",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x0008,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x07, 0x02, 0x00, 0x00, 0x00),
        L"Properties",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0009,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x07, 0x03, 0x00, 0x00, 0x00),
        L"IsConcrete",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x000a,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x02, 0x00, 0x00),
    L"PropertyDefinition",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x24, 0x00, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x03, 0x01, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00),
        L"IsOptional",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x000c,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x07, 0x04, 0x00, 0x00, 0x00),
        L"Type",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x000b,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x07, 0x05, 0x00, 0x00, 0x00),
        L"LocalIdentification",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x000d,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x07, 0x06, 0x00, 0x00, 0x00),
        L"IsUniqueIdentifier",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x000e,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x03, 0x00, 0x00),
    L"TypeDefinition",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x24, 0x00, 0x00),
    0
);

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x05, 0x00, 0x00),
    L"TypeDefinitionStrongObjectReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x03, 0x00, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x07, 0x09, 0x00, 0x00, 0x00),
        L"ReferencedType",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x0011,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x06, 0x00, 0x00),
    L"TypeDefinitionWeakObjectReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x03, 0x00, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x03, 0x01, 0x02, 0x03, 0x0b, 0x00, 0x00, 0x00),
        L"TargetSet",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x0013,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x07, 0x0a, 0x00, 0x00, 0x00),
        L"ReferencedType",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x0012,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x07, 0x00, 0x00),
    L"TypeDefinitionEnumeration",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x03, 0x00, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x03, 0x01, 0x02, 0x03, 0x04, 0x00, 0x00, 0x00),
        L"ElementNames",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x0015,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x03, 0x01, 0x02, 0x03, 0x05, 0x00, 0x00, 0x00),
        L"ElementValues",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x0016,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x07, 0x0b, 0x00, 0x00, 0x00),
        L"ElementType",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x0014,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x08, 0x00, 0x00),
    L"TypeDefinitionFixedArray",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x03, 0x00, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x03, 0x01, 0x02, 0x03, 0x03, 0x00, 0x00, 0x00),
        L"ElementCount",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x0018,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x07, 0x0c, 0x00, 0x00, 0x00),
        L"ElementType",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x0017,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x09, 0x00, 0x00),
    L"TypeDefinitionVariableArray",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x03, 0x00, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x07, 0x0d, 0x00, 0x00, 0x00),
        L"ElementType",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x0019,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x0a, 0x00, 0x00),
    L"TypeDefinitionSet",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x03, 0x00, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x07, 0x0e, 0x00, 0x00, 0x00),
        L"ElementType",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x001a,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x0d, 0x00, 0x00),
    L"TypeDefinitionRecord",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x03, 0x00, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x03, 0x01, 0x02, 0x03, 0x06, 0x00, 0x00, 0x00),
        L"MemberNames",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x001d,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x07, 0x11, 0x00, 0x00, 0x00),
        L"MemberTypes",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x001c,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x0e, 0x00, 0x00),
    L"TypeDefinitionRename",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x03, 0x00, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x07, 0x12, 0x00, 0x00, 0x00),
        L"RenamedType",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x001e,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x20, 0x00, 0x00),
    L"TypeDefinitionExtendibleEnumeration",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x03, 0x00, 0x00),
    1
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x03, 0x01, 0x02, 0x03, 0x07, 0x00, 0x00, 0x00),
        L"ElementNames",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x001f,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x03, 0x01, 0x02, 0x03, 0x08, 0x00, 0x00, 0x00),
        L"ElementValues",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x0020,
        0
    );

CLASS_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x24, 0x00, 0x00),
    L"MetaDefinition",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x24, 0x00, 0x00),
    0
);

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x03, 0x02, 0x04, 0x01, 0x02, 0x01, 0x00, 0x00),
        L"Name",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x0006,
        0
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x07, 0x13, 0x00, 0x00, 0x00),
        L"Identification",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
        0,
        0x0005,
        1
    );

    PROPERTY_DEF(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x07, 0x14, 0x01, 0x00, 0x00),
        L"Description",
        NULL,
        LABEL_2(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
        1,
        0x0007,
        0
    );

INTEGER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"aafUInt8",
    NULL,
    1,
    0
);

RECORD_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"Rational",
    NULL
);

    RECORD_MEMBER(
        L"Numerator",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"Denominator",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00)
    );

WEAKOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"ClassDefinitionWeakReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x01, 0x00, 0x00)
);

    WEAKOBJREF_TARGET_ELEMENT(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x0d, 0x01, 0x03, 0x01, 0x01, 0x01, 0x01, 0x00)
    );
    WEAKOBJREF_TARGET_ELEMENT(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x07, 0x07, 0x00, 0x00, 0x00)
    );

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_ContentStorageStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x18, 0x00)
);

RECORD_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"AUID",
    NULL
);

    RECORD_MEMBER(
        L"Data1",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"Data2",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"Data3",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"Data4",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00)
    );

SET_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"AUIDSet",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
);

ENUM_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"Boolean",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
);

    ENUM_ELEMENT(
        L"False",
        0
    );
    ENUM_ELEMENT(
        L"True",
        1
    );

VARARRAY_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_OperationDefinitionWeakReferenceVector",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00)
);

VARARRAY_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_ComponentStrongReferenceVector",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00)
);

INTEGER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"aafUInt16",
    NULL,
    2,
    0
);

RECORD_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"ProductVersion",
    NULL
);

    RECORD_MEMBER(
        L"major",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"minor",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"tertiary",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"patchLevel",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"type",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00)
    );

FIXEDARRAY_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"aafUInt8Array12",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
    12
);

WEAKOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"ContainerDefinitionWeakReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00)
);

    WEAKOBJREF_TARGET_ELEMENT(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x0d, 0x01, 0x03, 0x01, 0x01, 0x02, 0x01, 0x00)
    );
    WEAKOBJREF_TARGET_ELEMENT(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x02, 0x02, 0x00, 0x00)
    );
    WEAKOBJREF_TARGET_ELEMENT(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x05, 0x08, 0x00, 0x00)
    );

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_DictionaryStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x22, 0x00)
);

RECORD_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"MobIDType",
    NULL
);

    RECORD_MEMBER(
        L"SMPTELabel",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"length",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"instanceHigh",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"instanceMid",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"instanceLow",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"material",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
    );

SET_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_CodecDefinitionStrongReferenceSet",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00)
);

CHARACTER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"Character",
    NULL
);

STRING_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"aafString",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x10, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
);

STREAM_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x10, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"Stream",
    NULL
);

INTEGER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"aafUInt32",
    NULL,
    4,
    0
);

RECORD_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"VersionType",
    NULL
);

    RECORD_MEMBER(
        L"major",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"minor",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00)
    );

VARARRAY_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"aafInt32Array",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00)
);

WEAKOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"DataDefinitionWeakReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1b, 0x00)
);

    WEAKOBJREF_TARGET_ELEMENT(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x0d, 0x01, 0x03, 0x01, 0x01, 0x02, 0x01, 0x00)
    );
    WEAKOBJREF_TARGET_ELEMENT(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x02, 0x02, 0x00, 0x00)
    );
    WEAKOBJREF_TARGET_ELEMENT(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x05, 0x05, 0x00, 0x00)
    );

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_EssenceDescriptorStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x24, 0x00)
);

VARARRAY_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_DataDefinitionWeakReferenceVector",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00)
);

SET_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_ContainerDefinitionStrongReferenceSet",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00)
);

VARARRAY_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_IdentificationStrongReferenceVector",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00)
);

INDIRECT_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x10, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"aafIndirect",
    NULL
);

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_NetworkLocatorStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x32, 0x00)
);

SET_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_DataDefinitionStrongReferenceSet",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00)
);

VARARRAY_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x06, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_LocatorStrongReferenceVector",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00)
);

INDIRECT_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x10, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"aafOpaque",
    NULL
);

INTEGER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"aafInt8",
    NULL,
    1,
    1
);

RECORD_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"DateStruct",
    NULL
);

    RECORD_MEMBER(
        L"year",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"month",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"day",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
    );

SET_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_EssenceDataStrongReferenceSet",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00)
);

VARARRAY_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_MobSlotStrongReferenceVector",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00)
);

INTEGER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"aafInt16",
    NULL,
    2,
    1
);

RECORD_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"TimeStruct",
    NULL
);

    RECORD_MEMBER(
        L"hour",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"minute",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"second",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"fraction",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
    );

VARARRAY_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"aafAUIDArray",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
);

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_SegmentStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00)
);

SET_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_InterpolationDefinitionStrongReferenceSet",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00)
);

INTEGER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"aafInt32",
    NULL,
    4,
    1
);

RECORD_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"TimeStamp",
    NULL
);

    RECORD_MEMBER(
        L"date",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"time",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00)
    );

WEAKOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"OperationDefinitionWeakReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1c, 0x00)
);

    WEAKOBJREF_TARGET_ELEMENT(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x0d, 0x01, 0x03, 0x01, 0x01, 0x02, 0x01, 0x00)
    );
    WEAKOBJREF_TARGET_ELEMENT(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x02, 0x02, 0x00, 0x00)
    );
    WEAKOBJREF_TARGET_ELEMENT(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x05, 0x03, 0x00, 0x00)
    );

SET_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_MobStrongReferenceSet",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00)
);

INTEGER_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"aafInt64",
    NULL,
    8,
    1
);

FIXEDARRAY_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"aafUInt8Array8",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
    8
);

WEAKOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"ParameterDefinitionWeakReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1d, 0x00)
);

    WEAKOBJREF_TARGET_ELEMENT(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x0d, 0x01, 0x03, 0x01, 0x01, 0x02, 0x01, 0x00)
    );
    WEAKOBJREF_TARGET_ELEMENT(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x02, 0x02, 0x00, 0x00)
    );
    WEAKOBJREF_TARGET_ELEMENT(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x05, 0x04, 0x00, 0x00)
    );

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_SourceReferenceStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x10, 0x00)
);

SET_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_OperationDefinitionStrongReferenceSet",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00)
);

VARARRAY_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x06, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_TaggedValueStrongReferenceVector",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00)
);

VARARRAY_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x04, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"aafUInt32Array",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00)
);

WEAKOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"TypeDefinitionWeakReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x02, 0x03, 0x00, 0x00)
);

    WEAKOBJREF_TARGET_ELEMENT(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x0d, 0x01, 0x03, 0x01, 0x01, 0x01, 0x01, 0x00)
    );
    WEAKOBJREF_TARGET_ELEMENT(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x07, 0x08, 0x00, 0x00, 0x00)
    );

SET_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_ParameterDefinitionStrongReferenceSet",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00)
);

VARARRAY_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x06, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_KLVDataStrongReferenceVector",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00)
);

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_CodecDefinitionStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00)
);

SET_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_PluginDefinitionStrongReferenceSet",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00)
);

WEAKOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"CodecDefinitionWeakReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1f, 0x00)
);

    WEAKOBJREF_TARGET_ELEMENT(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x0d, 0x01, 0x03, 0x01, 0x01, 0x02, 0x01, 0x00)
    );
    WEAKOBJREF_TARGET_ELEMENT(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x02, 0x02, 0x00, 0x00)
    );
    WEAKOBJREF_TARGET_ELEMENT(
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02, 0x06, 0x01, 0x01, 0x04, 0x05, 0x07, 0x00, 0x00)
    );

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_ComponentStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00)
);

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_ContainerDefinitionStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x20, 0x00)
);

SET_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x0d, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_KLVDataDefinitionStrongReferenceSet",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00)
);

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_DataDefinitionStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1b, 0x00)
);

SET_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x03, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_ParameterDefinitionWeakReferenceSet",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00)
);

SET_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x05, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_TaggedValueDefinitionStrongReferenceSet",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00)
);

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_EssenceDataStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x23, 0x00)
);

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_IdentificationStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30, 0x00)
);

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_InterpolationDefinitionStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x21, 0x00)
);

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_LocatorStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x31, 0x00)
);

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x13, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_MobStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x34, 0x00)
);

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_MobSlotStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x38, 0x00)
);

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_OperationDefinitionStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1c, 0x00)
);

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_ParameterDefinitionStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1d, 0x00)
);

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_PluginDefinitionStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1e, 0x00)
);

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_TaggedValueStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3f, 0x00)
);

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_KLVDataStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x40, 0x00)
);

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_KLVDataDefinitionStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4d, 0x00)
);

STRONGOBJREF_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x05, 0x02, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00),
    L"kAAFTypeID_TaggedValueDefinitionStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4c, 0x00)
);

ENUM_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00),
    L"ProductReleaseType",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
);

    ENUM_ELEMENT(
        L"VersionUnknown",
        0
    );
    ENUM_ELEMENT(
        L"VersionReleased",
        1
    );
    ENUM_ELEMENT(
        L"VersionDebug",
        2
    );
    ENUM_ELEMENT(
        L"VersionPatched",
        3
    );
    ENUM_ELEMENT(
        L"VersionBeta",
        4
    );
    ENUM_ELEMENT(
        L"VersionPrivateBuild",
        5
    );

EXTENUM_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x02, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00),
    L"OperationCategoryType",
    NULL);

    EXTENUM_ELEMENT(
        L"OperationCategory_Effect",
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x00)
    );

RENAME_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x20, 0x01, 0x00, 0x00, 0x00, 0x00),
    L"aafPositionType",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00)
);

ENUM_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00),
    L"TapeFormatType",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
);

    ENUM_ELEMENT(
        L"TapeFormatNull",
        0
    );
    ENUM_ELEMENT(
        L"BetacamFormat",
        1
    );
    ENUM_ELEMENT(
        L"BetacamSPFormat",
        2
    );
    ENUM_ELEMENT(
        L"VHSFormat",
        3
    );
    ENUM_ELEMENT(
        L"SVHSFormat",
        4
    );
    ENUM_ELEMENT(
        L"8mmFormat",
        5
    );
    ENUM_ELEMENT(
        L"Hi8Format",
        6
    );

EXTENUM_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x02, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00),
    L"TransferCharacteristicType",
    NULL);

    EXTENUM_ELEMENT(
        L"TransferCharacteristic_ITU470_PAL",
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00)
    );
    EXTENUM_ELEMENT(
        L"TransferCharacteristic_ITU709",
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00)
    );
    EXTENUM_ELEMENT(
        L"TransferCharacteristic_SMPTE240M",
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00)
    );
    EXTENUM_ELEMENT(
        L"TransferCharacteristic_274M_296M",
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x04, 0x00, 0x00)
    );
    EXTENUM_ELEMENT(
        L"TransferCharacteristic_ITU1361",
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x05, 0x00, 0x00)
    );
    EXTENUM_ELEMENT(
        L"TransferCharacteristic_linear",
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x06, 0x00, 0x00)
    );

RENAME_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x20, 0x02, 0x00, 0x00, 0x00, 0x00),
    L"aafLengthType",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00)
);

ENUM_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00),
    L"VideoSignalType",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
);

    ENUM_ELEMENT(
        L"VideoSignalNull",
        0
    );
    ENUM_ELEMENT(
        L"NTSCSignal",
        1
    );
    ENUM_ELEMENT(
        L"PALSignal",
        2
    );

EXTENUM_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x02, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00),
    L"PluginCategoryType",
    NULL);

    EXTENUM_ELEMENT(
        L"PluginCategory_Effect",
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x02, 0x01, 0x01, 0x02, 0x00)
    );
    EXTENUM_ELEMENT(
        L"PluginCategory_Codec",
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x02, 0x01, 0x01, 0x03, 0x00)
    );
    EXTENUM_ELEMENT(
        L"PluginCategory_Interpolation",
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x02, 0x01, 0x01, 0x04, 0x00)
    );

ENUM_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00),
    L"TapeCaseType",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
);

    ENUM_ELEMENT(
        L"TapeCaseNull",
        0
    );
    ENUM_ELEMENT(
        L"ThreeFourthInchVideoTape",
        1
    );
    ENUM_ELEMENT(
        L"VHSVideoTape",
        2
    );
    ENUM_ELEMENT(
        L"8mmVideoTape",
        3
    );
    ENUM_ELEMENT(
        L"BetacamVideoTape",
        4
    );
    ENUM_ELEMENT(
        L"CompactCassette",
        5
    );
    ENUM_ELEMENT(
        L"DATCartridge",
        6
    );
    ENUM_ELEMENT(
        L"NagraAudioTape",
        7
    );

EXTENUM_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00),
    L"UsageType",
    NULL);

    EXTENUM_ELEMENT(
        L"Usage_SubClip",
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x02, 0x01, 0x01, 0x05, 0x00)
    );
    EXTENUM_ELEMENT(
        L"Usage_AdjustedClip",
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x02, 0x01, 0x01, 0x06, 0x00)
    );
    EXTENUM_ELEMENT(
        L"Usage_TopLevel",
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x02, 0x01, 0x01, 0x07, 0x00)
    );
    EXTENUM_ELEMENT(
        L"Usage_LowerLevel",
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x02, 0x01, 0x01, 0x08, 0x00)
    );
    EXTENUM_ELEMENT(
        L"Usage_Template",
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x02, 0x01, 0x01, 0x09, 0x00)
    );

ENUM_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00),
    L"ColorSitingType",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
);

    ENUM_ELEMENT(
        L"CoSiting",
        0
    );
    ENUM_ELEMENT(
        L"Averaging",
        1
    );
    ENUM_ELEMENT(
        L"ThreeTap",
        2
    );
    ENUM_ELEMENT(
        L"Quincunx",
        3
    );
    ENUM_ELEMENT(
        L"Rec601",
        4
    );
    ENUM_ELEMENT(
        L"UnknownSiting",
        255
    );

EXTENUM_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00),
    L"ColorPrimariesType",
    NULL);

    EXTENUM_ELEMENT(
        L"ColorPrimaries_SMPTE170M",
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x06, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00)
    );
    EXTENUM_ELEMENT(
        L"ColorPrimaries_ITU470_PAL",
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x06, 0x04, 0x01, 0x01, 0x01, 0x03, 0x02, 0x00, 0x00)
    );
    EXTENUM_ELEMENT(
        L"ColorPrimaries_ITU709",
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x06, 0x04, 0x01, 0x01, 0x01, 0x03, 0x03, 0x00, 0x00)
    );

EXTENUM_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x02, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00),
    L"CodingEquationsType",
    NULL);

    EXTENUM_ELEMENT(
        L"CodingEquations_ITU601",
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x02, 0x01, 0x00, 0x00)
    );
    EXTENUM_ELEMENT(
        L"CodingEquations_ITU709",
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x02, 0x02, 0x00, 0x00)
    );
    EXTENUM_ELEMENT(
        L"CodingEquations_SMPTE240M",
        LABEL(0x06, 0x0e, 0x2b, 0x34, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x01, 0x01, 0x02, 0x03, 0x00, 0x00)
    );

ENUM_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x07, 0x00, 0x00, 0x00, 0x00),
    L"FadeType",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
);

    ENUM_ELEMENT(
        L"FadeNone",
        0
    );
    ENUM_ELEMENT(
        L"FadeLinearAmp",
        1
    );
    ENUM_ELEMENT(
        L"FadeLinearPower",
        2
    );

ENUM_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x08, 0x00, 0x00, 0x00, 0x00),
    L"LayoutType",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
);

    ENUM_ELEMENT(
        L"FullFrame",
        0
    );
    ENUM_ELEMENT(
        L"SeparateFields",
        1
    );
    ENUM_ELEMENT(
        L"OneField",
        2
    );
    ENUM_ELEMENT(
        L"MixedFields",
        3
    );
    ENUM_ELEMENT(
        L"SegmentedFrame",
        4
    );

STRONGOBJREF_DEF(
    LABEL(0xa0, 0x44, 0x00, 0x60, 0x94, 0xeb, 0x75, 0xcb, 0xf9, 0xa7, 0x4d, 0x0a, 0x7b, 0x30, 0x11, 0xd3),
    L"AvidStrongReference",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00)
);

ENUM_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00),
    L"AlphaTransparencyType",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
);

    ENUM_ELEMENT(
        L"MinValueTransparent",
        0
    );
    ENUM_ELEMENT(
        L"MaxValueTransparent",
        1
    );

ENUM_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x21, 0x00, 0x00, 0x00, 0x00),
    L"FieldNumber",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
);

    ENUM_ELEMENT(
        L"UnspecifiedField",
        0
    );
    ENUM_ELEMENT(
        L"FieldOne",
        1
    );
    ENUM_ELEMENT(
        L"FieldTwo",
        2
    );

ENUM_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x22, 0x00, 0x00, 0x00, 0x00),
    L"ElectroSpatialFormulation",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
);

    ENUM_ELEMENT(
        L"ElectroSpatialFormulation_Default",
        0
    );
    ENUM_ELEMENT(
        L"ElectroSpatialFormulation_TwoChannelMode",
        1
    );
    ENUM_ELEMENT(
        L"ElectroSpatialFormulation_SingleChannelMode",
        2
    );
    ENUM_ELEMENT(
        L"ElectroSpatialFormulation_PrimarySecondaryMode",
        3
    );
    ENUM_ELEMENT(
        L"ElectroSpatialFormulation_StereophonicMode",
        4
    );
    ENUM_ELEMENT(
        L"ElectroSpatialFormulation_SingleChannelDoubleSamplingFrequencyMode",
        7
    );
    ENUM_ELEMENT(
        L"ElectroSpatialFormulation_StereoLeftChannelDoubleSamplingFrequencyMode",
        8
    );
    ENUM_ELEMENT(
        L"ElectroSpatialFormulation_StereoRightChannelDoubleSamplingFrequencyMode",
        9
    );
    ENUM_ELEMENT(
        L"ElectroSpatialFormulation_MultiChannelMode",
        15
    );

ENUM_DEF(
    LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x02, 0x01, 0x01, 0x27, 0x00, 0x00, 0x00, 0x00),
    L"SignalStandardType",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
);

    ENUM_ELEMENT(
        L"SignalStandard_None",
        0
    );
    ENUM_ELEMENT(
        L"SignalStandard_ITU601",
        1
    );
    ENUM_ELEMENT(
        L"SignalStandard_ITU1358",
        2
    );
    ENUM_ELEMENT(
        L"SignalStandard_SMPTE347M",
        3
    );
    ENUM_ELEMENT(
        L"SignalStandard_SMPTE274M",
        4
    );
    ENUM_ELEMENT(
        L"SignalStandard_SMPTE296M",
        5
    );
    ENUM_ELEMENT(
        L"SignalStandard_SMPTE349M",
        6
    );

FIXEDARRAY_DEF(
    LABEL(0x80, 0xcf, 0x00, 0x60, 0x08, 0x14, 0x3e, 0x6f, 0x8b, 0xc4, 0x27, 0x2e, 0x6b, 0xab, 0x11, 0xd3),
    L"AvidPosition",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
    24
);

FIXEDARRAY_DEF(
    LABEL(0x80, 0xcf, 0x00, 0x60, 0x08, 0x14, 0x3e, 0x6f, 0x8b, 0xc4, 0x27, 0x2f, 0x6b, 0xab, 0x11, 0xd3),
    L"AvidCrop",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
    32
);

FIXEDARRAY_DEF(
    LABEL(0x80, 0xcf, 0x00, 0x60, 0x08, 0x14, 0x3e, 0x6f, 0x8b, 0xc4, 0x27, 0x30, 0x6b, 0xab, 0x11, 0xd3),
    L"AvidScale",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
    16
);

FIXEDARRAY_DEF(
    LABEL(0x80, 0xcf, 0x00, 0x60, 0x08, 0x14, 0x3e, 0x6f, 0x8b, 0xc4, 0x27, 0x31, 0x6b, 0xab, 0x11, 0xd3),
    L"AvidSpillSupress",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
    8
);

FIXEDARRAY_DEF(
    LABEL(0x80, 0xcf, 0x00, 0x60, 0x08, 0x14, 0x3e, 0x6f, 0x8b, 0xc4, 0x27, 0x32, 0x6b, 0xab, 0x11, 0xd3),
    L"AvidBounds",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
    48
);

FIXEDARRAY_DEF(
    LABEL(0x80, 0xcf, 0x00, 0x60, 0x08, 0x14, 0x3e, 0x6f, 0x8b, 0xc4, 0x27, 0x33, 0x6b, 0xab, 0x11, 0xd3),
    L"AvidColor",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
    68
);

FIXEDARRAY_DEF(
    LABEL(0xa0, 0x0f, 0x00, 0x04, 0xac, 0x96, 0x9f, 0x50, 0x0f, 0x96, 0xcb, 0x41, 0x2a, 0xa8, 0x11, 0xd4),
    L"AvidString4",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
    4
);

RECORD_DEF(
    LABEL(0xa0, 0x69, 0x00, 0x60, 0x94, 0xeb, 0x75, 0xcb, 0xe9, 0x6e, 0x6d, 0x43, 0xc3, 0x83, 0x11, 0xd3),
    L"RGBColor",
    NULL
);

    RECORD_MEMBER(
        L"red",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"green",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"blue",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00)
    );

FIXEDARRAY_DEF(
    LABEL(0x9f, 0xf5, 0x00, 0x04, 0xac, 0x96, 0x9f, 0x50, 0x32, 0x71, 0xa3, 0x4f, 0xf3, 0xa1, 0x11, 0xd3),
    L"AvidWideString32",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00),
    32
);

RECORD_DEF(
    LABEL(0x9f, 0xf5, 0x00, 0x04, 0xac, 0x96, 0x9f, 0x50, 0x4e, 0x4d, 0x8f, 0x5f, 0xee, 0xfd, 0x11, 0xd3),
    L"AudioSuitePlugInChunk",
    NULL
);

    RECORD_MEMBER(
        L"Version",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"ManufacturerID",
        WEAKREF(0xa0, 0x0f, 0x00, 0x04, 0xac, 0x96, 0x9f, 0x50, 0x0f, 0x96, 0xcb, 0x41, 0x2a, 0xa8, 0x11, 0xd4)
    );
    RECORD_MEMBER(
        L"ProductID",
        WEAKREF(0xa0, 0x0f, 0x00, 0x04, 0xac, 0x96, 0x9f, 0x50, 0x0f, 0x96, 0xcb, 0x41, 0x2a, 0xa8, 0x11, 0xd4)
    );
    RECORD_MEMBER(
        L"PlugInID",
        WEAKREF(0xa0, 0x0f, 0x00, 0x04, 0xac, 0x96, 0x9f, 0x50, 0x0f, 0x96, 0xcb, 0x41, 0x2a, 0xa8, 0x11, 0xd4)
    );
    RECORD_MEMBER(
        L"ChunkID",
        WEAKREF(0xa0, 0x0f, 0x00, 0x04, 0xac, 0x96, 0x9f, 0x50, 0x0f, 0x96, 0xcb, 0x41, 0x2a, 0xa8, 0x11, 0xd4)
    );
    RECORD_MEMBER(
        L"Name",
        WEAKREF(0x9f, 0xf5, 0x00, 0x04, 0xac, 0x96, 0x9f, 0x50, 0x32, 0x71, 0xa3, 0x4f, 0xf3, 0xa1, 0x11, 0xd3)
    );
    RECORD_MEMBER(
        L"ChunkDataUID",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
    );

VARARRAY_DEF(
    LABEL(0x9f, 0xf5, 0x00, 0x04, 0xac, 0x96, 0x9f, 0x50, 0x4e, 0x4d, 0x8f, 0x60, 0xee, 0xfd, 0x11, 0xd3),
    L"AudioSuitePIChunkArray",
    NULL,
    WEAKREF(0x9f, 0xf5, 0x00, 0x04, 0xac, 0x96, 0x9f, 0x50, 0x4e, 0x4d, 0x8f, 0x5f, 0xee, 0xfd, 0x11, 0xd3)
);

VARARRAY_DEF(
    LABEL(0x9f, 0xf7, 0x00, 0x04, 0xac, 0x96, 0x9f, 0x50, 0xb5, 0x6a, 0x2e, 0xc2, 0xfc, 0x3b, 0x11, 0xd3),
    L"AvidTKMNTrackedParamArray",
    NULL,
    WEAKREF(0xa0, 0x44, 0x00, 0x60, 0x94, 0xeb, 0x75, 0xcb, 0xf9, 0xa7, 0x4d, 0x0a, 0x7b, 0x30, 0x11, 0xd3)
);

VARARRAY_DEF(
    LABEL(0x9f, 0xf7, 0x00, 0x04, 0xac, 0x96, 0x9f, 0x50, 0xb5, 0x6a, 0x2e, 0xc3, 0xfc, 0x3b, 0x11, 0xd3),
    L"AvidTKMNTrackerDataArray",
    NULL,
    WEAKREF(0xa0, 0x44, 0x00, 0x60, 0x94, 0xeb, 0x75, 0xcb, 0xf9, 0xa7, 0x4d, 0x0a, 0x7b, 0x30, 0x11, 0xd3)
);

RECORD_DEF(
    LABEL(0x80, 0xe9, 0x00, 0x60, 0x08, 0x14, 0x3e, 0x6f, 0xc4, 0xc6, 0x70, 0xc9, 0xbd, 0x44, 0x11, 0xd3),
    L"EqualizationBand",
    NULL
);

    RECORD_MEMBER(
        L"type",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"frequency",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"gain",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"q",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00)
    );
    RECORD_MEMBER(
        L"enable",
        WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
    );

VARARRAY_DEF(
    LABEL(0x80, 0xe9, 0x00, 0x60, 0x08, 0x14, 0x3e, 0x6f, 0xc4, 0xc6, 0x70, 0xca, 0xbd, 0x44, 0x11, 0xd3),
    L"EqualizationBandArray",
    NULL,
    WEAKREF(0x80, 0xe9, 0x00, 0x60, 0x08, 0x14, 0x3e, 0x6f, 0xc4, 0xc6, 0x70, 0xc9, 0xbd, 0x44, 0x11, 0xd3)
);

VARARRAY_DEF(
    LABEL(0xa0, 0x81, 0x00, 0x60, 0x94, 0xeb, 0x75, 0xcb, 0xcc, 0xaa, 0x73, 0xd1, 0xf5, 0x38, 0x11, 0xd3),
    L"AvidBagOfBits",
    NULL,
    WEAKREF(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x04, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00)
);





#undef LABEL
#undef LABEL_2
#undef WEAKREF
#undef CLASS_DEF
#undef PROPERTY_DEF
#undef CHARACTER_DEF
#undef ENUM_DEF
#undef ENUM_ELEMENT
#undef EXTENUM_DEF
#undef EXTENUM_ELEMENT
#undef FIXEDARRAY_DEF
#undef INDIRECT_DEF
#undef INTEGER_DEF
#undef OPAQUE_DEF
#undef RENAME_DEF
#undef RECORD_DEF
#undef RECORD_MEMBER
#undef SET_DEF
#undef STREAM_DEF
#undef STRING_DEF
#undef STRONGOBJREF_DEF
#undef WEAKOBJREF_DEF
#undef WEAKOBJREF_TARGET_ELEMENT
#undef VARARRAY_DEF

