//=---------------------------------------------------------------------=
//
// $Id$ $Name$
//
// The contents of this file are subject to the AAF SDK Public Source
// License Agreement Version 2.0 (the "License"); You may not use this
// file except in compliance with the License.  The License is available
// in AAFSDKPSL.TXT, or you may obtain a copy of the License from the
// Advanced Media Workflow Association, Inc., or its successor.
//
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See
// the License for the specific language governing rights and limitations
// under the License.  Refer to Section 3.3 of the License for proper use
// of this Exhibit.
//
// WARNING:  Please contact the Advanced Media Workflow Association,
// Inc., for more information about any additional licenses to
// intellectual property covering the AAF Standard that may be required
// to create and distribute AAF compliant products.
// (http://www.amwa.tv/policies).
//
// Copyright Notices:
// The Original Code of this file is Copyright 1998-2009, licensor of the
// Advanced Media Workflow Association.  All rights reserved.
//
// The Initial Developer of the Original Code of this file and the
// licensor of the Advanced Media Workflow Association is
// Avid Technology.
// All rights reserved.
//
//=---------------------------------------------------------------------=

// This is an automatically generated file.
//
// Source data (xmldict.xml) by BBC R&D, Matt Beard and Metaglue Corporation.
//
// Meta definition of the MXF object model.
//
// This file was generated on Fri Aug 12 15:44:31 EDT 2005

//
// MXF_LABEL(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
//
//   Define an MXF label. 
//
//    a         = label octet a
//    b         = label octet b
//    c         = label octet c
//    d         = label octet d
//    e         = label octet e
//    f         = label octet f
//    g         = label octet g
//    h         = label octet h
//    i         = label octet i
//    j         = label octet j
//    k         = label octet k
//    l         = label octet l
//    m         = label octet m
//    n         = label octet n
//    o         = label octet o
//    p         = label octet p
//
//
// MXF_DEFINE_KEY(n, k)
//
//   Define an MXF key 
//
//    n         = name
//    k         = key
//
//
// MXF_DEFINE_PACK_KEY(n, k)
//
//   Define an MXF pack key 
//
//    n         = name
//    k         = key
//
//
// MXF_TABLE_BEGIN()
//
//   Begin a table of MXF class and property definitions. 
//
//
//
// MXF_TABLE_END()
//
//   End a table of MXF class and property definitions. 
//
//
//
// MXF_CLASS(name, id, parent, concrete)
//
//   Define an MXF class. 
//
//    name      = the name of the class
//    id        = the uid used to identify the class
//    parent    = the immediate ancestor class
//    concrete  = true if the class is concrete
//                false if the class is abstract
//
//
// MXF_CLASS_END(name, id, parent, concrete)
//
//   End an MXF class definition. 
//
//    name      = the name of the class
//    id        = the uid used to identify the class
//    parent    = the immediate ancestor class
//    concrete  = true if the class is concrete
//                false if the class is abstract
//
//
// MXF_CLASS_SEPARATOR()
//
//   Separate one MXF class definition from another. 
//
//
//
// MXF_PROPERTY(name, id, tag, type, mandatory, isuid, container)
//
//   Define an MXF property. 
//
//    name      = the name of the property
//    id        = the uid used to identify the property
//    tag       = the short form of the id
//    type      = the type of the property
//    mandatory = true if the property is mandatory
//                false if the property is optional
//    isuid     = true if the property is the unique identifier
//                for this class, false if the property is not
//                the unique identifier for this class
//    container = the class that defines this property
//

#ifndef MXF_LABEL
#define MXF_LABEL(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
#endif

#ifndef MXF_DEFINE_KEY
#define MXF_DEFINE_KEY(n, k)
#endif

#ifndef MXF_DEFINE_PACK_KEY
#define MXF_DEFINE_PACK_KEY(n, k)
#endif

#ifndef MXF_TABLE_BEGIN
#define MXF_TABLE_BEGIN()
#endif

#ifndef MXF_TABLE_END
#define MXF_TABLE_END()
#endif

#ifndef MXF_CLASS
#define MXF_CLASS(name, id, parent, concrete)
#endif

#ifndef MXF_CLASS_END
#define MXF_CLASS_END(name, id, parent, concrete)
#endif

#ifndef MXF_CLASS_SEPARATOR
#define MXF_CLASS_SEPARATOR()
#endif

#ifndef MXF_PROPERTY
#define MXF_PROPERTY(name, id, tag, type, mandatory, isuid, container)
#endif

// ================= MXF Pack Labels ==================
//

// Open Header Partition Pack
//
// 06.0e.2b.34.02.05.01.01.0d.01.02.01.01.02.01.00
MXF_DEFINE_PACK_KEY(OpenIncompleteHeader,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01,
            0x0d, 0x01, 0x02, 0x01, 0x01, 0x02, 0x01, 0x00))

// Open Complete Header Partition Pack
//
// 06.0e.2b.34.02.05.01.01.0d.01.02.01.01.02.03.00
MXF_DEFINE_PACK_KEY(OpenHeader,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01,
            0x0d, 0x01, 0x02, 0x01, 0x01, 0x02, 0x03, 0x00))

// Closed Header Partition Pack
//
// 06.0e.2b.34.02.05.01.01.0d.01.02.01.01.02.02.00
MXF_DEFINE_PACK_KEY(IncompleteHeader,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01,
            0x0d, 0x01, 0x02, 0x01, 0x01, 0x02, 0x02, 0x00))

// Closed Complete Header Partition Pack
//
// 06.0e.2b.34.02.05.01.01.0d.01.02.01.01.02.04.00
MXF_DEFINE_PACK_KEY(Header,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01,
            0x0d, 0x01, 0x02, 0x01, 0x01, 0x02, 0x04, 0x00))

// Open Body Partition Pack
//
// 06.0e.2b.34.02.05.01.01.0d.01.02.01.01.03.01.00
MXF_DEFINE_PACK_KEY(OpenIncompleteBody,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01,
            0x0d, 0x01, 0x02, 0x01, 0x01, 0x03, 0x01, 0x00))

// Open Complete Body Partition Pack
//
// 06.0e.2b.34.02.05.01.01.0d.01.02.01.01.03.03.00
MXF_DEFINE_PACK_KEY(OpenBody,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01,
            0x0d, 0x01, 0x02, 0x01, 0x01, 0x03, 0x03, 0x00))

// Closed Body Partition Pack
//
// 06.0e.2b.34.02.05.01.01.0d.01.02.01.01.03.02.00
MXF_DEFINE_PACK_KEY(IncompleteBody,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01,
            0x0d, 0x01, 0x02, 0x01, 0x01, 0x03, 0x02, 0x00))

// Closed Complete Body Partition Pack
//
// 06.0e.2b.34.02.05.01.01.0d.01.02.01.01.03.04.00
MXF_DEFINE_PACK_KEY(Body,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01,
            0x0d, 0x01, 0x02, 0x01, 0x01, 0x03, 0x04, 0x00))

// Footer Partition Pack
//
// 06.0e.2b.34.02.05.01.01.0d.01.02.01.01.04.02.00
MXF_DEFINE_PACK_KEY(IncompleteFooter,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01,
            0x0d, 0x01, 0x02, 0x01, 0x01, 0x04, 0x02, 0x00))

// Complete Footer Partition Pack
//
// 06.0e.2b.34.02.05.01.01.0d.01.02.01.01.04.04.00
MXF_DEFINE_PACK_KEY(Footer,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01,
            0x0d, 0x01, 0x02, 0x01, 0x01, 0x04, 0x04, 0x00))

// Primer Pack
//
// 06.0e.2b.34.02.05.01.01.0d.01.02.01.01.05.01.00
MXF_DEFINE_PACK_KEY(Primer,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01,
            0x0d, 0x01, 0x02, 0x01, 0x01, 0x05, 0x01, 0x00))

// Random Index Pack
//
// 06.0e.2b.34.02.05.01.01.0d.01.02.01.01.11.01.00
MXF_DEFINE_PACK_KEY(RandomIndexMetadata,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x05, 0x01, 0x01,
            0x0d, 0x01, 0x02, 0x01, 0x01, 0x11, 0x01, 0x00))

// KLV Filler packet
//
// 06.0E.2B.34.01.01.01.02.03.01.02.10.01.00.00.00
MXF_DEFINE_KEY(KLVFill,
  MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x01, 0x01, 0x01, 0x02,
            0x03, 0x01, 0x02, 0x10, 0x01, 0x00, 0x00, 0x00))

// A segment of an Index Table
//
// 06.0e.2b.34.02.53.01.01.0d.01.02.01.01.10.01.00
MXF_DEFINE_KEY(IndexTableSegment,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x02, 0x01, 0x01, 0x10, 0x01, 0x00))

// ================= MXF Object Model =================
//

MXF_TABLE_BEGIN()

// InterchangeObject
//
MXF_CLASS(InterchangeObject,
  // 06.0E.2B.34.02.53.01.01.0D.01.01.01.01.01.01.00
  MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00),
  Root,
  false)
  MXF_PROPERTY(InstanceUID,
    // 06.0e.2b.34.01.01.01.01.01.01.15.02.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x01, 0x01, 0x15, 0x02, 0x00, 0x00, 0x00, 0x00),
    0x3c0a,
    UUID,
    required,
    false,
    InterchangeObject)
  MXF_PROPERTY(GenerationUID,
    // 06.0e.2b.34.01.01.01.02.05.20.07.01.08.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x05, 0x20, 0x07, 0x01, 0x08, 0x00, 0x00, 0x00),
    0x0102,
    UUID,
    optional,
    false,
    InterchangeObject)
MXF_CLASS_END(InterchangeObject,
  MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00),
  Root,
  false)
MXF_CLASS_SEPARATOR()

// Preface Set
//
MXF_CLASS(Preface,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.2f.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2f, 0x00),
  InterchangeObject,
  true)
  MXF_PROPERTY(LastModifiedDate,
    // 06.0e.2b.34.01.01.01.02.07.02.01.10.02.04.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x07, 0x02, 0x01, 0x10, 0x02, 0x04, 0x00, 0x00),
    0x3b02,
    Timestamp,
    required,
    false,
    Preface)
  MXF_PROPERTY(Version,
    // 06.0e.2b.34.01.01.01.02.03.01.02.01.05.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x03, 0x01, 0x02, 0x01, 0x05, 0x00, 0x00, 0x00),
    0x3b05,
    VersionType,
    required,
    false,
    Preface)
  MXF_PROPERTY(ObjectModelVersion,
    // 06.0e.2b.34.01.01.01.02.03.01.02.01.04.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x03, 0x01, 0x02, 0x01, 0x04, 0x00, 0x00, 0x00),
    0x3b07,
    UInt32,
    optional,
    false,
    Preface)
  MXF_PROPERTY(PrimaryPackage,
    // 06.0e.2b.34.01.01.01.04.06.01.01.04.01.08.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04,
              0x06, 0x01, 0x01, 0x04, 0x01, 0x08, 0x00, 0x00),
    0x3b08,
    UUID,
    optional,
    false,
    Preface)
  MXF_PROPERTY(Identifications,
    // 06.0e.2b.34.01.01.01.02.06.01.01.04.06.04.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x06, 0x01, 0x01, 0x04, 0x06, 0x04, 0x00, 0x00),
    0x3b06,
    subVector,
    encoderRequired,
    false,
    Preface)
  MXF_PROPERTY(ContentStorage,
    // 06.0e.2b.34.01.01.01.02.06.01.01.04.02.01.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x06, 0x01, 0x01, 0x04, 0x02, 0x01, 0x00, 0x00),
    0x3b03,
    UUID,
    required,
    false,
    Preface)
  MXF_PROPERTY(OperationalPattern,
    // 06.0e.2b.34.01.01.01.05.01.02.02.03.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x01, 0x02, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00),
    0x3b09,
    Label,
    required,
    false,
    Preface)
  MXF_PROPERTY(EssenceContainers,
    // 06.0e.2b.34.01.01.01.05.01.02.02.10.02.01.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x01, 0x02, 0x02, 0x10, 0x02, 0x01, 0x00, 0x00),
    0x3b0a,
    subVector,
    required,
    false,
    Preface)
  MXF_PROPERTY(DMSchemes,
    // 06.0e.2b.34.01.01.01.05.01.02.02.10.02.02.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x01, 0x02, 0x02, 0x10, 0x02, 0x02, 0x00, 0x00),
    0x3b0b,
    subVector,
    required,
    false,
    Preface)
MXF_CLASS_END(Preface,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2f, 0x00),
  InterchangeObject,
  true)
MXF_CLASS_SEPARATOR()

// Identification set
//
MXF_CLASS(Identification,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.30.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30, 0x00),
  InterchangeObject,
  true)
  MXF_PROPERTY(ThisGenerationUID,
    // 06.0e.2b.34.01.01.01.02.05.20.07.01.01.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x05, 0x20, 0x07, 0x01, 0x01, 0x00, 0x00, 0x00),
    0x3c09,
    UUID,
    required,
    false,
    Identification)
  MXF_PROPERTY(CompanyName,
    // 06.0e.2b.34.01.01.01.02.05.20.07.01.02.01.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x05, 0x20, 0x07, 0x01, 0x02, 0x01, 0x00, 0x00),
    0x3c01,
    String,
    required,
    false,
    Identification)
  MXF_PROPERTY(ProductName,
    // 06.0e.2b.34.01.01.01.02.05.20.07.01.03.01.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x05, 0x20, 0x07, 0x01, 0x03, 0x01, 0x00, 0x00),
    0x3c02,
    String,
    required,
    false,
    Identification)
  MXF_PROPERTY(ProductVersion,
    // 06.0e.2b.34.01.01.01.02.05.20.07.01.04.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x05, 0x20, 0x07, 0x01, 0x04, 0x00, 0x00, 0x00),
    0x3c03,
    ProductVersion,
    optional,
    false,
    Identification)
  MXF_PROPERTY(VersionString,
    // 06.0e.2b.34.01.01.01.02.05.20.07.01.05.01.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x05, 0x20, 0x07, 0x01, 0x05, 0x01, 0x00, 0x00),
    0x3c04,
    String,
    required,
    false,
    Identification)
  MXF_PROPERTY(ProductUID,
    // 06.0e.2b.34.01.01.01.02.05.20.07.01.07.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x05, 0x20, 0x07, 0x01, 0x07, 0x00, 0x00, 0x00),
    0x3c05,
    UUID,
    required,
    false,
    Identification)
  MXF_PROPERTY(ModificationDate,
    // 06.0e.2b.34.01.01.01.02.07.02.01.10.02.03.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x07, 0x02, 0x01, 0x10, 0x02, 0x03, 0x00, 0x00),
    0x3c06,
    Timestamp,
    required,
    false,
    Identification)
  MXF_PROPERTY(ToolkitVersion,
    // 06.0e.2b.34.01.01.01.02.05.20.07.01.0a.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x05, 0x20, 0x07, 0x01, 0x0a, 0x00, 0x00, 0x00),
    0x3c07,
    ProductVersion,
    optional,
    false,
    Identification)
  MXF_PROPERTY(Platform,
    // 06.0e.2b.34.01.01.01.02.05.20.07.01.06.01.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x05, 0x20, 0x07, 0x01, 0x06, 0x01, 0x00, 0x00),
    0x3c08,
    String,
    optional,
    false,
    Identification)
MXF_CLASS_END(Identification,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x30, 0x00),
  InterchangeObject,
  true)
MXF_CLASS_SEPARATOR()

// Content Storage set
//
MXF_CLASS(ContentStorage,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.18.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x18, 0x00),
  InterchangeObject,
  true)
  MXF_PROPERTY(Packages,
    // 06.0e.2b.34.01.01.01.02.06.01.01.04.05.01.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x06, 0x01, 0x01, 0x04, 0x05, 0x01, 0x00, 0x00),
    0x1901,
    subVector,
    required,
    false,
    ContentStorage)
  MXF_PROPERTY(EssenceContainerData,
    // 06.0e.2b.34.01.01.01.02.06.01.01.04.05.02.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x06, 0x01, 0x01, 0x04, 0x05, 0x02, 0x00, 0x00),
    0x1902,
    subVector,
    optional,
    false,
    ContentStorage)
MXF_CLASS_END(ContentStorage,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x18, 0x00),
  InterchangeObject,
  true)
MXF_CLASS_SEPARATOR()

// Essence Container Data set
//
MXF_CLASS(EssenceContainerData,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.23.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x23, 0x00),
  InterchangeObject,
  true)
  MXF_PROPERTY(LinkedPackageUID,
    // 06.0e.2b.34.01.01.01.02.06.01.01.06.01.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x06, 0x01, 0x01, 0x06, 0x01, 0x00, 0x00, 0x00),
    0x2701,
    UMID,
    required,
    false,
    EssenceContainerData)
  MXF_PROPERTY(IndexSID,
    // 06.0e.2b.34.01.01.01.04.01.03.04.05.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04,
              0x01, 0x03, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00),
    0x3f06,
    UInt32,
    optional,
    false,
    EssenceContainerData)
  MXF_PROPERTY(BodySID,
    // 06.0e.2b.34.01.01.01.04.01.03.04.04.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04,
              0x01, 0x03, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00),
    0x3f07,
    UInt32,
    required,
    false,
    EssenceContainerData)
MXF_CLASS_END(EssenceContainerData,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x23, 0x00),
  InterchangeObject,
  true)
MXF_CLASS_SEPARATOR()

// Defines a Generic Package set
//
MXF_CLASS(GenericPackage,
  // 06.0E.2B.34.02.53.01.01.0D.01.01.01.01.01.34.00
  MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x34, 0x00),
  InterchangeObject,
  false)
  MXF_PROPERTY(PackageUID,
    // 06.0e.2b.34.01.01.01.01.01.01.15.10.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x01, 0x01, 0x15, 0x10, 0x00, 0x00, 0x00, 0x00),
    0x4401,
    UMID,
    required,
    false,
    GenericPackage)
  MXF_PROPERTY(Name,
    // 06.0e.2b.34.01.01.01.01.01.03.03.02.01.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x01, 0x03, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00),
    0x4402,
    String,
    optional,
    false,
    GenericPackage)
  MXF_PROPERTY(PackageCreationDate,
    // 06.0e.2b.34.01.01.01.02.07.02.01.10.01.03.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x07, 0x02, 0x01, 0x10, 0x01, 0x03, 0x00, 0x00),
    0x4405,
    Timestamp,
    required,
    false,
    GenericPackage)
  MXF_PROPERTY(PackageModifiedDate,
    // 06.0e.2b.34.01.01.01.02.07.02.01.10.02.05.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x07, 0x02, 0x01, 0x10, 0x02, 0x05, 0x00, 0x00),
    0x4404,
    Timestamp,
    required,
    false,
    GenericPackage)
  MXF_PROPERTY(Tracks,
    // 06.0e.2b.34.01.01.01.02.06.01.01.04.06.05.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x06, 0x01, 0x01, 0x04, 0x06, 0x05, 0x00, 0x00),
    0x4403,
    StrongReferenceVectorTrack,
    required,
    false,
    GenericPackage)
MXF_CLASS_END(GenericPackage,
  MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x34, 0x00),
  InterchangeObject,
  false)
MXF_CLASS_SEPARATOR()

// Locator
//
MXF_CLASS(Locator,
  // 06.0E.2B.34.02.53.01.01.0D.01.01.01.01.01.31.00
  MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x31, 0x00),
  InterchangeObject,
  false)
MXF_CLASS_END(Locator,
  MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x31, 0x00),
  InterchangeObject,
  false)
MXF_CLASS_SEPARATOR()

// Network Locator set for location with a URL
//
MXF_CLASS(NetworkLocator,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.32.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x32, 0x00),
  Locator,
  true)
  MXF_PROPERTY(URLString,
    // 06.0e.2b.34.01.01.01.01.01.02.01.01.01.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x01, 0x02, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00),
    0x4001,
    String,
    required,
    false,
    NetworkLocator)
MXF_CLASS_END(NetworkLocator,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x32, 0x00),
  Locator,
  true)
MXF_CLASS_SEPARATOR()

// Text Locator set for location with a human-readable text string
//
MXF_CLASS(TextLocator,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.33.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x33, 0x00),
  Locator,
  true)
  MXF_PROPERTY(LocatorName,
    // 06.0e.2b.34.01.01.01.02.01.04.01.02.01.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00),
    0x4101,
    String,
    required,
    false,
    TextLocator)
MXF_CLASS_END(TextLocator,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x33, 0x00),
  Locator,
  true)
MXF_CLASS_SEPARATOR()

// Generic Track
//
MXF_CLASS(GenericTrack,
  // 06.0E.2B.34.02.53.01.01.0D.01.01.01.01.01.38.00
  MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x38, 0x00),
  InterchangeObject,
  false)
  MXF_PROPERTY(TrackID,
    // 06.0e.2b.34.01.01.01.02.01.07.01.01.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x01, 0x07, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00),
    0x4801,
    UInt32,
    required,
    false,
    GenericTrack)
  MXF_PROPERTY(TrackNumber,
    // 06.0e.2b.34.01.01.01.02.01.04.01.03.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x01, 0x04, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00),
    0x4804,
    UInt32,
    required,
    false,
    GenericTrack)
  MXF_PROPERTY(TrackName,
    // 06.0e.2b.34.01.01.01.02.01.07.01.02.01.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x01, 0x07, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00),
    0x4802,
    String,
    optional,
    false,
    GenericTrack)
  MXF_PROPERTY(Sequence,
    // 06.0e.2b.34.01.01.01.02.06.01.01.04.02.04.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x06, 0x01, 0x01, 0x04, 0x02, 0x04, 0x00, 0x00),
    0x4803,
    UUID,
    required,
    false,
    GenericTrack)
MXF_CLASS_END(GenericTrack,
  MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x38, 0x00),
  InterchangeObject,
  false)
MXF_CLASS_SEPARATOR()

// StaticTrack
//
MXF_CLASS(StaticTrack,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.3a.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3a, 0x00),
  GenericTrack,
  true)
MXF_CLASS_END(StaticTrack,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3a, 0x00),
  GenericTrack,
  true)
MXF_CLASS_SEPARATOR()

// Track
//
MXF_CLASS(Track,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.3b.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3b, 0x00),
  GenericTrack,
  true)
  MXF_PROPERTY(EditRate,
    // 06.0e.2b.34.01.01.01.02.05.30.04.05.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x05, 0x30, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00),
    0x4b01,
    Rational,
    required,
    false,
    Track)
  MXF_PROPERTY(Origin,
    // 06.0e.2b.34.01.01.01.02.07.02.01.03.01.03.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x07, 0x02, 0x01, 0x03, 0x01, 0x03, 0x00, 0x00),
    0x4b02,
    Position,
    required,
    false,
    Track)
MXF_CLASS_END(Track,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3b, 0x00),
  GenericTrack,
  true)
MXF_CLASS_SEPARATOR()

// Event Track
//
MXF_CLASS(EventTrack,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.39.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x00),
  GenericTrack,
  true)
  MXF_PROPERTY(EventEditRate,
    // 06.0e.2b.34.01.01.01.02.05.30.04.02.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x05, 0x30, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00),
    0x4901,
    Rational,
    required,
    false,
    EventTrack)
  MXF_PROPERTY(EventOrigin,
    // 06.0e.2b.34.01.01.01.05.07.02.01.03.01.0b.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x07, 0x02, 0x01, 0x03, 0x01, 0x0b, 0x00, 0x00),
    0x4902,
    Position,
    optional,
    false,
    EventTrack)
MXF_CLASS_END(EventTrack,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x39, 0x00),
  GenericTrack,
  true)
MXF_CLASS_SEPARATOR()

// Structural Component Superclass
//
MXF_CLASS(StructuralComponent,
  // 06.0E.2B.34.02.53.01.01.0D.01.01.01.01.01.02.00
  MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00),
  InterchangeObject,
  false)
  MXF_PROPERTY(DataDefinition,
    // 06.0e.2b.34.01.01.01.02.04.07.01.00.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x04, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00),
    0x0201,
    Label,
    required,
    false,
    StructuralComponent)
  MXF_PROPERTY(Duration,
    // 06.0e.2b.34.01.01.01.02.07.02.02.01.01.03.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x07, 0x02, 0x02, 0x01, 0x01, 0x03, 0x00, 0x00),
    0x0202,
    Length,
    bestEffort,
    false,
    StructuralComponent)
MXF_CLASS_END(StructuralComponent,
  MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x00),
  InterchangeObject,
  false)
MXF_CLASS_SEPARATOR()

// Sequence
//
MXF_CLASS(Sequence,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.0f.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0f, 0x00),
  StructuralComponent,
  true)
  MXF_PROPERTY(StructuralComponents,
    // 06.0e.2b.34.01.01.01.02.06.01.01.04.06.09.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x06, 0x01, 0x01, 0x04, 0x06, 0x09, 0x00, 0x00),
    0x1001,
    subVector,
    required,
    false,
    Sequence)
MXF_CLASS_END(Sequence,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0f, 0x00),
  StructuralComponent,
  true)
MXF_CLASS_SEPARATOR()

// Timecode Component
//
MXF_CLASS(TimecodeComponent,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.14.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x14, 0x00),
  StructuralComponent,
  true)
  MXF_PROPERTY(RoundedTimecodeBase,
    // 06.0e.2b.34.01.01.01.02.04.04.01.01.02.06.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x04, 0x04, 0x01, 0x01, 0x02, 0x06, 0x00, 0x00),
    0x1502,
    UInt16,
    required,
    false,
    TimecodeComponent)
  MXF_PROPERTY(StartTimecode,
    // 06.0e.2b.34.01.01.01.02.07.02.01.03.01.05.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x07, 0x02, 0x01, 0x03, 0x01, 0x05, 0x00, 0x00),
    0x1501,
    Position,
    required,
    false,
    TimecodeComponent)
  MXF_PROPERTY(DropFrame,
    // 06.0e.2b.34.01.01.01.01.04.04.01.01.05.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x04, 0x04, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00),
    0x1503,
    Boolean,
    required,
    false,
    TimecodeComponent)
MXF_CLASS_END(TimecodeComponent,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x14, 0x00),
  StructuralComponent,
  true)
MXF_CLASS_SEPARATOR()

// Source Clip
//
MXF_CLASS(SourceClip,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.11.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x00),
  StructuralComponent,
  true)
  MXF_PROPERTY(StartPosition,
    // 06.0e.2b.34.01.01.01.02.07.02.01.03.01.04.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x07, 0x02, 0x01, 0x03, 0x01, 0x04, 0x00, 0x00),
    0x1201,
    Position,
    required,
    false,
    SourceClip)
  MXF_PROPERTY(SourcePackageID,
    // 06.0e.2b.34.01.01.01.02.06.01.01.03.01.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x06, 0x01, 0x01, 0x03, 0x01, 0x00, 0x00, 0x00),
    0x1101,
    UMID,
    required,
    false,
    SourceClip)
  MXF_PROPERTY(SourceTrackID,
    // 06.0e.2b.34.01.01.01.02.06.01.01.03.02.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x06, 0x01, 0x01, 0x03, 0x02, 0x00, 0x00, 0x00),
    0x1102,
    UInt32,
    required,
    false,
    SourceClip)
MXF_CLASS_END(SourceClip,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x11, 0x00),
  StructuralComponent,
  true)
MXF_CLASS_SEPARATOR()

// Descriptive Metadata Segment
//
MXF_CLASS(DMSegment,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.41.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x41, 0x00),
  StructuralComponent,
  true)
  MXF_PROPERTY(EventStartPosition,
    // 06.0e.2b.34.01.01.01.02.07.02.01.03.03.03.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x07, 0x02, 0x01, 0x03, 0x03, 0x03, 0x00, 0x00),
    0x0601,
    Position,
    required,
    false,
    DMSegment)
  MXF_PROPERTY(EventComment,
    // 06.0e.2b.34.01.01.01.02.05.30.04.04.01.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x05, 0x30, 0x04, 0x04, 0x01, 0x00, 0x00, 0x00),
    0x0602,
    String,
    optional,
    false,
    DMSegment)
  MXF_PROPERTY(TrackIDs,
    // 06.0e.2b.34.01.01.01.04.01.07.01.05.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04,
              0x01, 0x07, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00),
    0x6102,
    subVector,
    decoderRequired,
    false,
    DMSegment)
  MXF_PROPERTY(DMFramework,
    // 06.0e.2b.34.01.01.01.05.06.01.01.04.02.0c.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x06, 0x01, 0x01, 0x04, 0x02, 0x0c, 0x00, 0x00),
    0x6101,
    UUID,
    decoderRequired,
    false,
    DMSegment)
MXF_CLASS_END(DMSegment,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x41, 0x00),
  StructuralComponent,
  true)
MXF_CLASS_SEPARATOR()

// Descriptive Metadata SourceClip
//
MXF_CLASS(DMSourceClip,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.45.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x45, 0x00),
  SourceClip,
  true)
  MXF_PROPERTY(DMSourceClipTrackIDs,
    // 06.0e.2b.34.01.01.01.05.01.07.01.06.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x01, 0x07, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00),
    0x6103,
    subVector,
    optional,
    false,
    DMSourceClip)
MXF_CLASS_END(DMSourceClip,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x45, 0x00),
  SourceClip,
  true)
MXF_CLASS_SEPARATOR()

// Material Package set
//
MXF_CLASS(MaterialPackage,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.36.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x36, 0x00),
  GenericPackage,
  true)
MXF_CLASS_END(MaterialPackage,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x36, 0x00),
  GenericPackage,
  true)
MXF_CLASS_SEPARATOR()

// File Package set
//
MXF_CLASS(SourcePackage,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.37.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x37, 0x00),
  GenericPackage,
  true)
  MXF_PROPERTY(Descriptor,
    // 06.0e.2b.34.01.01.01.02.06.01.01.04.02.03.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x06, 0x01, 0x01, 0x04, 0x02, 0x03, 0x00, 0x00),
    0x4701,
    UUID,
    decoderRequired,
    false,
    SourcePackage)
MXF_CLASS_END(SourcePackage,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x37, 0x00),
  GenericPackage,
  true)
MXF_CLASS_SEPARATOR()

// Generic Sub-Descriptor
//
MXF_CLASS(SubDescriptor,
  // 06.0E.2B.34.02.53.01.01.0D.01.01.01.01.01.59.00
  MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x59, 0x00),
  InterchangeObject,
  false)
MXF_CLASS_END(SubDescriptor,
  MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x59, 0x00),
  InterchangeObject,
  false)
MXF_CLASS_SEPARATOR()

// Generic Descriptor
//
MXF_CLASS(GenericDescriptor,
  // 06.0E.2B.34.02.53.01.01.0D.01.01.01.01.01.24.00
  MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x24, 0x00),
  InterchangeObject,
  false)
  MXF_PROPERTY(Locators,
    // 06.0e.2b.34.01.01.01.02.06.01.01.04.06.03.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x06, 0x01, 0x01, 0x04, 0x06, 0x03, 0x00, 0x00),
    0x2f01,
    subVector,
    optional,
    false,
    GenericDescriptor)
  MXF_PROPERTY(SubDescriptor,
    // 06.0e.2b.34.01.01.01.0a.06.01.01.04.02.10.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a,
              0x06, 0x01, 0x01, 0x04, 0x02, 0x10, 0x00, 0x00),
    0x0000,
    UUID,
    optional,
    false,
    GenericDescriptor)
  MXF_PROPERTY(SubDescriptors,
    // 06.0e.2b.34.01.01.01.0a.06.01.01.04.06.10.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a,
              0x06, 0x01, 0x01, 0x04, 0x06, 0x10, 0x00, 0x00),
    0x0000,
    subVector,
    optional,
    false,
    GenericDescriptor)
MXF_CLASS_END(GenericDescriptor,
  MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0D, 0x01, 0x01, 0x01, 0x01, 0x01, 0x24, 0x00),
  InterchangeObject,
  false)
MXF_CLASS_SEPARATOR()

// File Descriptor
//
MXF_CLASS(FileDescriptor,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.25.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x25, 0x00),
  GenericDescriptor,
  true)
  MXF_PROPERTY(LinkedTrackID,
    // 06.0e.2b.34.01.01.01.05.06.01.01.03.05.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x06, 0x01, 0x01, 0x03, 0x05, 0x00, 0x00, 0x00),
    0x3006,
    UInt32,
    optional,
    false,
    FileDescriptor)
  MXF_PROPERTY(SampleRate,
    // 06.0e.2b.34.01.01.01.01.04.06.01.01.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x04, 0x06, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00),
    0x3001,
    Rational,
    required,
    false,
    FileDescriptor)
  MXF_PROPERTY(ContainerDuration,
    // 06.0e.2b.34.01.01.01.01.04.06.01.02.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x04, 0x06, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00),
    0x3002,
    Length,
    optional,
    false,
    FileDescriptor)
  MXF_PROPERTY(EssenceContainer,
    // 06.0e.2b.34.01.01.01.02.06.01.01.04.01.02.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x06, 0x01, 0x01, 0x04, 0x01, 0x02, 0x00, 0x00),
    0x3004,
    Label,
    required,
    false,
    FileDescriptor)
  MXF_PROPERTY(Codec,
    // 06.0e.2b.34.01.01.01.02.06.01.01.04.01.03.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x06, 0x01, 0x01, 0x04, 0x01, 0x03, 0x00, 0x00),
    0x3005,
    Label,
    optional,
    false,
    FileDescriptor)
MXF_CLASS_END(FileDescriptor,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x25, 0x00),
  GenericDescriptor,
  true)
MXF_CLASS_SEPARATOR()

// Defines the Picture Essence Descriptor set
//
MXF_CLASS(GenericPictureEssenceDescriptor,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.27.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x00),
  FileDescriptor,
  true)
  MXF_PROPERTY(SignalStandard,
    // 06.0e.2b.34.01.01.01.05.04.05.01.13.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x05, 0x01, 0x13, 0x00, 0x00, 0x00, 0x00),
    0x3215,
    UInt8,
    optional,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(FrameLayout,
    // 06.0e.2b.34.01.01.01.01.04.01.03.01.04.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x04, 0x01, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00),
    0x320c,
    UInt8,
    bestEffort,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(StoredWidth,
    // 06.0e.2b.34.01.01.01.01.04.01.05.02.02.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x04, 0x01, 0x05, 0x02, 0x02, 0x00, 0x00, 0x00),
    0x3203,
    UInt32,
    bestEffort,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(StoredHeight,
    // 06.0e.2b.34.01.01.01.01.04.01.05.02.01.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x04, 0x01, 0x05, 0x02, 0x01, 0x00, 0x00, 0x00),
    0x3202,
    UInt32,
    bestEffort,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(StoredF2Offset,
    // 06.0e.2b.34.01.01.01.05.04.01.03.02.08.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x01, 0x03, 0x02, 0x08, 0x00, 0x00, 0x00),
    0x3216,
    Int32,
    optional,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(SampledWidth,
    // 06.0e.2b.34.01.01.01.01.04.01.05.01.08.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x04, 0x01, 0x05, 0x01, 0x08, 0x00, 0x00, 0x00),
    0x3205,
    UInt32,
    optional,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(SampledHeight,
    // 06.0e.2b.34.01.01.01.01.04.01.05.01.07.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x04, 0x01, 0x05, 0x01, 0x07, 0x00, 0x00, 0x00),
    0x3204,
    UInt32,
    optional,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(SampledXOffset,
    // 06.0e.2b.34.01.01.01.01.04.01.05.01.09.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x04, 0x01, 0x05, 0x01, 0x09, 0x00, 0x00, 0x00),
    0x3206,
    Int32,
    optional,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(SampledYOffset,
    // 06.0e.2b.34.01.01.01.01.04.01.05.01.0A.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x04, 0x01, 0x05, 0x01, 0x0A, 0x00, 0x00, 0x00),
    0x3207,
    Int32,
    optional,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(DisplayHeight,
    // 06.0e.2b.34.01.01.01.01.04.01.05.01.0B.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x04, 0x01, 0x05, 0x01, 0x0B, 0x00, 0x00, 0x00),
    0x3208,
    UInt32,
    optional,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(DisplayWidth,
    // 06.0e.2b.34.01.01.01.01.04.01.05.01.0C.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x04, 0x01, 0x05, 0x01, 0x0C, 0x00, 0x00, 0x00),
    0x3209,
    UInt32,
    optional,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(DisplayXOffset,
    // 06.0e.2b.34.01.01.01.01.04.01.05.01.0D.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x04, 0x01, 0x05, 0x01, 0x0D, 0x00, 0x00, 0x00),
    0x320A,
    Int32,
    optional,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(DisplayYOffset,
    // 06.0e.2b.34.01.01.01.01.04.01.05.01.0E.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x04, 0x01, 0x05, 0x01, 0x0E, 0x00, 0x00, 0x00),
    0x320B,
    Int32,
    optional,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(DisplayF2Offset,
    // 06.0e.2b.34.01.01.01.05.04.01.03.02.07.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x01, 0x03, 0x02, 0x07, 0x00, 0x00, 0x00),
    0x3217,
    Int32,
    optional,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(AspectRatio,
    // 06.0e.2b.34.01.01.01.01.04.01.01.01.01.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x04, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00),
    0x320E,
    Rational,
    bestEffort,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(ActiveFormatDescriptor,
    // 06.0e.2b.34.01.01.01.05.04.01.03.02.09.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x01, 0x03, 0x02, 0x09, 0x00, 0x00, 0x00),
    0x3218,
    UInt8,
    optional,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(VideoLineMap,
    // 06.0e.2b.34.01.01.01.02.04.01.03.02.05.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x04, 0x01, 0x03, 0x02, 0x05, 0x00, 0x00, 0x00),
    0x320d,
    subVector,
    bestEffort,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(AlphaTransparency,
    // 06.0e.2b.34.01.01.01.02.05.20.01.02.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x05, 0x20, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00),
    0x320F,
    UInt8,
    optional,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(Gamma,
    // 06.0e.2b.34.01.01.01.02.04.01.02.01.01.01.02.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x04, 0x01, 0x02, 0x01, 0x01, 0x01, 0x02, 0x00),
    0x3210,
    Label,
    optional,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(ImageAlignmentOffset,
    // 06.0e.2b.34.01.01.01.02.04.18.01.01.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x04, 0x18, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00),
    0x3211,
    UInt32,
    optional,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(ImageStartOffset,
    // 06.0e.2b.34.01.01.01.02.04.18.01.02.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x04, 0x18, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00),
    0x3213,
    UInt32,
    optional,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(ImageEndOffset,
    // 06.0e.2b.34.01.01.01.02.04.18.01.03.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x04, 0x18, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00),
    0x3214,
    UInt32,
    optional,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(FieldDominance,
    // 06.0e.2b.34.01.01.01.02.04.01.03.01.06.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x04, 0x01, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00),
    0x3212,
    UInt8,
    optional,
    false,
    GenericPictureEssenceDescriptor)
  MXF_PROPERTY(PictureEssenceCoding,
    // 06.0e.2b.34.01.01.01.02.04.01.06.01.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x04, 0x01, 0x06, 0x01, 0x00, 0x00, 0x00, 0x00),
    0x3201,
    Label,
    decoderRequired,
    false,
    GenericPictureEssenceDescriptor)
MXF_CLASS_END(GenericPictureEssenceDescriptor,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x27, 0x00),
  FileDescriptor,
  true)
MXF_CLASS_SEPARATOR()

// Defines the CDCI Picture Essence Descriptor set
//
MXF_CLASS(CDCIEssenceDescriptor,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.28.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x28, 0x00),
  GenericPictureEssenceDescriptor,
  true)
  MXF_PROPERTY(ComponentDepth,
    // 06.0e.2b.34.01.01.01.02.04.01.05.03.0A.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x04, 0x01, 0x05, 0x03, 0x0A, 0x00, 0x00, 0x00),
    0x3301,
    UInt32,
    bestEffort,
    false,
    CDCIEssenceDescriptor)
  MXF_PROPERTY(HorizontalSubsampling,
    // 06.0e.2b.34.01.01.01.01.04.01.05.01.05.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x04, 0x01, 0x05, 0x01, 0x05, 0x00, 0x00, 0x00),
    0x3302,
    UInt32,
    bestEffort,
    false,
    CDCIEssenceDescriptor)
  MXF_PROPERTY(VerticalSubsampling,
    // 06.0e.2b.34.01.01.01.02.04.01.05.01.10.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x04, 0x01, 0x05, 0x01, 0x10, 0x00, 0x00, 0x00),
    0x3308,
    UInt32,
    optional,
    false,
    CDCIEssenceDescriptor)
  MXF_PROPERTY(ColorSiting,
    // 06.0e.2b.34.01.01.01.01.04.01.05.01.06.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x04, 0x01, 0x05, 0x01, 0x06, 0x00, 0x00, 0x00),
    0x3303,
    UInt8,
    optional,
    false,
    CDCIEssenceDescriptor)
  MXF_PROPERTY(ReversedByteOrder,
    // 06.0e.2b.34.01.01.01.05.03.01.02.01.0a.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x03, 0x01, 0x02, 0x01, 0x0a, 0x00, 0x00, 0x00),
    0x330b,
    Boolean,
    optional,
    false,
    CDCIEssenceDescriptor)
  MXF_PROPERTY(PaddingBits,
    // 06.0e.2b.34.01.01.01.02.04.18.01.04.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x04, 0x18, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00),
    0x3307,
    UInt16,
    optional,
    false,
    CDCIEssenceDescriptor)
  MXF_PROPERTY(AlphaSampleDepth,
    // 06.0e.2b.34.01.01.01.02.04.01.05.03.07.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x04, 0x01, 0x05, 0x03, 0x07, 0x00, 0x00, 0x00),
    0x3309,
    UInt32,
    optional,
    false,
    CDCIEssenceDescriptor)
  MXF_PROPERTY(BlackRefLevel,
    // 06.0e.2b.34.01.01.01.01.04.01.05.03.03.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x04, 0x01, 0x05, 0x03, 0x03, 0x00, 0x00, 0x00),
    0x3304,
    UInt32,
    optional,
    false,
    CDCIEssenceDescriptor)
  MXF_PROPERTY(WhiteReflevel,
    // 06.0e.2b.34.01.01.01.01.04.01.05.03.04.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x04, 0x01, 0x05, 0x03, 0x04, 0x00, 0x00, 0x00),
    0x3305,
    UInt32,
    optional,
    false,
    CDCIEssenceDescriptor)
  MXF_PROPERTY(ColorRange,
    // 06.0e.2b.34.01.01.01.02.04.01.05.03.05.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x04, 0x01, 0x05, 0x03, 0x05, 0x00, 0x00, 0x00),
    0x3306,
    UInt32,
    optional,
    false,
    CDCIEssenceDescriptor)
MXF_CLASS_END(CDCIEssenceDescriptor,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x28, 0x00),
  GenericPictureEssenceDescriptor,
  true)
MXF_CLASS_SEPARATOR()

// Defines the RGBA Picture Essence Descriptor set
//
MXF_CLASS(RGBAEssenceDescriptor,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.29.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x29, 0x00),
  GenericPictureEssenceDescriptor,
  true)
  MXF_PROPERTY(ComponentMaxRef,
    // 06.0e.2b.34.01.01.01.05.04.01.05.03.0b.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x01, 0x05, 0x03, 0x0b, 0x00, 0x00, 0x00),
    0x3406,
    UInt32,
    optional,
    false,
    RGBAEssenceDescriptor)
  MXF_PROPERTY(ComponentMinRef,
    // 06.0e.2b.34.01.01.01.05.04.01.05.03.0c.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x01, 0x05, 0x03, 0x0c, 0x00, 0x00, 0x00),
    0x3407,
    UInt32,
    optional,
    false,
    RGBAEssenceDescriptor)
  MXF_PROPERTY(AlphaMaxRef,
    // 06.0e.2b.34.01.01.01.05.04.01.05.03.0d.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x01, 0x05, 0x03, 0x0d, 0x00, 0x00, 0x00),
    0x3408,
    UInt32,
    optional,
    false,
    RGBAEssenceDescriptor)
  MXF_PROPERTY(AlphaMinRef,
    // 06.0e.2b.34.01.01.01.05.04.01.05.03.0e.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x01, 0x05, 0x03, 0x0e, 0x00, 0x00, 0x00),
    0x3409,
    UInt32,
    optional,
    false,
    RGBAEssenceDescriptor)
  MXF_PROPERTY(ScanningDirection,
    // 06.0e.2b.34.01.01.01.05.04.01.04.04.01.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x01, 0x04, 0x04, 0x01, 0x00, 0x00, 0x00),
    0x3405,
    UInt8,
    optional,
    false,
    RGBAEssenceDescriptor)
  MXF_PROPERTY(PixelLayout,
    // 06.0e.2b.34.01.01.01.02.04.01.05.03.06.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x04, 0x01, 0x05, 0x03, 0x06, 0x00, 0x00, 0x00),
    0x3401,
    RGBALayout,
    bestEffort,
    false,
    RGBAEssenceDescriptor)
  MXF_PROPERTY(Palette,
    // 06.0e.2b.34.01.01.01.02.04.01.05.03.08.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x04, 0x01, 0x05, 0x03, 0x08, 0x00, 0x00, 0x00),
    0x3403,
    DataValue,
    optional,
    false,
    RGBAEssenceDescriptor)
  MXF_PROPERTY(PaletteLayout,
    // 06.0e.2b.34.01.01.01.02.04.01.05.03.09.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x04, 0x01, 0x05, 0x03, 0x09, 0x00, 0x00, 0x00),
    0x3404,
    RGBALayout,
    optional,
    false,
    RGBAEssenceDescriptor)
MXF_CLASS_END(RGBAEssenceDescriptor,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x29, 0x00),
  GenericPictureEssenceDescriptor,
  true)
MXF_CLASS_SEPARATOR()

// Defines the Sound Essence Descriptor set
//
MXF_CLASS(GenericSoundEssenceDescriptor,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.42.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x42, 0x00),
  FileDescriptor,
  true)
  MXF_PROPERTY(AudioSamplingRate,
    // 06.0e.2b.34.01.01.01.05.04.02.03.01.01.01.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x02, 0x03, 0x01, 0x01, 0x01, 0x00, 0x00),
    0x3d03,
    Rational,
    bestEffort,
    false,
    GenericSoundEssenceDescriptor)
  MXF_PROPERTY(Locked,
    // 06.0e.2b.34.01.01.01.04.04.02.03.01.04.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04,
              0x04, 0x02, 0x03, 0x01, 0x04, 0x00, 0x00, 0x00),
    0x3D02,
    Boolean,
    decoderRequired,
    false,
    GenericSoundEssenceDescriptor)
  MXF_PROPERTY(AudioRefLevel,
    // 06.0e.2b.34.01.01.01.01.04.02.01.01.03.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x04, 0x02, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00),
    0x3D04,
    Int8,
    optional,
    false,
    GenericSoundEssenceDescriptor)
  MXF_PROPERTY(ElectroSpatialFormulation,
    // 06.0e.2b.34.01.01.01.01.04.02.01.01.01.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x04, 0x02, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00),
    0x3D05,
    UInt8,
    optional,
    false,
    GenericSoundEssenceDescriptor)
  MXF_PROPERTY(ChannelCount,
    // 06.0e.2b.34.01.01.01.05.04.02.01.01.04.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x02, 0x01, 0x01, 0x04, 0x00, 0x00, 0x00),
    0x3D07,
    UInt32,
    bestEffort,
    false,
    GenericSoundEssenceDescriptor)
  MXF_PROPERTY(QuantizationBits,
    // 06.0e.2b.34.01.01.01.04.04.02.03.03.04.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04,
              0x04, 0x02, 0x03, 0x03, 0x04, 0x00, 0x00, 0x00),
    0x3D01,
    UInt32,
    bestEffort,
    false,
    GenericSoundEssenceDescriptor)
  MXF_PROPERTY(DialNorm,
    // 06.0e.2b.34.01.01.01.05.04.02.07.01.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x02, 0x07, 0x01, 0x00, 0x00, 0x00, 0x00),
    0x3d0C,
    Int8,
    optional,
    false,
    GenericSoundEssenceDescriptor)
  MXF_PROPERTY(SoundEssenceCompression,
    // 06.0e.2b.34.01.01.01.02.04.02.04.02.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x04, 0x02, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00),
    0x3d06,
    Label,
    decoderRequired,
    false,
    GenericSoundEssenceDescriptor)
MXF_CLASS_END(GenericSoundEssenceDescriptor,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x42, 0x00),
  FileDescriptor,
  true)
MXF_CLASS_SEPARATOR()

// Defines the Data Essence Descriptor set
//
MXF_CLASS(GenericDataEssenceDescriptor,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.43.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x43, 0x00),
  FileDescriptor,
  true)
  MXF_PROPERTY(DataEssenceCoding,
    // 06.0e.2b.34.01.01.01.05.04.03.03.02.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x03, 0x03, 0x02, 0x00, 0x00, 0x00, 0x00),
    0x3e01,
    Label,
    decoderRequired,
    false,
    GenericDataEssenceDescriptor)
MXF_CLASS_END(GenericDataEssenceDescriptor,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x43, 0x00),
  FileDescriptor,
  true)
MXF_CLASS_SEPARATOR()

// Defines the VBI Data Descriptor Set
//
MXF_CLASS(VBIDataDescriptor,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.5b.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5b, 0x00),
  GenericDataEssenceDescriptor,
  true)
MXF_CLASS_END(VBIDataDescriptor,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5b, 0x00),
  GenericDataEssenceDescriptor,
  true)
MXF_CLASS_SEPARATOR()

// Defines the Multiple Descriptor set
//
MXF_CLASS(MultipleDescriptor,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.44.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x44, 0x00),
  FileDescriptor,
  true)
  MXF_PROPERTY(SubDescriptorUIDs,
    // 06.0e.2b.34.01.01.01.04.06.01.01.04.06.0b.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x04,
              0x06, 0x01, 0x01, 0x04, 0x06, 0x0b, 0x00, 0x00),
    0x3f01,
    subVector,
    required,
    false,
    MultipleDescriptor)
MXF_CLASS_END(MultipleDescriptor,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x44, 0x00),
  FileDescriptor,
  true)
MXF_CLASS_SEPARATOR()

// Defines the MPEG2 Picture Essence Descriptor set
//
MXF_CLASS(MPEG2VideoDescriptor,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.51.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x51, 0x00),
  CDCIEssenceDescriptor,
  true)
  MXF_PROPERTY(SingleSequence,
    // 06.0e.2b.34.01.01.01.05.04.01.06.02.01.02.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x01, 0x06, 0x02, 0x01, 0x02, 0x00, 0x00),
    0x0000,
    Boolean,
    optional,
    false,
    MPEG2VideoDescriptor)
  MXF_PROPERTY(ConstantBFrames,
    // 06.0e.2b.34.01.01.01.05.04.01.06.02.01.03.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x01, 0x06, 0x02, 0x01, 0x03, 0x00, 0x00),
    0x0000,
    Boolean,
    optional,
    false,
    MPEG2VideoDescriptor)
  MXF_PROPERTY(CodedContentType,
    // 06.0e.2b.34.01.01.01.05.04.01.06.02.01.04.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x01, 0x06, 0x02, 0x01, 0x04, 0x00, 0x00),
    0x0000,
    UInt8,
    optional,
    false,
    MPEG2VideoDescriptor)
  MXF_PROPERTY(LowDelay,
    // 06.0e.2b.34.01.01.01.05.04.01.06.02.01.05.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x01, 0x06, 0x02, 0x01, 0x05, 0x00, 0x00),
    0x0000,
    Boolean,
    optional,
    false,
    MPEG2VideoDescriptor)
  MXF_PROPERTY(ClosedGOP,
    // 06.0e.2b.34.01.01.01.05.04.01.06.02.01.06.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x01, 0x06, 0x02, 0x01, 0x06, 0x00, 0x00),
    0x0000,
    Boolean,
    optional,
    false,
    MPEG2VideoDescriptor)
  MXF_PROPERTY(IdenticalGOP,
    // 06.0e.2b.34.01.01.01.05.04.01.06.02.01.07.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x01, 0x06, 0x02, 0x01, 0x07, 0x00, 0x00),
    0x0000,
    Boolean,
    optional,
    false,
    MPEG2VideoDescriptor)
  MXF_PROPERTY(MaxGOP,
    // 06.0e.2b.34.01.01.01.05.04.01.06.02.01.08.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x01, 0x06, 0x02, 0x01, 0x08, 0x00, 0x00),
    0x0000,
    UInt16,
    optional,
    false,
    MPEG2VideoDescriptor)
  MXF_PROPERTY(BPictureCount,
    // 06.0e.2b.34.01.01.01.05.04.01.06.02.01.09.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x01, 0x06, 0x02, 0x01, 0x09, 0x00, 0x00),
    0x0000,
    UInt16,
    optional,
    false,
    MPEG2VideoDescriptor)
  MXF_PROPERTY(BitRate,
    // 06.0e.2b.34.01.01.01.05.04.01.06.02.01.0b.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x01, 0x06, 0x02, 0x01, 0x0b, 0x00, 0x00),
    0x0000,
    UInt32,
    optional,
    false,
    MPEG2VideoDescriptor)
  MXF_PROPERTY(ProfileAndLevel,
    // 06.0e.2b.34.01.01.01.05.04.01.06.02.01.0a.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x01, 0x06, 0x02, 0x01, 0x0a, 0x00, 0x00),
    0x0000,
    UInt8,
    optional,
    false,
    MPEG2VideoDescriptor)
MXF_CLASS_END(MPEG2VideoDescriptor,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x51, 0x00),
  CDCIEssenceDescriptor,
  true)
MXF_CLASS_SEPARATOR()

// Defines the Wave Audio Essence Descriptor Set
//
MXF_CLASS(WaveAudioDescriptor,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.48.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x48, 0x00),
  GenericSoundEssenceDescriptor,
  true)
  MXF_PROPERTY(BlockAlign,
    // 06.0e.2b.34.01.01.01.05.04.02.03.02.01.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x02, 0x03, 0x02, 0x01, 0x00, 0x00, 0x00),
    0x3d0a,
    UInt16,
    required,
    false,
    WaveAudioDescriptor)
  MXF_PROPERTY(SequenceOffset,
    // 06.0e.2b.34.01.01.01.05.04.02.03.02.02.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x02, 0x03, 0x02, 0x02, 0x00, 0x00, 0x00),
    0x3d0b,
    UInt8,
    optional,
    false,
    WaveAudioDescriptor)
  MXF_PROPERTY(AvgBps,
    // 06.0e.2b.34.01.01.01.05.04.02.03.03.05.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x02, 0x03, 0x03, 0x05, 0x00, 0x00, 0x00),
    0x3d09,
    UInt32,
    required,
    false,
    WaveAudioDescriptor)
  MXF_PROPERTY(ChannelAssignment,
    // 06.0e.2b.34.01.01.01.07.04.02.01.01.05.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x07,
              0x04, 0x02, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00),
    0x3d32,
    Label,
    optional,
    false,
    WaveAudioDescriptor)
  MXF_PROPERTY(PeakEnvelopeVersion,
    // 06.0e.2b.34.01.01.01.08.04.02.03.01.06.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x08,
              0x04, 0x02, 0x03, 0x01, 0x06, 0x00, 0x00, 0x00),
    0x3d29,
    UInt32,
    optional,
    false,
    WaveAudioDescriptor)
  MXF_PROPERTY(PeakEnvelopeFormat,
    // 06.0e.2b.34.01.01.01.08.04.02.03.01.07.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x08,
              0x04, 0x02, 0x03, 0x01, 0x07, 0x00, 0x00, 0x00),
    0x3d2a,
    UInt32,
    optional,
    false,
    WaveAudioDescriptor)
  MXF_PROPERTY(PointsPerPeakValue,
    // 06.0e.2b.34.01.01.01.08.04.02.03.01.08.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x08,
              0x04, 0x02, 0x03, 0x01, 0x08, 0x00, 0x00, 0x00),
    0x3d2b,
    UInt32,
    optional,
    false,
    WaveAudioDescriptor)
  MXF_PROPERTY(PeakEnvelopeBlockSize,
    // 06.0e.2b.34.01.01.01.08.04.02.03.01.09.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x08,
              0x04, 0x02, 0x03, 0x01, 0x09, 0x00, 0x00, 0x00),
    0x3d2c,
    UInt32,
    optional,
    false,
    WaveAudioDescriptor)
  MXF_PROPERTY(PeakChannels,
    // 06.0e.2b.34.01.01.01.08.04.02.03.01.0a.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x08,
              0x04, 0x02, 0x03, 0x01, 0x0a, 0x00, 0x00, 0x00),
    0x3d2d,
    UInt32,
    optional,
    false,
    WaveAudioDescriptor)
  MXF_PROPERTY(PeakFrames,
    // 06.0e.2b.34.01.01.01.08.04.02.03.01.0b.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x08,
              0x04, 0x02, 0x03, 0x01, 0x0b, 0x00, 0x00, 0x00),
    0x3d2e,
    UInt32,
    optional,
    false,
    WaveAudioDescriptor)
  MXF_PROPERTY(PeakOfPeaksPosition,
    // 06.0e.2b.34.01.01.01.08.04.02.03.01.0c.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x08,
              0x04, 0x02, 0x03, 0x01, 0x0c, 0x00, 0x00, 0x00),
    0x3d2f,
    Position,
    optional,
    false,
    WaveAudioDescriptor)
  MXF_PROPERTY(PeakEnvelopeTimestamp,
    // 06.0e.2b.34.01.01.01.08.04.02.03.01.0d.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x08,
              0x04, 0x02, 0x03, 0x01, 0x0d, 0x00, 0x00, 0x00),
    0x3d30,
    Timestamp,
    optional,
    false,
    WaveAudioDescriptor)
  MXF_PROPERTY(PeakEnvelopeData,
    // 06.0e.2b.34.01.01.01.05.04.02.03.01.0e.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x02, 0x03, 0x01, 0x0e, 0x00, 0x00, 0x00),
    0x3d31,
    Stream,
    optional,
    false,
    WaveAudioDescriptor)
MXF_CLASS_END(WaveAudioDescriptor,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x48, 0x00),
  GenericSoundEssenceDescriptor,
  true)
MXF_CLASS_SEPARATOR()

// AES3 PCM Descriptor Set
//
MXF_CLASS(AES3PCMDescriptor,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.47.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x47, 0x00),
  WaveAudioDescriptor,
  true)
  MXF_PROPERTY(Emphasis,
    // 06.0E.2B.34.01.01.01.05.04.02.05.01.06.00.00.00
    MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x02, 0x05, 0x01, 0x06, 0x00, 0x00, 0x00),
    0x3d0d,
    UInt8,
    optional,
    false,
    AES3PCMDescriptor)
  MXF_PROPERTY(BlockStartOffset,
    // 06.0E.2B.34.01.01.01.05.04.02.03.02.03.00.00.00
    MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x02, 0x03, 0x02, 0x03, 0x00, 0x00, 0x00),
    0x3d0f,
    UInt16,
    optional,
    false,
    AES3PCMDescriptor)
  MXF_PROPERTY(AuxBitsMode,
    // 06.0E.2B.34.01.01.01.05.04.02.05.01.01.00.00.00
    MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x02, 0x05, 0x01, 0x01, 0x00, 0x00, 0x00),
    0x3d08,
    UInt8,
    optional,
    false,
    AES3PCMDescriptor)
  MXF_PROPERTY(ChannelStatusMode,
    // 06.0E.2B.34.01.01.01.05.04.02.05.01.02.00.00.00
    MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x02, 0x05, 0x01, 0x02, 0x00, 0x00, 0x00),
    0x3d10,
    ChannelStatusModeTypeBatch,
    optional,
    false,
    AES3PCMDescriptor)
  MXF_PROPERTY(FixedChannelStatusData,
    // 06.0E.2B.34.01.01.01.05.04.02.05.01.03.00.00.00
    MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x02, 0x05, 0x01, 0x03, 0x00, 0x00, 0x00),
    0x3d11,
    RAWBatch,
    optional,
    false,
    AES3PCMDescriptor)
  MXF_PROPERTY(UserDataMode,
    // 06.0E.2B.34.01.01.01.05.04.02.05.01.04.00.00.00
    MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x02, 0x05, 0x01, 0x04, 0x00, 0x00, 0x00),
    0x3d12,
    RAWBatch,
    optional,
    false,
    AES3PCMDescriptor)
  MXF_PROPERTY(FixedUserData,
    // 06.0E.2B.34.01.01.01.05.04.02.05.01.05.00.00.00
    MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x01, 0x01, 0x01, 0x05,
              0x04, 0x02, 0x05, 0x01, 0x05, 0x00, 0x00, 0x00),
    0x3d13,
    RAWBatch,
    optional,
    false,
    AES3PCMDescriptor)
MXF_CLASS_END(AES3PCMDescriptor,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x47, 0x00),
  WaveAudioDescriptor,
  true)
MXF_CLASS_SEPARATOR()

// Superclass for all concrete DM Frameworks
//
MXF_CLASS(DM_Framework,
  // 06.0e.2b.34.02.53.01.01.0d.01.04.01.00.00.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00),
  InterchangeObject,
  true)
MXF_CLASS_END(DM_Framework,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00),
  InterchangeObject,
  true)
MXF_CLASS_SEPARATOR()

// Superclass for all concrete DM Frameworks
//
MXF_CLASS(DM_Set,
  // 06.0e.2b.34.02.53.01.01.0d.01.04.00.00.00.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00),
  InterchangeObject,
  true)
MXF_CLASS_END(DM_Set,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00),
  InterchangeObject,
  true)
MXF_CLASS_SEPARATOR()

// JPEG 2000 Picture Sub Descriptor
//
MXF_CLASS(JPEG2000PictureSubDescriptor,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.01.01.5a.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5a, 0x00),
  InterchangeObject,
  true)
  MXF_PROPERTY(Rsiz,
    // 06.0e.2b.34.01.01.01.0a.04.01.06.03.01.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a,
              0x04, 0x01, 0x06, 0x03, 0x01, 0x00, 0x00, 0x00),
    0x0000,
    UInt16,
    required,
    false,
    JPEG2000PictureSubDescriptor)
  MXF_PROPERTY(Xsiz,
    // 06.0e.2b.34.01.01.01.0a.04.01.06.03.02.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a,
              0x04, 0x01, 0x06, 0x03, 0x02, 0x00, 0x00, 0x00),
    0x0000,
    UInt32,
    required,
    false,
    JPEG2000PictureSubDescriptor)
  MXF_PROPERTY(Ysiz,
    // 06.0e.2b.34.01.01.01.0a.04.01.06.03.03.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a,
              0x04, 0x01, 0x06, 0x03, 0x03, 0x00, 0x00, 0x00),
    0x0000,
    UInt32,
    required,
    false,
    JPEG2000PictureSubDescriptor)
  MXF_PROPERTY(XOsiz,
    // 06.0e.2b.34.01.01.01.0a.04.01.06.03.04.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a,
              0x04, 0x01, 0x06, 0x03, 0x04, 0x00, 0x00, 0x00),
    0x0000,
    UInt32,
    required,
    false,
    JPEG2000PictureSubDescriptor)
  MXF_PROPERTY(YOsiz,
    // 06.0e.2b.34.01.01.01.0a.04.01.06.03.05.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a,
              0x04, 0x01, 0x06, 0x03, 0x05, 0x00, 0x00, 0x00),
    0x0000,
    UInt32,
    required,
    false,
    JPEG2000PictureSubDescriptor)
  MXF_PROPERTY(XTsiz,
    // 06.0e.2b.34.01.01.01.0a.04.01.06.03.06.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a,
              0x04, 0x01, 0x06, 0x03, 0x06, 0x00, 0x00, 0x00),
    0x0000,
    UInt32,
    required,
    false,
    JPEG2000PictureSubDescriptor)
  MXF_PROPERTY(YTsiz,
    // 06.0e.2b.34.01.01.01.0a.04.01.06.03.07.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a,
              0x04, 0x01, 0x06, 0x03, 0x07, 0x00, 0x00, 0x00),
    0x0000,
    UInt32,
    required,
    false,
    JPEG2000PictureSubDescriptor)
  MXF_PROPERTY(XTOsiz,
    // 06.0e.2b.34.01.01.01.0a.04.01.06.03.08.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a,
              0x04, 0x01, 0x06, 0x03, 0x08, 0x00, 0x00, 0x00),
    0x0000,
    UInt32,
    required,
    false,
    JPEG2000PictureSubDescriptor)
  MXF_PROPERTY(YTOsiz,
    // 06.0e.2b.34.01.01.01.0a.04.01.06.03.09.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a,
              0x04, 0x01, 0x06, 0x03, 0x09, 0x00, 0x00, 0x00),
    0x0000,
    UInt32,
    required,
    false,
    JPEG2000PictureSubDescriptor)
  MXF_PROPERTY(Csiz,
    // 06.0e.2b.34.01.01.01.0a.04.01.06.03.0a.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a,
              0x04, 0x01, 0x06, 0x03, 0x0a, 0x00, 0x00, 0x00),
    0x0000,
    UInt16,
    required,
    false,
    JPEG2000PictureSubDescriptor)
  MXF_PROPERTY(PictureComponentSizing,
    // 06.0e.2b.34.01.01.01.0a.04.01.06.03.0b.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a,
              0x04, 0x01, 0x06, 0x03, 0x0b, 0x00, 0x00, 0x00),
    0x0000,
    subVector,
    required,
    false,
    JPEG2000PictureSubDescriptor)
  MXF_PROPERTY(CodingStyleDefault,
    // 06.0e.2b.34.01.01.01.0a.04.01.06.03.0c.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a,
              0x04, 0x01, 0x06, 0x03, 0x0c, 0x00, 0x00, 0x00),
    0x0000,
    CodingStyleDefault,
    optional,
    false,
    JPEG2000PictureSubDescriptor)
  MXF_PROPERTY(QuantizationDefault,
    // 06.0e.2b.34.01.01.01.0a.04.01.06.03.0d.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a,
              0x04, 0x01, 0x06, 0x03, 0x0d, 0x00, 0x00, 0x00),
    0x0000,
    QuantizationDefault,
    optional,
    false,
    JPEG2000PictureSubDescriptor)
MXF_CLASS_END(JPEG2000PictureSubDescriptor,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x01, 0x01, 0x5a, 0x00),
  InterchangeObject,
  true)
MXF_CLASS_SEPARATOR()

// Root
//
MXF_CLASS(Root,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.03.00.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00),
  InterchangeObject,
  true)
  MXF_PROPERTY(InstanceUID,
    // 06.0e.2b.34.01.01.01.01.01.01.15.02.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x01, 0x01, 0x15, 0x02, 0x00, 0x00, 0x00, 0x00),
    0x3c0a,
    UUID,
    required,
    false,
    InterchangeObject)
  MXF_PROPERTY(Preface,
    // 06.0e.2b.34.01.01.01.0a.06.01.01.07.17.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a,
              0x06, 0x01, 0x01, 0x07, 0x17, 0x00, 0x00, 0x00),
    0x0000,
    UUID,
    required,
    false,
    Root)
  MXF_PROPERTY(Extensions,
    // 06.0e.2b.34.01.01.01.0c.06.01.01.07.1a.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0c,
              0x06, 0x01, 0x01, 0x07, 0x1a, 0x00, 0x00, 0x00),
    0x0000,
    subVector,
    required,
    false,
    Root)
  MXF_PROPERTY(FormatVersion,
    // 06.0e.2b.34.01.01.01.0a.06.01.01.07.19.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0a,
              0x06, 0x01, 0x01, 0x07, 0x19, 0x00, 0x00, 0x00),
    0x0000,
    UInt32,
    optional,
    false,
    Root)
MXF_CLASS_END(Root,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x03, 0x00, 0x00, 0x00),
  InterchangeObject,
  true)
MXF_CLASS_SEPARATOR()

// ExtensionScheme
//
MXF_CLASS(ExtensionScheme,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.02.26.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x26, 0x00, 0x00),
  InterchangeObject,
  true)
  MXF_PROPERTY(InstanceUID,
    // 06.0e.2b.34.01.01.01.01.01.01.15.02.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x01, 0x01, 0x15, 0x02, 0x00, 0x00, 0x00, 0x00),
    0x3c0a,
    UUID,
    required,
    false,
    InterchangeObject)
  MXF_PROPERTY(ExtensionSchemeID,
    // 06.0e.2b.34.01.01.01.0c.06.01.01.07.1b.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0c,
              0x06, 0x01, 0x01, 0x07, 0x1b, 0x00, 0x00, 0x00),
    0x0000,
    AUID,
    required,
    false,
    ExtensionScheme)
  MXF_PROPERTY(SymbolSpaceURI,
    // 06.0e.2b.34.01.01.01.0c.06.01.01.07.1c.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0c,
              0x06, 0x01, 0x01, 0x07, 0x1c, 0x00, 0x00, 0x00),
    0x0000,
    String,
    required,
    false,
    ExtensionScheme)
  MXF_PROPERTY(PreferredPrefix,
    // 06.0e.2b.34.01.01.01.0c.06.01.01.07.1d.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0c,
              0x06, 0x01, 0x01, 0x07, 0x1d, 0x00, 0x00, 0x00),
    0x0000,
    String,
    optional,
    false,
    ExtensionScheme)
  MXF_PROPERTY(ExtensionDescription,
    // 06.0e.2b.34.01.01.01.0c.06.01.01.07.1e.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0c,
              0x06, 0x01, 0x01, 0x07, 0x1e, 0x00, 0x00, 0x00),
    0x0000,
    String,
    optional,
    false,
    ExtensionScheme)
  MXF_PROPERTY(MetaDefinitions,
    // 06.0e.2b.34.01.01.01.0c.06.01.01.07.1f.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x0c,
              0x06, 0x01, 0x01, 0x07, 0x1f, 0x00, 0x00, 0x00),
    0x0000,
    subVector,
    optional,
    false,
    ExtensionScheme)
MXF_CLASS_END(ExtensionScheme,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x26, 0x00, 0x00),
  InterchangeObject,
  true)
MXF_CLASS_SEPARATOR()

// MetaDefinition
//
MXF_CLASS(MetaDefinition,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.02.24.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x24, 0x00, 0x00),
  InterchangeObject,
  true)
  MXF_PROPERTY(InstanceUID,
    // 06.0e.2b.34.01.01.01.01.01.01.15.02.00.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x01,
              0x01, 0x01, 0x15, 0x02, 0x00, 0x00, 0x00, 0x00),
    0x3c0a,
    UUID,
    required,
    false,
    InterchangeObject)
  MXF_PROPERTY(Identification,
    // 06.0e.2b.34.01.01.01.02.06.01.01.07.13.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x06, 0x01, 0x01, 0x07, 0x13, 0x00, 0x00, 0x00),
    0x0000,
    AUID,
    required,
    false,
    MetaDefinition)
  MXF_PROPERTY(Name,
    // 06.0e.2b.34.01.01.01.02.03.02.04.01.02.01.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x03, 0x02, 0x04, 0x01, 0x02, 0x01, 0x00, 0x00),
    0x0000,
    String,
    required,
    false,
    MetaDefinition)
  MXF_PROPERTY(Description,
    // 06.0E.2B.34.01.01.01.02.06.01.01.07.14.01.00.00
    MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x06, 0x01, 0x01, 0x07, 0x14, 0x01, 0x00, 0x00),
    0x0000,
    String,
    optional,
    false,
    MetaDefinition)
MXF_CLASS_END(MetaDefinition,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x24, 0x00, 0x00),
  InterchangeObject,
  true)
MXF_CLASS_SEPARATOR()

// ClassDefinition
//
MXF_CLASS(ClassDefinition,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.02.01.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x01, 0x00, 0x00),
  MetaDefinition,
  true)
  MXF_PROPERTY(ParentClass,
    // 06.0E.2B.34.01.01.01.02.06.01.01.07.01.00.00.00
    MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x06, 0x01, 0x01, 0x07, 0x01, 0x00, 0x00, 0x00),
    0x0008,
    AUID,
    required,
    false,
    ClassDefinition)
  MXF_PROPERTY(IsConcrete,
    // 06.0E.2B.34.01.01.01.02.06.01.01.07.03.00.00.00
    MXF_LABEL(0x06, 0x0E, 0x2B, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x06, 0x01, 0x01, 0x07, 0x03, 0x00, 0x00, 0x00),
    0x000a,
    Boolean,
    required,
    false,
    ClassDefinition)
MXF_CLASS_END(ClassDefinition,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x01, 0x00, 0x00),
  MetaDefinition,
  true)
MXF_CLASS_SEPARATOR()

// PropertyDefinition
//
MXF_CLASS(PropertyDefinition,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.02.02.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x02, 0x00, 0x00),
  MetaDefinition,
  true)
  MXF_PROPERTY(PropertyType,
    // 06.0e.2b.34.01.01.01.02.06.01.01.07.04.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x06, 0x01, 0x01, 0x07, 0x04, 0x00, 0x00, 0x00),
    0x000b,
    AUID,
    required,
    false,
    PropertyDefinition)
  MXF_PROPERTY(IsOptional,
    // 06.0e.2b.34.01.01.01.02.03.01.02.02.01.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x03, 0x01, 0x02, 0x02, 0x01, 0x00, 0x00, 0x00),
    0x000c,
    Boolean,
    required,
    false,
    PropertyDefinition)
  MXF_PROPERTY(IsUniqueIdentifier,
    // 06.0e.2b.34.01.01.01.02.06.01.01.07.06.00.00.00
    MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x01, 0x01, 0x01, 0x02,
              0x06, 0x01, 0x01, 0x07, 0x06, 0x00, 0x00, 0x00),
    0x000e,
    Boolean,
    required,
    false,
    PropertyDefinition)
MXF_CLASS_END(PropertyDefinition,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x02, 0x00, 0x00),
  MetaDefinition,
  true)
MXF_CLASS_SEPARATOR()

// PropertyReuseDefinition
//
MXF_CLASS(PropertyReuseDefinition,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.02.27.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x27, 0x00, 0x00),
  PropertyDefinition,
  true)
MXF_CLASS_END(PropertyReuseDefinition,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x27, 0x00, 0x00),
  PropertyDefinition,
  true)
MXF_CLASS_SEPARATOR()

// TypeDefinition
//
MXF_CLASS(TypeDefinition,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.02.03.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x03, 0x00, 0x00),
  MetaDefinition,
  true)
MXF_CLASS_END(TypeDefinition,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x03, 0x00, 0x00),
  MetaDefinition,
  true)
MXF_CLASS_SEPARATOR()

// TypeDefinitionInteger
//
MXF_CLASS(TypeDefinitionInteger,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.02.04.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x04, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_END(TypeDefinitionInteger,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x04, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_SEPARATOR()

// TypeDefinitionStrongObjectReference
//
MXF_CLASS(TypeDefinitionStrongObjectReference,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.02.05.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x05, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_END(TypeDefinitionStrongObjectReference,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x05, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_SEPARATOR()

// TypeDefinitionWeakObjectReference
//
MXF_CLASS(TypeDefinitionWeakObjectReference,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.02.06.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x06, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_END(TypeDefinitionWeakObjectReference,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x06, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_SEPARATOR()

// TypeDefinitionEnumeration
//
MXF_CLASS(TypeDefinitionEnumeration,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.02.07.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x07, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_END(TypeDefinitionEnumeration,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x07, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_SEPARATOR()

// TypeDefinitionFixedArray
//
MXF_CLASS(TypeDefinitionFixedArray,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.02.08.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x08, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_END(TypeDefinitionFixedArray,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x08, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_SEPARATOR()

// TypeDefinitionVariableArray
//
MXF_CLASS(TypeDefinitionVariableArray,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.02.09.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x09, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_END(TypeDefinitionVariableArray,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x09, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_SEPARATOR()

// TypeDefinitionSet
//
MXF_CLASS(TypeDefinitionSet,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.02.0a.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x0a, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_END(TypeDefinitionSet,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x0a, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_SEPARATOR()

// TypeDefinitionString
//
MXF_CLASS(TypeDefinitionString,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.02.0b.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x0b, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_END(TypeDefinitionString,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x0b, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_SEPARATOR()

// TypeDefinitionStream
//
MXF_CLASS(TypeDefinitionStream,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.02.0c.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x0c, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_END(TypeDefinitionStream,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x0c, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_SEPARATOR()

// TypeDefinitionRecord
//
MXF_CLASS(TypeDefinitionRecord,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.02.0d.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x0d, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_END(TypeDefinitionRecord,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x0d, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_SEPARATOR()

// TypeDefinitionRename
//
MXF_CLASS(TypeDefinitionRename,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.02.0e.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x0e, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_END(TypeDefinitionRename,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x0e, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_SEPARATOR()

// TypeDefinitionExtendibleEnumeration
//
MXF_CLASS(TypeDefinitionExtendibleEnumeration,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.02.20.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x20, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_END(TypeDefinitionExtendibleEnumeration,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x20, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_SEPARATOR()

// TypeDefinitionIndirect
//
MXF_CLASS(TypeDefinitionIndirect,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.02.21.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x21, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_END(TypeDefinitionIndirect,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x21, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_SEPARATOR()

// TypeDefinitionOpaque
//
MXF_CLASS(TypeDefinitionOpaque,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.02.22.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x22, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_END(TypeDefinitionOpaque,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x22, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_SEPARATOR()

// TypeDefinitionCharacter
//
MXF_CLASS(TypeDefinitionCharacter,
  // 06.0e.2b.34.02.53.01.01.0d.01.01.01.02.23.00.00
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x23, 0x00, 0x00),
  TypeDefinition,
  true)
MXF_CLASS_END(TypeDefinitionCharacter,
  MXF_LABEL(0x06, 0x0e, 0x2b, 0x34, 0x02, 0x53, 0x01, 0x01,
            0x0d, 0x01, 0x01, 0x01, 0x02, 0x23, 0x00, 0x00),
  TypeDefinition,
  true)

MXF_TABLE_END()

#undef MXF_LABEL

#undef MXF_DEFINE_KEY

#undef MXF_DEFINE_PACK_KEY

#undef MXF_TABLE_BEGIN

#undef MXF_TABLE_END

#undef MXF_CLASS

#undef MXF_CLASS_END

#undef MXF_CLASS_SEPARATOR

#undef MXF_PROPERTY

//
// End of automatically generated file.
