# IMF JPEG 2000 Track Files

The [IMF Flavour](./imf_track_files.md) of `bmxtranswrap` and `raw2bmx` can be used to create Image Track Files conforming to [IMF Application #2E](https://ieeexplore.ieee.org/document/9097487) and [IMF Application #2E Amendment 1](https://ieeexplore.ieee.org/document/9286959).

JPEG 2000 is a video compression standard. It is a successor to the JPEG standard that uses a Discrete Wavelet Transform (DWT) rather than a Discrete Cosine Transform (DCT). The JPEG 2000 core video compression is specified in [ISO/IEC 15444-1](http://www.iso.org/iso/catalogue_detail.htm?csnumber=37674) / [ITU T.800](https://www.itu.int/rec/T-REC-T.800).

The wrapping of JPEG 2000 codestreams in MXF is specified in [SMPTE ST 422](https://ieeexplore.ieee.org/document/8984770).

The implementation currently supports MXF OP1a (IMF or vanilla flavour), YCbCr and RGB component video using a progressive frame layout.

## MXF Wrapping Tools

The `raw2bmx` tool can be used to wrap JPEG 2000 codestreams in MXF. There are 2 options for specifying a JPEG 2000 codestream input,

* `--j2c_cdci`: input contains JPEG 2000 coded YCbCr video, requiring an MXF CDCI file descriptor
* `--j2c_rgba`: input contains JPEG 2000 coded RGB video, requiring an MXF RGBA file descriptor

The input argument is either a name for a file containing all frames or a file pattern that identifies a sequence of frame files.

The file pattern must include a `%d` to specify the location of the integer number in the file name; the number determines the file order. For example `--j2c_cdci inputs/frame_%d.j2c` can be used for an `inputs/` directory containing files `frame_0001.j2c`, `frame_0002.j2c`, `frame_0003.j2c`, etc.

The `--fill-pattern-gaps` option can be used to fill in gaps in the file numbers by repeating the previous frame. This is useful for static content such as colour bars. For example, frames 2 to 49 are generated by repeating the contents of `frame_0001.j2c` when given `frame_0001.j2c`, `frame_0050.j2c`, `frame_0051.j2c`, etc. as inputs.

Below is an example commandline for generating an IMF Track File containing [ITU-R BT.2100](https://www.itu.int/rec/R-REC-BT.2100) UHD, HLG transfer function, 25Hz, YCbCr video,

```bash
   raw2bmx \
        -t imf \
        -o {Type}_{fp_uuid}.mxf \
        --clip "YCbCr example" \
        -f 25 \
        -a 16:9 \
        --frame-layout fullframe \
        --transfer-ch hlg \
        --coding-eq bt2020 \
        --color-prim bt2020 \
        --color-siting cositing \
        --black-level 64 \
        --white-level 940 \
        --color-range 897 \
        --display-primaries 35400,14600,8500,39850,6550,2300 \
        --display-white-point 15635,16450 \
        --display-max-luma 10000000 \
        --display-min-luma 50 \
        --fill-pattern-gaps \
        --j2c_cdci ycbcr_input/frame_%d.j2c
```

The JPEG 2000 codestream does not include a frame rate and that's why the `-f 25` option is used to specify 25 Hz. The same applies to the other options that are there to provide metadata that does not exist in the codestream.

This example also includes mastering display color volume metadata (`--display-xxx`) as specified in [IMF Application #2E Amendment 1](https://ieeexplore.ieee.org/document/9286959).

A similar commandline for RGB is shown below, where the main difference is the use of component reference levels and scanning direction options.

```bash
    raw2bmx \
        -t imf \
        -o {Type}_{fp_uuid}.mxf \
        --clip "RGB example" \
        -f 25 \
        -a 16:9 \
        --frame-layout fullframe \
        --transfer-ch hlg \
        --coding-eq bt2020 \
        --color-prim bt2020 \
        --comp-max-ref 940 \
        --comp-min-ref 64 \
        --scan-dir 0 \
        --display-primaries 35400,14600,8500,39850,6550,2300 \
        --display-white-point 15635,16450 \
        --display-max-luma 10000000 \
        --display-min-luma 50 \
        --fill-pattern-gaps \
        --j2c_rgba rgb_inputs/frame_%d.j2c
```

The `bmxtranswrap` tool can be used to re-wrap an input MXF file to another MXF file. It has options to set or override metadata. An example commandline is shown below,

```bash
    bmxtranswrap \
        -t imf \
        -o {Type}_{fp_uuid}.mxf \
        --clip "A re-wrapped example" \
        --transfer-ch hlg \
        --display-primaries 35400,14600,8500,39850,6550,2300 \
        --display-white-point 15635,16450 \
        --display-max-luma 10000000 \
        --display-min-luma 50 \
        input.mxf
```

In this example the transfer function (/characteristic) was corrected to be *HLG* and mastering display color volume metadata was added.

## Analysis and Extraction Tools

The `j2cdump` tool can be used to output a text dump of a JPEG 2000 codestream file. It is a useful tool for seeing the low-level syntax and metadata contained in the codestream. It is used to troubleshoot issues with source content.

The `bmxparse` tool provides a higher level metadata view of frames in a JPEG 2000 codestream file. It outputs the metadata parsed by the [J2CEssenceParser](../src/essence_parser/J2CEssenceParser.cpp) class. It is useful to show the metadata that is extracted by **bmx** for inclusion in the MXF wrapper.

The `jp2extract` tool can be used to extract JPEG 2000 codestreams from the *jp2c* box in a JP2 file as specified in ISO/IEC 15444-1 / ITU T.800 Annex I. Metadata that was included in the JP2 wrapper will need to be manually transferred to the MXF wrapper using the `raw2bmx` commandline options.
