// Code generated by Wire. DO NOT EDIT.

//go:generate go run -mod=mod github.com/google/wire/cmd/wire
//go:build !wireinject
// +build !wireinject

package concurrent

import (
	"github.com/bradfitz/gomemcache/memcache"
	"github.com/concrnt/concrnt/client"
	"github.com/concrnt/concrnt/core"
	"github.com/concrnt/concrnt/x/ack"
	"github.com/concrnt/concrnt/x/association"
	"github.com/concrnt/concrnt/x/auth"
	"github.com/concrnt/concrnt/x/domain"
	"github.com/concrnt/concrnt/x/entity"
	"github.com/concrnt/concrnt/x/job"
	"github.com/concrnt/concrnt/x/jwt"
	"github.com/concrnt/concrnt/x/key"
	"github.com/concrnt/concrnt/x/message"
	"github.com/concrnt/concrnt/x/notification"
	"github.com/concrnt/concrnt/x/policy"
	"github.com/concrnt/concrnt/x/profile"
	"github.com/concrnt/concrnt/x/schema"
	"github.com/concrnt/concrnt/x/semanticid"
	"github.com/concrnt/concrnt/x/store"
	"github.com/concrnt/concrnt/x/subscription"
	"github.com/concrnt/concrnt/x/timeline"
	"github.com/concrnt/concrnt/x/userkv"
	"github.com/google/wire"
	"github.com/redis/go-redis/v9"
	"gorm.io/gorm"
)

// Injectors from wire.go:

func SetupPolicyService(rdb *redis.Client, client2 client.Client, globalPolicy core.Policy, config core.Config) core.PolicyService {
	repository := policy.NewRepository(rdb)
	policyService := policy.NewService(repository, client2, globalPolicy, config)
	return policyService
}

func SetupJwtService(rdb *redis.Client) jwt.Service {
	repository := jwt.NewRepository(rdb)
	service := jwt.NewService(repository)
	return service
}

func SetupJobService(db *gorm.DB) core.JobService {
	repository := job.NewRepository(db)
	jobService := job.NewService(repository)
	return jobService
}

func SetupAckService(db *gorm.DB, rdb *redis.Client, mc *memcache.Client, client2 client.Client, policy2 core.PolicyService, config core.Config) core.AckService {
	repository := ack.NewRepository(db)
	entityService := SetupEntityService(db, rdb, mc, client2, policy2, config)
	keyService := SetupKeyService(db, rdb, mc, client2, config)
	ackService := ack.NewService(repository, client2, entityService, keyService, config)
	return ackService
}

func SetupKeyService(db *gorm.DB, rdb *redis.Client, mc *memcache.Client, client2 client.Client, config core.Config) core.KeyService {
	repository := key.NewRepository(db, mc, client2)
	keyService := key.NewService(repository, config)
	return keyService
}

func SetupMessageService(db *gorm.DB, rdb *redis.Client, mc *memcache.Client, keeper timeline.Keeper, client2 client.Client, policy2 core.PolicyService, config core.Config) core.MessageService {
	schemaService := SetupSchemaService(db)
	repository := message.NewRepository(db, mc, schemaService)
	entityService := SetupEntityService(db, rdb, mc, client2, policy2, config)
	domainService := SetupDomainService(db, client2, config)
	timelineService := SetupTimelineService(db, rdb, mc, keeper, client2, policy2, config)
	keyService := SetupKeyService(db, rdb, mc, client2, config)
	messageService := message.NewService(repository, client2, entityService, domainService, timelineService, keyService, policy2, config)
	return messageService
}

func SetupProfileService(db *gorm.DB, rdb *redis.Client, mc *memcache.Client, client2 client.Client, policy2 core.PolicyService, config core.Config) core.ProfileService {
	schemaService := SetupSchemaService(db)
	repository := profile.NewRepository(db, mc, schemaService)
	entityService := SetupEntityService(db, rdb, mc, client2, policy2, config)
	semanticIDService := SetupSemanticidService(db)
	profileService := profile.NewService(repository, entityService, policy2, semanticIDService)
	return profileService
}

func SetupAssociationService(db *gorm.DB, rdb *redis.Client, mc *memcache.Client, keeper timeline.Keeper, client2 client.Client, policy2 core.PolicyService, config core.Config) core.AssociationService {
	schemaService := SetupSchemaService(db)
	repository := association.NewRepository(db, mc, schemaService)
	entityService := SetupEntityService(db, rdb, mc, client2, policy2, config)
	domainService := SetupDomainService(db, client2, config)
	profileService := SetupProfileService(db, rdb, mc, client2, policy2, config)
	timelineService := SetupTimelineService(db, rdb, mc, keeper, client2, policy2, config)
	subscriptionService := SetupSubscriptionService(db, rdb, mc, client2, policy2, config)
	messageService := SetupMessageService(db, rdb, mc, keeper, client2, policy2, config)
	keyService := SetupKeyService(db, rdb, mc, client2, config)
	associationService := association.NewService(repository, client2, entityService, domainService, profileService, timelineService, subscriptionService, messageService, keyService, policy2, config)
	return associationService
}

func SetupTimelineService(db *gorm.DB, rdb *redis.Client, mc *memcache.Client, keeper timeline.Keeper, client2 client.Client, policy2 core.PolicyService, config core.Config) core.TimelineService {
	schemaService := SetupSchemaService(db)
	repository := timeline.NewRepository(db, rdb, mc, keeper, client2, schemaService, config)
	entityService := SetupEntityService(db, rdb, mc, client2, policy2, config)
	domainService := SetupDomainService(db, client2, config)
	semanticIDService := SetupSemanticidService(db)
	subscriptionService := SetupSubscriptionService(db, rdb, mc, client2, policy2, config)
	timelineService := timeline.NewService(repository, entityService, domainService, semanticIDService, subscriptionService, policy2, config)
	return timelineService
}

func SetupDomainService(db *gorm.DB, client2 client.Client, config core.Config) core.DomainService {
	repository := domain.NewRepository(db)
	domainService := domain.NewService(repository, client2, config)
	return domainService
}

func SetupEntityService(db *gorm.DB, rdb *redis.Client, mc *memcache.Client, client2 client.Client, policy2 core.PolicyService, config core.Config) core.EntityService {
	schemaService := SetupSchemaService(db)
	repository := entity.NewRepository(db, mc, schemaService)
	keyService := SetupKeyService(db, rdb, mc, client2, config)
	service := SetupJwtService(rdb)
	entityService := entity.NewService(repository, client2, config, keyService, policy2, service)
	return entityService
}

func SetupAuthService(db *gorm.DB, rdb *redis.Client, mc *memcache.Client, client2 client.Client, policy2 core.PolicyService, config core.Config) core.AuthService {
	entityService := SetupEntityService(db, rdb, mc, client2, policy2, config)
	domainService := SetupDomainService(db, client2, config)
	keyService := SetupKeyService(db, rdb, mc, client2, config)
	authService := auth.NewService(rdb, config, entityService, domainService, keyService, policy2)
	return authService
}

func SetupUserkvService(db *gorm.DB) userkv.Service {
	repository := userkv.NewRepository(db)
	service := userkv.NewService(repository)
	return service
}

func SetupSchemaService(db *gorm.DB) core.SchemaService {
	repository := schema.NewRepository(db)
	schemaService := schema.NewService(repository)
	return schemaService
}

func SetupStoreService(db *gorm.DB, rdb *redis.Client, mc *memcache.Client, keeper timeline.Keeper, client2 client.Client, policy2 core.PolicyService, config core.Config, repositoryPath string) core.StoreService {
	repository := store.NewRepository(db, rdb)
	keyService := SetupKeyService(db, rdb, mc, client2, config)
	entityService := SetupEntityService(db, rdb, mc, client2, policy2, config)
	messageService := SetupMessageService(db, rdb, mc, keeper, client2, policy2, config)
	associationService := SetupAssociationService(db, rdb, mc, keeper, client2, policy2, config)
	profileService := SetupProfileService(db, rdb, mc, client2, policy2, config)
	timelineService := SetupTimelineService(db, rdb, mc, keeper, client2, policy2, config)
	ackService := SetupAckService(db, rdb, mc, client2, policy2, config)
	subscriptionService := SetupSubscriptionService(db, rdb, mc, client2, policy2, config)
	semanticIDService := SetupSemanticidService(db)
	storeService := store.NewService(repository, keyService, entityService, messageService, associationService, profileService, timelineService, ackService, subscriptionService, semanticIDService, config, repositoryPath)
	return storeService
}

func SetupSubscriptionService(db *gorm.DB, rdb *redis.Client, mc *memcache.Client, client2 client.Client, policy2 core.PolicyService, config core.Config) core.SubscriptionService {
	schemaService := SetupSchemaService(db)
	repository := subscription.NewRepository(db, schemaService)
	entityService := SetupEntityService(db, rdb, mc, client2, policy2, config)
	subscriptionService := subscription.NewService(repository, entityService, policy2)
	return subscriptionService
}

func SetupSemanticidService(db *gorm.DB) core.SemanticIDService {
	repository := semanticid.NewRepository(db)
	semanticIDService := semanticid.NewService(repository)
	return semanticIDService
}

func SetupNotificationService(db *gorm.DB) core.NotificationService {
	repo := notification.NewRepository(db)
	notificationService := notification.NewService(repo)
	return notificationService
}

// wire.go:

// Lv0
var jwtServiceProvider = wire.NewSet(jwt.NewService, jwt.NewRepository)

var schemaServiceProvider = wire.NewSet(schema.NewService, schema.NewRepository)

var domainServiceProvider = wire.NewSet(domain.NewService, domain.NewRepository)

var semanticidServiceProvider = wire.NewSet(semanticid.NewService, semanticid.NewRepository)

var userKvServiceProvider = wire.NewSet(userkv.NewService, userkv.NewRepository)

var policyServiceProvider = wire.NewSet(policy.NewService, policy.NewRepository)

var keyServiceProvider = wire.NewSet(key.NewService, key.NewRepository)

var jobServiceProvider = wire.NewSet(job.NewService, job.NewRepository)

// Lv1
var entityServiceProvider = wire.NewSet(entity.NewService, entity.NewRepository, SetupJwtService, SetupSchemaService, SetupKeyService)

// Lv2
var timelineServiceProvider = wire.NewSet(timeline.NewService, timeline.NewRepository, SetupEntityService, SetupDomainService, SetupSchemaService, SetupSemanticidService, SetupSubscriptionService)

var subscriptionServiceProvider = wire.NewSet(subscription.NewService, subscription.NewRepository, SetupSchemaService, SetupEntityService)

// Lv3
var profileServiceProvider = wire.NewSet(profile.NewService, profile.NewRepository, SetupEntityService, SetupKeyService, SetupSchemaService, SetupSemanticidService)

var authServiceProvider = wire.NewSet(auth.NewService, SetupEntityService, SetupDomainService, SetupKeyService)

var ackServiceProvider = wire.NewSet(ack.NewService, ack.NewRepository, SetupEntityService, SetupKeyService)

// Lv4
var messageServiceProvider = wire.NewSet(message.NewService, message.NewRepository, SetupEntityService, SetupDomainService, SetupTimelineService, SetupKeyService, SetupSchemaService)

// Lv5
var associationServiceProvider = wire.NewSet(association.NewService, association.NewRepository, SetupEntityService, SetupDomainService, SetupTimelineService, SetupMessageService, SetupKeyService, SetupSchemaService, SetupProfileService, SetupSubscriptionService)

// Lv6
var storeServiceProvider = wire.NewSet(store.NewService, store.NewRepository, SetupKeyService,
	SetupMessageService,
	SetupAssociationService,
	SetupProfileService,
	SetupEntityService,
	SetupTimelineService,
	SetupAckService,
	SetupSubscriptionService,
	SetupSemanticidService,
)

// other
var notificationServiceProvider = wire.NewSet(notification.NewService, notification.NewRepository)
