/*
Copyright 2018 The Rook Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"

	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	scheme "github.com/rook/rook/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// CephBucketTopicsGetter has a method to return a CephBucketTopicInterface.
// A group's client should implement this interface.
type CephBucketTopicsGetter interface {
	CephBucketTopics(namespace string) CephBucketTopicInterface
}

// CephBucketTopicInterface has methods to work with CephBucketTopic resources.
type CephBucketTopicInterface interface {
	Create(ctx context.Context, cephBucketTopic *v1.CephBucketTopic, opts metav1.CreateOptions) (*v1.CephBucketTopic, error)
	Update(ctx context.Context, cephBucketTopic *v1.CephBucketTopic, opts metav1.UpdateOptions) (*v1.CephBucketTopic, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.CephBucketTopic, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.CephBucketTopicList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.CephBucketTopic, err error)
	CephBucketTopicExpansion
}

// cephBucketTopics implements CephBucketTopicInterface
type cephBucketTopics struct {
	*gentype.ClientWithList[*v1.CephBucketTopic, *v1.CephBucketTopicList]
}

// newCephBucketTopics returns a CephBucketTopics
func newCephBucketTopics(c *CephV1Client, namespace string) *cephBucketTopics {
	return &cephBucketTopics{
		gentype.NewClientWithList[*v1.CephBucketTopic, *v1.CephBucketTopicList](
			"cephbuckettopics",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *v1.CephBucketTopic { return &v1.CephBucketTopic{} },
			func() *v1.CephBucketTopicList { return &v1.CephBucketTopicList{} }),
	}
}
