/*
Copyright 2018 The Rook Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"

	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	scheme "github.com/rook/rook/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// CephObjectStoreUsersGetter has a method to return a CephObjectStoreUserInterface.
// A group's client should implement this interface.
type CephObjectStoreUsersGetter interface {
	CephObjectStoreUsers(namespace string) CephObjectStoreUserInterface
}

// CephObjectStoreUserInterface has methods to work with CephObjectStoreUser resources.
type CephObjectStoreUserInterface interface {
	Create(ctx context.Context, cephObjectStoreUser *v1.CephObjectStoreUser, opts metav1.CreateOptions) (*v1.CephObjectStoreUser, error)
	Update(ctx context.Context, cephObjectStoreUser *v1.CephObjectStoreUser, opts metav1.UpdateOptions) (*v1.CephObjectStoreUser, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.CephObjectStoreUser, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.CephObjectStoreUserList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.CephObjectStoreUser, err error)
	CephObjectStoreUserExpansion
}

// cephObjectStoreUsers implements CephObjectStoreUserInterface
type cephObjectStoreUsers struct {
	*gentype.ClientWithList[*v1.CephObjectStoreUser, *v1.CephObjectStoreUserList]
}

// newCephObjectStoreUsers returns a CephObjectStoreUsers
func newCephObjectStoreUsers(c *CephV1Client, namespace string) *cephObjectStoreUsers {
	return &cephObjectStoreUsers{
		gentype.NewClientWithList[*v1.CephObjectStoreUser, *v1.CephObjectStoreUserList](
			"cephobjectstoreusers",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *v1.CephObjectStoreUser { return &v1.CephObjectStoreUser{} },
			func() *v1.CephObjectStoreUserList { return &v1.CephObjectStoreUserList{} }),
	}
}
