/*
Copyright 2018 The Rook Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeCephObjectRealms implements CephObjectRealmInterface
type FakeCephObjectRealms struct {
	Fake *FakeCephV1
	ns   string
}

var cephobjectrealmsResource = v1.SchemeGroupVersion.WithResource("cephobjectrealms")

var cephobjectrealmsKind = v1.SchemeGroupVersion.WithKind("CephObjectRealm")

// Get takes name of the cephObjectRealm, and returns the corresponding cephObjectRealm object, and an error if there is any.
func (c *FakeCephObjectRealms) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.CephObjectRealm, err error) {
	emptyResult := &v1.CephObjectRealm{}
	obj, err := c.Fake.
		Invokes(testing.NewGetActionWithOptions(cephobjectrealmsResource, c.ns, name, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.CephObjectRealm), err
}

// List takes label and field selectors, and returns the list of CephObjectRealms that match those selectors.
func (c *FakeCephObjectRealms) List(ctx context.Context, opts metav1.ListOptions) (result *v1.CephObjectRealmList, err error) {
	emptyResult := &v1.CephObjectRealmList{}
	obj, err := c.Fake.
		Invokes(testing.NewListActionWithOptions(cephobjectrealmsResource, cephobjectrealmsKind, c.ns, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.CephObjectRealmList{ListMeta: obj.(*v1.CephObjectRealmList).ListMeta}
	for _, item := range obj.(*v1.CephObjectRealmList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested cephObjectRealms.
func (c *FakeCephObjectRealms) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchActionWithOptions(cephobjectrealmsResource, c.ns, opts))

}

// Create takes the representation of a cephObjectRealm and creates it.  Returns the server's representation of the cephObjectRealm, and an error, if there is any.
func (c *FakeCephObjectRealms) Create(ctx context.Context, cephObjectRealm *v1.CephObjectRealm, opts metav1.CreateOptions) (result *v1.CephObjectRealm, err error) {
	emptyResult := &v1.CephObjectRealm{}
	obj, err := c.Fake.
		Invokes(testing.NewCreateActionWithOptions(cephobjectrealmsResource, c.ns, cephObjectRealm, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.CephObjectRealm), err
}

// Update takes the representation of a cephObjectRealm and updates it. Returns the server's representation of the cephObjectRealm, and an error, if there is any.
func (c *FakeCephObjectRealms) Update(ctx context.Context, cephObjectRealm *v1.CephObjectRealm, opts metav1.UpdateOptions) (result *v1.CephObjectRealm, err error) {
	emptyResult := &v1.CephObjectRealm{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateActionWithOptions(cephobjectrealmsResource, c.ns, cephObjectRealm, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.CephObjectRealm), err
}

// Delete takes name of the cephObjectRealm and deletes it. Returns an error if one occurs.
func (c *FakeCephObjectRealms) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(cephobjectrealmsResource, c.ns, name, opts), &v1.CephObjectRealm{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeCephObjectRealms) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewDeleteCollectionActionWithOptions(cephobjectrealmsResource, c.ns, opts, listOpts)

	_, err := c.Fake.Invokes(action, &v1.CephObjectRealmList{})
	return err
}

// Patch applies the patch and returns the patched cephObjectRealm.
func (c *FakeCephObjectRealms) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.CephObjectRealm, err error) {
	emptyResult := &v1.CephObjectRealm{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(cephobjectrealmsResource, c.ns, name, pt, data, opts, subresources...), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.CephObjectRealm), err
}
