/*
Copyright 2018 The Rook Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
)

// CephBucketNotificationLister helps list CephBucketNotifications.
// All objects returned here must be treated as read-only.
type CephBucketNotificationLister interface {
	// List lists all CephBucketNotifications in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephBucketNotification, err error)
	// CephBucketNotifications returns an object that can list and get CephBucketNotifications.
	CephBucketNotifications(namespace string) CephBucketNotificationNamespaceLister
	CephBucketNotificationListerExpansion
}

// cephBucketNotificationLister implements the CephBucketNotificationLister interface.
type cephBucketNotificationLister struct {
	listers.ResourceIndexer[*v1.CephBucketNotification]
}

// NewCephBucketNotificationLister returns a new CephBucketNotificationLister.
func NewCephBucketNotificationLister(indexer cache.Indexer) CephBucketNotificationLister {
	return &cephBucketNotificationLister{listers.New[*v1.CephBucketNotification](indexer, v1.Resource("cephbucketnotification"))}
}

// CephBucketNotifications returns an object that can list and get CephBucketNotifications.
func (s *cephBucketNotificationLister) CephBucketNotifications(namespace string) CephBucketNotificationNamespaceLister {
	return cephBucketNotificationNamespaceLister{listers.NewNamespaced[*v1.CephBucketNotification](s.ResourceIndexer, namespace)}
}

// CephBucketNotificationNamespaceLister helps list and get CephBucketNotifications.
// All objects returned here must be treated as read-only.
type CephBucketNotificationNamespaceLister interface {
	// List lists all CephBucketNotifications in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephBucketNotification, err error)
	// Get retrieves the CephBucketNotification from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.CephBucketNotification, error)
	CephBucketNotificationNamespaceListerExpansion
}

// cephBucketNotificationNamespaceLister implements the CephBucketNotificationNamespaceLister
// interface.
type cephBucketNotificationNamespaceLister struct {
	listers.ResourceIndexer[*v1.CephBucketNotification]
}
